/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.LDAPConstants;
import org.keycloak.storage.UserStorageProvider;

public class LDAPConfig {
    private final MultivaluedHashMap<String, String> config;
    private final Set<String> binaryAttributeNames = new HashSet<String>();

    public LDAPConfig(MultivaluedHashMap<String, String> config) {
        this.config = config;
    }

    public String getConnectionUrl() {
        return (String)this.config.getFirst((Object)"connectionUrl");
    }

    public String getFactoryName() {
        return "com.sun.jndi.ldap.LdapCtxFactory";
    }

    public String getAuthType() {
        String value = (String)this.config.getFirst((Object)"authType");
        if (value == null) {
            return "simple";
        }
        return value;
    }

    public boolean useExtendedPasswordModifyOp() {
        String value = (String)this.config.getFirst((Object)"usePasswordModifyExtendedOp");
        return Boolean.parseBoolean(value);
    }

    public String getUseTruststoreSpi() {
        return (String)this.config.getFirst((Object)"useTruststoreSpi");
    }

    public String getUsersDn() {
        String usersDn = (String)this.config.getFirst((Object)"usersDn");
        if (usersDn == null) {
            usersDn = (String)this.config.getFirst((Object)"userDnSuffix");
        }
        return usersDn;
    }

    public String getBaseDn() {
        return (String)this.config.getFirst((Object)"baseDn");
    }

    public Collection<String> getUserObjectClasses() {
        String objClassesCfg = (String)this.config.getFirst((Object)"userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson,organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        HashSet<String> userObjClasses = new HashSet<String>();
        for (int i = 0; i < objectClasses.length; ++i) {
            userObjClasses.add(objectClasses[i].trim());
        }
        return userObjClasses;
    }

    public String getBindDN() {
        return (String)this.config.getFirst((Object)"bindDn");
    }

    public String getBindCredential() {
        return (String)this.config.getFirst((Object)"bindCredential");
    }

    public String getVendor() {
        return (String)this.config.getFirst((Object)"vendor");
    }

    public boolean isActiveDirectory() {
        String vendor = this.getVendor();
        return vendor != null && vendor.equals("ad");
    }

    public boolean isValidatePasswordPolicy() {
        String validatePPolicy = (String)this.config.getFirst((Object)"validatePasswordPolicy");
        return Boolean.parseBoolean(validatePPolicy);
    }

    public boolean isTrustEmail() {
        String trustEmail = (String)this.config.getFirst((Object)"trustEmail");
        return Boolean.parseBoolean(trustEmail);
    }

    public String getConnectionPooling() {
        if (this.isStartTls()) {
            return null;
        }
        return (String)this.config.getFirst((Object)"connectionPooling");
    }

    public String getConnectionPoolingAuthentication() {
        return (String)this.config.getFirst((Object)"connectionPoolingAuthentication");
    }

    public String getConnectionPoolingDebug() {
        return (String)this.config.getFirst((Object)"connectionPoolingDebug");
    }

    public String getConnectionPoolingInitSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingInitSize");
    }

    public String getConnectionPoolingMaxSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingMaxSize");
    }

    public String getConnectionPoolingPrefSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingPrefSize");
    }

    public String getConnectionPoolingProtocol() {
        return (String)this.config.getFirst((Object)"connectionPoolingProtocol");
    }

    public String getConnectionPoolingTimeout() {
        return (String)this.config.getFirst((Object)"connectionPoolingTimeout");
    }

    public String getConnectionTimeout() {
        return (String)this.config.getFirst((Object)"connectionTimeout");
    }

    public String getReadTimeout() {
        return (String)this.config.getFirst((Object)"readTimeout");
    }

    public Properties getAdditionalConnectionProperties() {
        return null;
    }

    public int getSearchScope() {
        String searchScope = (String)this.config.getFirst((Object)"searchScope");
        return searchScope == null ? 2 : Integer.parseInt(searchScope);
    }

    public String getUuidLDAPAttributeName() {
        String uuidAttrName = (String)this.config.getFirst((Object)"uuidLDAPAttribute");
        if (uuidAttrName == null) {
            String vendor = this.getVendor();
            uuidAttrName = LDAPConstants.getUuidAttributeName((String)vendor);
        }
        return uuidAttrName;
    }

    public boolean isObjectGUID() {
        return this.getUuidLDAPAttributeName().equalsIgnoreCase("objectGUID");
    }

    public boolean isEdirectoryGUID() {
        return this.isEdirectory() && this.getUuidLDAPAttributeName().equalsIgnoreCase("guid");
    }

    public boolean isPagination() {
        String pagination = (String)this.config.getFirst((Object)"pagination");
        return Boolean.parseBoolean(pagination);
    }

    public int getMaxConditions() {
        String string = (String)this.config.getFirst((Object)"maxConditions");
        if (string != null) {
            try {
                int max = Integer.parseInt(string);
                if (max > 0) {
                    return max;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 64;
    }

    public int getBatchSizeForSync() {
        String pageSizeConfig = (String)this.config.getFirst((Object)"batchSizeForSync");
        return pageSizeConfig != null ? Integer.parseInt(pageSizeConfig) : 1000;
    }

    public String getUsernameLdapAttribute() {
        String username = (String)this.config.getFirst((Object)"usernameLDAPAttribute");
        if (username == null) {
            username = this.isActiveDirectory() ? "cn" : "uid";
        }
        return username;
    }

    public String getRdnLdapAttribute() {
        String rdn = (String)this.config.getFirst((Object)"rdnLDAPAttribute");
        if (rdn == null && (rdn = this.getUsernameLdapAttribute()).equalsIgnoreCase("sAMAccountName")) {
            rdn = "cn";
        }
        return rdn;
    }

    public String getCustomUserSearchFilter() {
        String customFilter = (String)this.config.getFirst((Object)"customUserSearchFilter");
        if (customFilter != null && (customFilter = customFilter.trim()).length() > 0) {
            return customFilter;
        }
        return null;
    }

    public boolean isStartTls() {
        return Boolean.parseBoolean((String)this.config.getFirst((Object)"startTls"));
    }

    public UserStorageProvider.EditMode getEditMode() {
        String editModeString = (String)this.config.getFirst((Object)"editMode");
        if (editModeString == null) {
            return UserStorageProvider.EditMode.READ_ONLY;
        }
        return UserStorageProvider.EditMode.valueOf((String)editModeString);
    }

    public String getReferral() {
        return (String)this.config.getFirst((Object)"referral");
    }

    public void addBinaryAttribute(String attrName) {
        this.binaryAttributeNames.add(attrName);
    }

    public Set<String> getBinaryAttributeNames() {
        return this.binaryAttributeNames;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LDAPConfig)) {
            return false;
        }
        LDAPConfig that = (LDAPConfig)obj;
        if (!this.config.equals(that.config)) {
            return false;
        }
        return this.binaryAttributeNames.equals(that.binaryAttributeNames);
    }

    public boolean isEdirectory() {
        return "edirectory".equalsIgnoreCase(this.getVendor());
    }

    public int hashCode() {
        return this.config.hashCode() * 13 + this.binaryAttributeNames.hashCode();
    }

    public String toString() {
        MultivaluedHashMap copy = new MultivaluedHashMap(this.config);
        copy.remove((Object)"bindCredential");
        return copy.toString() + ", binaryAttributes: " + this.binaryAttributeNames;
    }
}

