/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class ResourceUpdatedEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private String id;
    private String name;
    private String serverId;
    private String type;
    private Set<String> uris;
    private Set<String> scopes;
    private String owner;

    public static ResourceUpdatedEvent create(String id, String name, String type, Set<String> uris, Set<String> scopes, String serverId, String owner) {
        ResourceUpdatedEvent event = new ResourceUpdatedEvent();
        event.id = id;
        event.name = name;
        event.type = type;
        event.uris = uris;
        event.scopes = scopes;
        event.serverId = serverId;
        event.owner = owner;
        return event;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceUpdatedEvent that = (ResourceUpdatedEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.type, that.type) && Objects.equals(this.owner, that.owner);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.name, this.serverId, this.type, this.owner);
    }

    public String toString() {
        return String.format("ResourceUpdatedEvent [ id=%s, name=%s ]", this.id, this.name);
    }

    @Override
    public void addInvalidations(StoreFactoryCacheManager cache, Set<String> invalidations) {
        cache.resourceUpdated(this.id, this.name, this.type, this.uris, this.scopes, this.serverId, this.owner, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<ResourceUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ResourceUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.id, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.name, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.type, (ObjectOutput)output);
            KeycloakMarshallUtil.writeCollection(obj.uris, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeCollection(obj.scopes, KeycloakMarshallUtil.STRING_EXT, output);
            MarshallUtil.marshallString((String)obj.serverId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.owner, (ObjectOutput)output);
        }

        public ResourceUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ResourceUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ResourceUpdatedEvent res = new ResourceUpdatedEvent();
            res.id = MarshallUtil.unmarshallString((ObjectInput)input);
            res.name = MarshallUtil.unmarshallString((ObjectInput)input);
            res.type = MarshallUtil.unmarshallString((ObjectInput)input);
            res.uris = (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, HashSet::new);
            res.scopes = (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, HashSet::new);
            res.serverId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.owner = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

