/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.EmbeddedCachesChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.JpaChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.RemoteCachesChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;

public abstract class PersistentSessionsChangelogBasedTransaction<K, V extends SessionEntity>
extends AbstractKeycloakTransaction
implements SessionsChangelogBasedTransaction<K, V> {
    private static final Logger LOG = Logger.getLogger(PersistentSessionsChangelogBasedTransaction.class);
    protected final KeycloakSession kcSession;
    protected final Map<K, SessionUpdatesList<V>> updates = new HashMap<K, SessionUpdatesList<V>>();
    protected final Map<K, SessionUpdatesList<V>> offlineUpdates = new HashMap<K, SessionUpdatesList<V>>();
    private final List<SessionChangesPerformer<K, V>> changesPerformers;
    private final Cache<K, SessionEntityWrapper<V>> cache;
    private final Cache<K, SessionEntityWrapper<V>> offlineCache;
    private final SessionFunction<V> lifespanMsLoader;
    private final SessionFunction<V> maxIdleTimeMsLoader;
    private final SessionFunction<V> offlineLifespanMsLoader;
    private final SessionFunction<V> offlineMaxIdleTimeMsLoader;

    public PersistentSessionsChangelogBasedTransaction(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> cache, Cache<K, SessionEntityWrapper<V>> offlineCache, RemoteCacheInvoker remoteCacheInvoker, SessionFunction<V> lifespanMsLoader, SessionFunction<V> maxIdleTimeMsLoader, SessionFunction<V> offlineLifespanMsLoader, SessionFunction<V> offlineMaxIdleTimeMsLoader, ArrayBlockingQueue<PersistentUpdate> batchingQueue, SerializeExecutionsByKey<K> serializerOnline, SerializeExecutionsByKey<K> serializerOffline) {
        this.kcSession = session;
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            throw new IllegalStateException("Persistent user sessions are not enabled");
        }
        if (!(cache.getName().equals("sessions") || cache.getName().equals("clientSessions") || cache.getName().equals("offlineSessions") || cache.getName().equals("offlineClientSessions"))) {
            throw new IllegalStateException("Cache name is not valid for persistent user sessions: " + cache.getName());
        }
        this.changesPerformers = List.of(new JpaChangesPerformer(cache.getName(), batchingQueue), new EmbeddedCachesChangesPerformer<K, V>(cache, serializerOnline){

            @Override
            public boolean shouldConsumeChange(V entity) {
                return !((SessionEntity)entity).isOffline();
            }
        }, new EmbeddedCachesChangesPerformer<K, V>(offlineCache, serializerOffline){

            @Override
            public boolean shouldConsumeChange(V entity) {
                return ((SessionEntity)entity).isOffline();
            }
        }, new RemoteCachesChangesPerformer<K, V>(session, cache, remoteCacheInvoker){

            @Override
            public boolean shouldConsumeChange(V entity) {
                return !((SessionEntity)entity).isOffline();
            }
        }, new RemoteCachesChangesPerformer<K, V>(session, offlineCache, remoteCacheInvoker){

            @Override
            public boolean shouldConsumeChange(V entity) {
                return ((SessionEntity)entity).isOffline();
            }
        });
        this.cache = cache;
        this.offlineCache = offlineCache;
        this.lifespanMsLoader = lifespanMsLoader;
        this.maxIdleTimeMsLoader = maxIdleTimeMsLoader;
        this.offlineLifespanMsLoader = offlineLifespanMsLoader;
        this.offlineMaxIdleTimeMsLoader = offlineMaxIdleTimeMsLoader;
    }

    protected Cache<K, SessionEntityWrapper<V>> getCache(boolean offline) {
        if (offline) {
            return this.offlineCache;
        }
        return this.cache;
    }

    protected SessionFunction<V> getLifespanMsLoader(boolean offline) {
        if (offline) {
            return this.offlineLifespanMsLoader;
        }
        return this.lifespanMsLoader;
    }

    protected SessionFunction<V> getMaxIdleMsLoader(boolean offline) {
        if (offline) {
            return this.offlineMaxIdleTimeMsLoader;
        }
        return this.maxIdleTimeMsLoader;
    }

    protected Map<K, SessionUpdatesList<V>> getUpdates(boolean offline) {
        if (offline) {
            return this.offlineUpdates;
        }
        return this.updates;
    }

    public SessionEntityWrapper<V> get(K key, boolean offline) {
        SessionUpdatesList<Object> myUpdates = this.getUpdates(offline).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
            if (wrappedEntity == null) {
                return null;
            }
            ((SessionEntity)wrappedEntity.getEntity()).setOffline(offline);
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        V entity = myUpdates.getEntityWrapper().getEntity();
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    protected void commitImpl() {
        for (Map.Entry entry : Stream.concat(this.updates.entrySet().stream(), this.offlineUpdates.entrySet().stream()).toList()) {
            SessionUpdatesList sessionUpdates = (SessionUpdatesList)entry.getValue();
            SessionEntityWrapper sessionWrapper = sessionUpdates.getEntityWrapper();
            Object entity = sessionWrapper.getEntity();
            boolean isOffline = ((SessionEntity)entity).isOffline();
            if (sessionUpdates.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT) continue;
            RealmModel realm = sessionUpdates.getRealm();
            long lifespanMs = this.getLifespanMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            long maxIdleTimeMs = this.getMaxIdleMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            MergedUpdate merged = MergedUpdate.computeUpdate(sessionUpdates.getUpdateTasks(), sessionWrapper, lifespanMs, maxIdleTimeMs);
            if (merged == null) continue;
            this.changesPerformers.stream().filter(performer -> performer.shouldConsumeChange(entity)).forEach(p -> p.registerChange(entry, merged));
        }
        this.changesPerformers.forEach(SessionChangesPerformer::applyChanges);
    }

    @Override
    public void addTask(K key, SessionUpdateTask<V> originalTask) {
        if (!(originalTask instanceof PersistentSessionUpdateTask)) {
            throw new IllegalArgumentException("Task must be instance of PersistentSessionUpdateTask");
        }
        PersistentSessionUpdateTask task = (PersistentSessionUpdateTask)originalTask;
        SessionUpdatesList<Object> myUpdates = this.getUpdates(task.isOffline()).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(task.isOffline()).get(key);
            if (wrappedEntity == null) {
                LOG.tracef("Not present cache item for key %s", key);
                return;
            }
            ((SessionEntity)wrappedEntity.getEntity()).setOffline(task.isOffline());
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.getUpdates(task.isOffline()).put(key, myUpdates);
        }
        task.runUpdate(myUpdates.getEntityWrapper().getEntity());
        myUpdates.add(task);
    }

    public void addTask(K key, SessionUpdateTask<V> task, V entity, UserSessionModel.SessionPersistenceState persistenceState) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)entity).getRealmId());
        SessionEntityWrapper<V> wrappedEntity = new SessionEntityWrapper<V>(entity);
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity, persistenceState);
        this.getUpdates(((SessionEntity)entity).isOffline()).put(key, myUpdates);
        if (task != null) {
            task.runUpdate(entity);
            myUpdates.add(task);
        }
    }

    public void reloadEntityInCurrentTransaction(RealmModel realm, K key, SessionEntityWrapper<V> entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        boolean offline = ((SessionEntity)entity.getEntity()).isOffline();
        SessionEntityWrapper latestEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
        if (latestEntity == null) {
            return;
        }
        SessionUpdatesList newUpdates = new SessionUpdatesList(realm, latestEntity);
        SessionUpdatesList<V> existingUpdates = this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).get(key);
        if (existingUpdates != null) {
            newUpdates.setUpdateTasks(existingUpdates.getUpdateTasks());
        }
        this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).put(key, newUpdates);
    }

    protected void rollbackImpl() {
    }
}

