/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.SessionEntityUpdater;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RootAuthenticationSessionAdapter
implements RootAuthenticationSessionModel {
    private static final Logger log = Logger.getLogger(RootAuthenticationSessionAdapter.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final int authSessionsLimit;
    private final SessionEntityUpdater<RootAuthenticationSessionEntity> updater;
    private static final Comparator<Map.Entry<String, AuthenticationSessionEntity>> TIMESTAMP_COMPARATOR = Comparator.comparingInt(e -> ((AuthenticationSessionEntity)e.getValue()).getTimestamp());

    public RootAuthenticationSessionAdapter(KeycloakSession session, SessionEntityUpdater<RootAuthenticationSessionEntity> updater, RealmModel realm, int authSessionsLimit) {
        this.session = session;
        this.updater = updater;
        this.realm = realm;
        this.authSessionsLimit = authSessionsLimit;
    }

    void update() {
        this.updater.onEntityUpdated();
    }

    public String getId() {
        return this.updater.getEntity().getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return this.updater.getEntity().getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.updater.getEntity().setTimestamp(timestamp);
        this.update();
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        HashMap<String, AuthenticationSessionModel> result = new HashMap<String, AuthenticationSessionModel>();
        for (Map.Entry<String, AuthenticationSessionEntity> entry : this.updater.getEntity().getAuthenticationSessions().entrySet()) {
            String tabId = entry.getKey();
            result.put(tabId, new AuthenticationSessionAdapter(this.session, this, tabId, entry.getValue()));
        }
        return result;
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            this.session.getContext().setAuthenticationSession(authSession);
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        String tabId;
        Objects.requireNonNull(client, "client");
        Map<String, AuthenticationSessionEntity> authenticationSessions = this.updater.getEntity().getAuthenticationSessions();
        if (authenticationSessions.size() >= this.authSessionsLimit && (tabId = (String)authenticationSessions.entrySet().stream().min(TIMESTAMP_COMPARATOR).map(Map.Entry::getKey).orElse(null)) != null) {
            log.debugf("Reached limit (%s) of active authentication sessions per a root authentication session. Removing oldest authentication session with TabId %s.", this.authSessionsLimit, (Object)tabId);
            authenticationSessions.remove(tabId);
        }
        AuthenticationSessionEntity authSessionEntity = new AuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        int timestamp = Time.currentTime();
        authSessionEntity.setTimestamp(timestamp);
        String tabId2 = Base64Url.encode((byte[])SecretGenerator.getInstance().randomBytes(8));
        authenticationSessions.put(tabId2, authSessionEntity);
        this.updater.getEntity().setTimestamp(timestamp);
        this.update();
        AuthenticationSessionAdapter authSession = new AuthenticationSessionAdapter(this.session, this, tabId2, authSessionEntity);
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)authSession);
        return authSession;
    }

    public void removeAuthenticationSessionByTabId(String tabId) {
        if (this.updater.getEntity().getAuthenticationSessions().remove(tabId) != null) {
            if (this.updater.getEntity().getAuthenticationSessions().isEmpty()) {
                this.updater.onEntityRemoved();
            } else {
                this.updater.getEntity().setTimestamp(Time.currentTime());
                this.update();
            }
        }
    }

    public void restartSession(RealmModel realm) {
        this.updater.getEntity().getAuthenticationSessions().clear();
        this.updater.getEntity().setTimestamp(Time.currentTime());
        this.update();
    }
}

