/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.stream.Stream;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.storage.AbstractStorageManager;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.group.GroupLookupProvider;
import org.keycloak.storage.group.GroupStorageProvider;
import org.keycloak.storage.group.GroupStorageProviderFactory;
import org.keycloak.storage.group.GroupStorageProviderModel;

public class GroupStorageManager
extends AbstractStorageManager<GroupStorageProvider, GroupStorageProviderModel>
implements GroupProvider {
    public GroupStorageManager(KeycloakSession session) {
        super(session, GroupStorageProviderFactory.class, GroupStorageProvider.class, GroupStorageProviderModel::new, "group");
    }

    private GroupProvider localStorage() {
        return (GroupProvider)this.session.getProvider(GroupProvider.class);
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.localStorage().getGroupById(realm, id);
        }
        GroupLookupProvider provider = (GroupLookupProvider)this.getStorageProviderInstance(realm, storageId.getProviderId(), GroupLookupProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getGroupById(realm, id);
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        Stream local = this.localStorage().searchForGroupByNameStream(realm, search, firstResult, maxResults);
        Stream ext = this.flatMapEnabledStorageProvidersWithTimeout(realm, GroupLookupProvider.class, p -> p.searchForGroupByNameStream(realm, search, firstResult, maxResults));
        return Stream.concat(local, ext);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        return this.localStorage().getGroupsStream(realm);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.localStorage().getGroupsStream(realm, ids, search, first, max);
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        return this.localStorage().getGroupsCount(realm, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.localStorage().getGroupsCountByNameContaining(realm, search);
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        return this.localStorage().getGroupsByRoleStream(realm, role, firstResult, maxResults);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        return this.localStorage().getTopLevelGroupsStream(realm);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.localStorage().getTopLevelGroupsStream(realm, firstResult, maxResults);
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        return this.localStorage().createGroup(realm, id, name, toParent);
    }

    public boolean removeGroup(RealmModel realm, GroupModel group) {
        return this.localStorage().removeGroup(realm, group);
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        this.localStorage().moveGroup(realm, group, toParent);
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        this.localStorage().addTopLevelGroup(realm, subGroup);
    }

    public void close() {
    }
}

