/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.util.ObjectMapperResolver;

public class SingleFileExportProvider
implements ExportProvider {
    private static final Logger logger = Logger.getLogger(SingleFileExportProvider.class);
    private File file;

    public SingleFileExportProvider(File file) {
        this.file = file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void exportModel(KeycloakSessionFactory factory) throws IOException {
        logger.infof("Exporting model into file %s", (Object)this.file.getAbsolutePath());
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                Stream<RealmRepresentation> realms = session.realms().getRealmsStream().map(realm -> ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)true, (boolean)true));
                SingleFileExportProvider.this.writeToFile(realms);
            }
        });
    }

    public void exportRealm(KeycloakSessionFactory factory, final String realmName) throws IOException {
        logger.infof("Exporting realm '%s' into file %s", (Object)realmName, (Object)this.file.getAbsolutePath());
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                RealmModel realm = session.realms().getRealmByName(realmName);
                RealmRepresentation realmRep = ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)true, (boolean)true);
                SingleFileExportProvider.this.writeToFile(realmRep);
            }
        });
    }

    public void close() {
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper streamSerializer = ObjectMapperResolver.createStreamSerializer();
        streamSerializer.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        streamSerializer.enable(SerializationFeature.INDENT_OUTPUT);
        return streamSerializer;
    }

    private void writeToFile(Object reps) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.file);
        this.getObjectMapper().writeValue((OutputStream)stream, reps);
    }
}

