/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.client;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoDocs;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntityDelegate;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@ProtoDocs(value={@ProtoDoc(value="@Indexed"), @ProtoDoc(value="schema-version: 1")})
public class HotRodClientEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=2)
    public String id;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=3)
    public String realmId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=4)
    public String clientId;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=5)
    public String clientIdLowercase;
    @ProtoField(number=6)
    public String name;
    @ProtoField(number=7)
    public String description;
    @ProtoField(number=8)
    public Set<String> redirectUris;
    @ProtoField(number=9)
    public Boolean enabled;
    @ProtoField(number=10)
    public Boolean alwaysDisplayInConsole;
    @ProtoField(number=11)
    public String clientAuthenticatorType;
    @ProtoField(number=12)
    public String secret;
    @ProtoField(number=13)
    public String registrationToken;
    @ProtoField(number=14)
    public String protocol;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=15)
    public Set<HotRodAttributeEntity> attributes;
    @ProtoField(number=16)
    public Set<HotRodPair<String, String>> authenticationFlowBindingOverrides;
    @ProtoField(number=17)
    public Boolean publicClient;
    @ProtoField(number=18)
    public Boolean fullScopeAllowed;
    @ProtoField(number=19)
    public Boolean frontchannelLogout;
    @ProtoField(number=20)
    public Long notBefore;
    @ProtoField(number=21)
    public Set<String> scope;
    @ProtoField(number=22)
    public Set<String> webOrigins;
    @ProtoField(number=23)
    public Set<HotRodProtocolMapperEntity> protocolMappers;
    @ProtoField(number=24)
    public Set<HotRodPair<String, Boolean>> clientScopes;
    @ProtoDoc(value="@Field(index = Index.YES, store = Store.YES)")
    @ProtoField(number=25, collectionImplementation=LinkedList.class)
    public Collection<String> scopeMappings;
    @ProtoField(number=26)
    public Boolean surrogateAuthRequired;
    @ProtoField(number=27)
    public String managementUrl;
    @ProtoField(number=28)
    public String baseUrl;
    @ProtoField(number=29)
    public Boolean bearerOnly;
    @ProtoField(number=30)
    public Boolean consentRequired;
    @ProtoField(number=31)
    public String rootUrl;
    @ProtoField(number=32)
    public Boolean standardFlowEnabled;
    @ProtoField(number=33)
    public Boolean implicitFlowEnabled;
    @ProtoField(number=34)
    public Boolean directAccessGrantsEnabled;
    @ProtoField(number=35)
    public Boolean serviceAccountsEnabled;
    @ProtoField(number=36)
    public Integer nodeReRegistrationTimeout;

    public boolean equals(Object o) {
        return HotRodClientEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodClientEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodClientEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodClientEntity>
    implements MapClientEntity {
        public String getId() {
            return ((HotRodClientEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setClientId(String clientId) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.clientId, clientId);
            entity.clientId = clientId;
            entity.clientIdLowercase = clientId == null ? null : clientId.toLowerCase();
        }

        public Stream<String> getClientScopes(boolean defaultScope) {
            Map clientScopes = this.getClientScopes();
            return clientScopes == null ? Stream.empty() : clientScopes.entrySet().stream().filter(me -> Objects.equals(me.getValue(), defaultScope)).map(Map.Entry::getKey);
        }

        public Optional<MapProtocolMapperEntity> getProtocolMapper(String id) {
            Set mappers = this.getProtocolMappers();
            if (mappers == null || mappers.isEmpty()) {
                return Optional.empty();
            }
            return mappers.stream().filter(m -> Objects.equals(m.getId(), id)).findFirst();
        }

        public void removeProtocolMapper(String id) {
            HotRodClientEntity entity = (HotRodClientEntity)this.getHotRodEntity();
            entity.updated = entity.updated | (entity.protocolMappers != null && entity.protocolMappers.removeIf(m -> Objects.equals(m.id, id)));
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodClientEntity.class, HotRodProtocolMapperEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodClientEntitySchema
    extends GeneratedSchema {
        public static final HotRodClientEntitySchema INSTANCE = new HotRodClientEntitySchemaImpl();
    }
}

