/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.Objects;
import java.util.Set;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.api.annotations.indexing.Keyword;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodResourceEntityDelegate;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodResourceEntitySchemaImpl;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntityNonIndexed;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;

@Indexed
@ProtoDoc(value="schema-version: 1")
public class HotRodResourceEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @Basic(projectable=true)
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @Basic(projectable=true, sortable=true)
    @ProtoField(number=2)
    public String id;
    @Basic(sortable=true)
    @ProtoField(number=3)
    public String realmId;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=4)
    public String name;
    @ProtoField(number=5)
    public String displayName;
    @Basic(sortable=true)
    @ProtoField(number=6)
    public Set<String> uris;
    @Keyword(sortable=true, normalizer="lowercase")
    @ProtoField(number=7)
    public String type;
    @ProtoField(number=8)
    public String iconUri;
    @Basic(sortable=true)
    @ProtoField(number=9)
    public String owner;
    @Basic(sortable=true)
    @ProtoField(number=10)
    public Boolean ownerManagedAccess;
    @Basic(sortable=true)
    @ProtoField(number=11)
    public String resourceServerId;
    @Basic(sortable=true)
    @ProtoField(number=12)
    public Set<String> scopeIds;
    @ProtoField(number=13)
    public Set<HotRodAttributeEntityNonIndexed> attributes;

    public boolean equals(Object o) {
        return HotRodResourceEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodResourceEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodResourceEntity
    extends UpdatableHotRodEntityDelegateImpl<HotRodResourceEntity>
    implements MapResourceEntity {
        public String getId() {
            return ((HotRodResourceEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodResourceEntity entity = (HotRodResourceEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public void setName(String name) {
            HotRodResourceEntity entity = (HotRodResourceEntity)this.getHotRodEntity();
            entity.updated = entity.updated | !Objects.equals(entity.name, name);
            entity.name = name;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodResourceEntity.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodResourceEntitySchema
    extends GeneratedSchema {
        public static final HotRodResourceEntitySchema INSTANCE = new HotRodResourceEntitySchemaImpl();
    }
}

