/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.loginFailure;

import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureAdapter;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntityImpl;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;

public class MapUserLoginFailureProvider
implements UserLoginFailureProvider {
    private static final Logger LOG = Logger.getLogger(MapUserLoginFailureProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<MapUserLoginFailureEntity, UserLoginFailureModel> userLoginFailureTx;

    public MapUserLoginFailureProvider(KeycloakSession session, MapStorage<MapUserLoginFailureEntity, UserLoginFailureModel> userLoginFailureStore) {
        this.session = session;
        this.userLoginFailureTx = userLoginFailureStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.userLoginFailureTx);
    }

    private Function<MapUserLoginFailureEntity, UserLoginFailureModel> userLoginFailureEntityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserLoginFailureAdapter(this.session, realm, (MapUserLoginFailureEntity)origEntity);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.userLoginFailureTx.read(QueryParameters.withCriteria(mcb)).findFirst().map(this.userLoginFailureEntityToAdapterFunc(realm)).orElse(null);
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        MapUserLoginFailureEntity userLoginFailureEntity = this.userLoginFailureTx.read(QueryParameters.withCriteria(mcb)).findFirst().orElse(null);
        if (userLoginFailureEntity == null) {
            userLoginFailureEntity = new MapUserLoginFailureEntityImpl();
            userLoginFailureEntity.setRealmId(realm.getId());
            userLoginFailureEntity.setUserId(userId);
            userLoginFailureEntity = this.userLoginFailureTx.create(userLoginFailureEntity);
        }
        return this.userLoginFailureEntityToAdapterFunc(realm).apply(userLoginFailureEntity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = ((DefaultModelCriteria)mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()})).compare(UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{userId});
        LOG.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        this.userLoginFailureTx.delete(QueryParameters.withCriteria(mcb));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        ModelCriteriaBuilder mcb = DefaultModelCriteria.criteria();
        mcb = mcb.compare(UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{realm.getId()});
        LOG.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.userLoginFailureTx.delete(QueryParameters.withCriteria(mcb));
    }

    public void close() {
    }
}

