/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.ExpirableEntity;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapClientInitialAccessEntity
extends UpdatableEntity,
AbstractEntity,
ExpirableEntity {
    public static MapClientInitialAccessEntity createEntity(int expiration, int count) {
        long currentTime = Time.currentTimeMillis();
        MapClientInitialAccessEntityImpl entity = new MapClientInitialAccessEntityImpl();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setTimestamp(currentTime);
        entity.setExpiration(expiration == 0 ? null : Long.valueOf(currentTime + TimeAdapter.fromSecondsToMilliseconds(expiration)));
        entity.setCount(count);
        entity.setRemainingCount(count);
        return entity;
    }

    public static ClientInitialAccessModel toModel(MapClientInitialAccessEntity entity) {
        if (entity == null) {
            return null;
        }
        ClientInitialAccessModel model = new ClientInitialAccessModel();
        model.setId(entity.getId());
        Long timestampSeconds = TimeAdapter.fromMilliSecondsToSeconds(entity.getTimestamp());
        model.setTimestamp(timestampSeconds == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(timestampSeconds));
        Long expirationSeconds = TimeAdapter.fromMilliSecondsToSeconds(entity.getExpiration());
        model.setExpiration(expirationSeconds == null ? 0 : TimeAdapter.fromLongWithTimeInSecondsToIntegerWithTimeInSeconds(expirationSeconds - (long)model.getTimestamp()));
        Integer count = entity.getCount();
        model.setCount(count == null ? 0 : count);
        Integer remainingCount = entity.getRemainingCount();
        model.setRemainingCount(remainingCount == null ? 0 : remainingCount);
        return model;
    }

    public Long getTimestamp();

    public void setTimestamp(Long var1);

    public Integer getCount();

    public void setCount(Integer var1);

    public Integer getRemainingCount();

    public void setRemainingCount(Integer var1);
}

