/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import org.keycloak.credential.CredentialModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapUserCredentialEntity
extends UpdatableEntity {
    public static MapUserCredentialEntity fromModel(CredentialModel model) {
        MapUserCredentialEntityImpl credentialEntity = new MapUserCredentialEntityImpl();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        credentialEntity.setId(id);
        credentialEntity.setCreatedDate(model.getCreatedDate());
        credentialEntity.setUserLabel(model.getUserLabel());
        credentialEntity.setType(model.getType());
        credentialEntity.setSecretData(model.getSecretData());
        credentialEntity.setCredentialData(model.getCredentialData());
        return credentialEntity;
    }

    public static CredentialModel toModel(MapUserCredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setCreatedDate(entity.getCreatedDate());
        model.setUserLabel(entity.getUserLabel());
        model.setSecretData(entity.getSecretData());
        model.setCredentialData(entity.getCredentialData());
        return model;
    }

    public String getId();

    public void setId(String var1);

    public String getType();

    public void setType(String var1);

    public String getUserLabel();

    public void setUserLabel(String var1);

    public Long getCreatedDate();

    public void setCreatedDate(Long var1);

    public String getSecretData();

    public void setSecretData(String var1);

    public String getCredentialData();

    public void setCredentialData(String var1);
}

