/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;

public class ConfigArgsConfigSource
extends PropertiesConfigSource {
    public static final String CLI_ARGS = "kc.config.args";
    public static final String NAME = "CliConfigSource";
    private static final String ARG_SEPARATOR = ";;";
    private static final Pattern ARG_SPLIT = Pattern.compile(";;");
    private static final Pattern ARG_KEY_VALUE_SPLIT = Pattern.compile("=");

    protected ConfigArgsConfigSource() {
        super(ConfigArgsConfigSource.parseArgument(), NAME, 600);
    }

    public static void setCliArgs(String[] args) {
        System.setProperty(CLI_ARGS, String.join((CharSequence)ARG_SEPARATOR, args));
    }

    public static List<String> getAllCliArgs() {
        if (System.getProperty(CLI_ARGS) == null) {
            return Collections.emptyList();
        }
        return List.of(System.getProperty(CLI_ARGS).split(ARG_SEPARATOR));
    }

    private static String getRawConfigArgs() {
        String args = System.getProperty(CLI_ARGS);
        if (args != null) {
            return args;
        }
        return String.join((CharSequence)ARG_SEPARATOR, System.getProperty("quarkus.args", "").split(" "));
    }

    public String getValue(String propertyName) {
        Map properties = this.getProperties();
        String value = (String)properties.get(propertyName);
        if (value != null) {
            return value;
        }
        return (String)properties.get(propertyName.replace('-', '.'));
    }

    private static Map<String, String> parseArgument() {
        String rawArgs = ConfigArgsConfigSource.getRawConfigArgs();
        if (rawArgs == null || "".equals(rawArgs.trim())) {
            return Collections.emptyMap();
        }
        final HashMap<String, String> properties = new HashMap<String, String>();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                key = "kc." + ((String)key).substring(2);
                properties.put(key, value);
                PropertyMapper mapper = PropertyMappers.getMapper((String)key);
                if (mapper != null) {
                    String to = mapper.getTo();
                    if (to != null) {
                        properties.put(mapper.getTo(), value);
                    }
                    properties.put(mapper.getFrom(), value);
                }
            }
        });
        return properties;
    }

    public static void parseConfigArgs(BiConsumer<String, String> cliArgConsumer) {
        List<String> ignoredArgs = Arrays.asList("--verbose", "-v", "--help", "-h");
        String rawArgs = ConfigArgsConfigSource.getRawConfigArgs();
        if (StringUtil.isBlank((String)rawArgs)) {
            return;
        }
        String[] args = ARG_SPLIT.split(rawArgs);
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if (ignoredArgs.contains(arg) || !arg.startsWith("-")) continue;
            String[] keyValue = ARG_KEY_VALUE_SPLIT.split(arg, 2);
            String key = keyValue[0];
            if ("".equals(key.trim())) {
                throw new IllegalArgumentException("Invalid argument key");
            }
            if (keyValue.length == 1) {
                if (args.length <= i + 1) continue;
                value = args[i + 1];
            } else {
                value = keyValue.length == 2 ? keyValue[1] : arg.substring(key.length() + 1);
            }
            cliArgConsumer.accept(key, value);
        }
    }
}

