/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.keycloak.common.Profile;
import org.keycloak.config.Option;
import org.keycloak.config.TracingOptions;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.utils.StringUtil;

public class TracingPropertyMappers {
    private static final String OTEL_FEATURE_ENABLED_MSG = "'opentelemetry' feature is enabled";
    private static final String TRACING_ENABLED_MSG = "'opentelemetry' feature and Tracing is enabled";

    private TracingPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(TracingOptions.TRACING_ENABLED).isEnabled(TracingPropertyMappers::isFeatureEnabled, OTEL_FEATURE_ENABLED_MSG).to("quarkus.otel.enabled").build(), PropertyMapper.fromOption(TracingOptions.TRACING_ENDPOINT).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.exporter.otlp.traces.endpoint").paramLabel("url").validator(TracingPropertyMappers::validateEndpoint).build(), PropertyMapper.fromOption(TracingOptions.TRACING_SERVICE_NAME).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.service.name").paramLabel("name").build(), PropertyMapper.fromOption(TracingOptions.TRACING_RESOURCE_ATTRIBUTES).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.resource.attributes").paramLabel("attributes").build(), PropertyMapper.fromOption(TracingOptions.TRACING_PROTOCOL).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.exporter.otlp.traces.protocol").paramLabel("protocol").build(), PropertyMapper.fromOption(TracingOptions.TRACING_SAMPLER_TYPE).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.traces.sampler").paramLabel("type").build(), PropertyMapper.fromOption(TracingOptions.TRACING_SAMPLER_RATIO).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.traces.sampler.arg").validator(TracingPropertyMappers::validateRatio).paramLabel("ratio").build(), PropertyMapper.fromOption(TracingOptions.TRACING_COMPRESSION).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.otel.exporter.otlp.traces.compression").paramLabel("method").build(), PropertyMapper.fromOption(TracingOptions.TRACING_JDBC_ENABLED).mapFrom(TracingOptions.TRACING_ENABLED).isEnabled(TracingPropertyMappers::isTracingEnabled, TRACING_ENABLED_MSG).to("quarkus.datasource.jdbc.telemetry").build()};
    }

    private static void validateEndpoint(String value) {
        if (StringUtil.isBlank((String)value)) {
            throw new PropertyException("URL specified in 'tracing-endpoint' option must not be empty.");
        }
        if (!TracingPropertyMappers.isValidUrl(value)) {
            throw new PropertyException("URL specified in 'tracing-endpoint' option is invalid.");
        }
    }

    private static void validateRatio(String value) {
        if (StringUtil.isBlank((String)value)) {
            throw new PropertyException("Ratio in 'tracing-sampler-ratio' option must not be empty.");
        }
        try {
            double ratio = Double.parseDouble(value);
            if (ratio <= 0.0 || ratio > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new PropertyException("Ratio in 'tracing-sampler-ratio' option must be a double value in interval <0,1).");
        }
    }

    private static boolean isFeatureEnabled() {
        Environment.getCurrentOrCreateFeatureProfile();
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENTELEMETRY);
    }

    public static boolean isTracingEnabled() {
        return Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_ENABLED);
    }

    public static boolean isTracingJdbcEnabled() {
        return Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_JDBC_ENABLED);
    }

    private static boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

