/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.xmldsig;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509CertificateType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509DataType;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.AbstractStaxXmlDSigParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.XmlDSigQNames;

public class X509DataParser
extends AbstractStaxXmlDSigParser<X509DataType> {
    private static final X509DataParser INSTANCE = new X509DataParser();

    public X509DataParser() {
        super(XmlDSigQNames.X509_DATA);
    }

    public static X509DataParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected X509DataType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new X509DataType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, X509DataType target, XmlDSigQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case X509_CERTIFICATE: {
                StaxParserUtil.advance(xmlEventReader);
                String certValue = StaxParserUtil.getElementText(xmlEventReader);
                X509CertificateType cert = new X509CertificateType();
                cert.setEncodedCertificate(certValue.getBytes(GeneralConstants.SAML_CHARSET));
                target.add((Object)cert);
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

