/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.stream.Collectors;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo3_4_2
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("3.4.2");

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(this::migrateRealm);
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    protected void migrateRealm(RealmModel realm) {
        ClientModel cli = realm.getClientByClientId("admin-cli");
        this.clearScope(cli);
        ClientModel console = realm.getClientByClientId("security-admin-console");
        this.clearScope(console);
    }

    private void clearScope(ClientModel cli) {
        if (cli.isFullScopeAllowed()) {
            cli.setFullScopeAllowed(false);
        }
        cli.getScopeMappingsStream().collect(Collectors.toList()).forEach(arg_0 -> ((ClientModel)cli).deleteScopeMapping(arg_0));
    }

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }
}

