/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.mappersync;

import java.util.function.Consumer;
import org.keycloak.broker.provider.mappersync.AbstractConfigPropertySynchronizer;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class GroupConfigPropertyByPathSynchronizer
extends AbstractConfigPropertySynchronizer<GroupModel.GroupPathChangeEvent> {
    public static final GroupConfigPropertyByPathSynchronizer INSTANCE = new GroupConfigPropertyByPathSynchronizer();

    private GroupConfigPropertyByPathSynchronizer() {
    }

    @Override
    public Class<GroupModel.GroupPathChangeEvent> getEventClass() {
        return GroupModel.GroupPathChangeEvent.class;
    }

    @Override
    public RealmModel extractRealm(GroupModel.GroupPathChangeEvent event) {
        return event.getRealm();
    }

    @Override
    public String getConfigPropertyName() {
        return "group";
    }

    @Override
    protected void updateConfigPropertyIfNecessary(GroupModel.GroupPathChangeEvent event, String currentPropertyValue, Consumer<String> propertyUpdater) {
        String configuredGroupPath = KeycloakModelUtils.normalizeGroupPath(currentPropertyValue);
        String previousGroupPath = event.getPreviousPath();
        if (previousGroupPath.equals(configuredGroupPath)) {
            String newPath = event.getNewPath();
            propertyUpdater.accept(newPath);
        }
    }
}

