/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.component;

import java.util.Set;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;

public class ComponentModelScope
implements Config.Scope {
    private final Config.Scope origScope;
    private final ComponentModel componentConfig;
    private final String prefix;

    public ComponentModelScope(Config.Scope origScope, ComponentModel componentConfig) {
        this(origScope, componentConfig, "");
    }

    public ComponentModelScope(Config.Scope origScope, ComponentModel componentConfig, String prefix) {
        this.origScope = origScope;
        this.componentConfig = componentConfig;
        this.prefix = prefix;
    }

    public String getComponentId() {
        return this.componentConfig.getId();
    }

    public String getComponentName() {
        return this.componentConfig.getName();
    }

    public <T> T getComponentNote(String key) {
        return (T)this.componentConfig.getNote(key);
    }

    public String getComponentParentId() {
        return this.componentConfig.getParentId();
    }

    public String getComponentSubType() {
        return this.componentConfig.getSubType();
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String res = this.componentConfig.get(this.prefix + key, null);
        return res == null ? this.origScope.get(key, defaultValue) : res;
    }

    public String[] getArray(String key) {
        String[] res = this.get(this.prefix + key, "").split("\\s*,\\s*");
        return res == null ? this.origScope.getArray(key) : res;
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String res = this.componentConfig.get(this.prefix + key, null);
        return res == null ? this.origScope.getInt(key, defaultValue) : Integer.valueOf(res);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String res = this.componentConfig.get(this.prefix + key, null);
        return res == null ? this.origScope.getLong(key, defaultValue) : Long.valueOf(res);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String res = this.componentConfig.get(this.prefix + key, null);
        return res == null ? this.origScope.getBoolean(key, defaultValue) : Boolean.valueOf(res);
    }

    public Config.Scope scope(String ... scope) {
        return new ComponentModelScope(this.origScope.scope(scope), this.componentConfig, String.join((CharSequence)".", scope) + ".");
    }

    public Set<String> getPropertyNames() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ComponentModel getComponentModel() {
        return this.componentConfig;
    }
}

