/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.policy.BlacklistPasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;

public class BlacklistPasswordPolicyProviderFactory
implements PasswordPolicyProviderFactory {
    private static final Logger LOG = Logger.getLogger(BlacklistPasswordPolicyProviderFactory.class);
    public static final String ID = "passwordBlacklist";
    public static final String SYSTEM_PROPERTY = "keycloak.password.blacklists.path";
    public static final String BLACKLISTS_PATH_PROPERTY = "blacklistsPath";
    public static final String BLACKLISTS_FALSE_POSITIVE_PROBABILITY_PROPERTY = "falsePositiveProbability";
    public static final double DEFAULT_FALSE_POSITIVE_PROBABILITY = 1.0E-4;
    public static final String JBOSS_SERVER_DATA_DIR = "jboss.server.data.dir";
    public static final String PASSWORD_BLACKLISTS_FOLDER = "password-blacklists" + File.separator;
    private final ConcurrentMap<String, FileBasedPasswordBlacklist> blacklistRegistry = new ConcurrentHashMap<String, FileBasedPasswordBlacklist>();
    private volatile Path blacklistsBasePath;
    private Config.Scope config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordPolicyProvider create(KeycloakSession session) {
        if (this.blacklistsBasePath == null) {
            BlacklistPasswordPolicyProviderFactory blacklistPasswordPolicyProviderFactory = this;
            synchronized (blacklistPasswordPolicyProviderFactory) {
                if (this.blacklistsBasePath == null) {
                    this.blacklistsBasePath = FileBasedPasswordBlacklist.detectBlacklistsBasePath(this.config, this::getDefaultBlacklistsBasePath);
                }
            }
        }
        return new BlacklistPasswordPolicyProvider(session.getContext(), this);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    @Override
    public String getDisplayName() {
        return "Password Blacklist";
    }

    @Override
    public String getConfigType() {
        return "String";
    }

    @Override
    public String getDefaultConfigValue() {
        return "";
    }

    @Override
    public boolean isMultiplSupported() {
        return false;
    }

    public String getId() {
        return ID;
    }

    public String getDefaultBlacklistsBasePath() {
        return System.getProperty(JBOSS_SERVER_DATA_DIR) + File.separator + PASSWORD_BLACKLISTS_FOLDER;
    }

    public PasswordBlacklist resolvePasswordBlacklist(String blacklistName) {
        Objects.requireNonNull(blacklistName, "blacklistName");
        String listName = blacklistName.trim();
        if (listName.isEmpty()) {
            throw new IllegalArgumentException("Password blacklist name must not be empty!");
        }
        return this.blacklistRegistry.computeIfAbsent(listName, name -> {
            double fpp = this.getFalsePositiveProbability();
            FileBasedPasswordBlacklist pbl = new FileBasedPasswordBlacklist(this.blacklistsBasePath, (String)name, fpp);
            pbl.lazyInit();
            return pbl;
        });
    }

    protected double getFalsePositiveProbability() {
        if (this.config == null) {
            return 1.0E-4;
        }
        String falsePositiveProbString = this.config.get(BLACKLISTS_FALSE_POSITIVE_PROBABILITY_PROPERTY);
        if (falsePositiveProbString == null) {
            return 1.0E-4;
        }
        try {
            return Double.parseDouble(falsePositiveProbString);
        }
        catch (NumberFormatException nfe) {
            LOG.warnf("Could not parse false positive probability from string %s", (Object)falsePositiveProbString);
            return 1.0E-4;
        }
    }

    public static class FileBasedPasswordBlacklist
    implements PasswordBlacklist {
        private static final int BUFFER_SIZE_IN_BYTES = 524288;
        private final String name;
        private final Path path;
        private final double falsePositiveProbability;
        private BloomFilter<String> blacklist;

        public FileBasedPasswordBlacklist(Path blacklistBasePath, String name) {
            this(blacklistBasePath, name, 1.0E-4);
        }

        public FileBasedPasswordBlacklist(Path blacklistBasePath, String name, double falsePositiveProbability) {
            if (name.contains("/")) {
                throw new IllegalArgumentException("" + name + " must not contain slashes!");
            }
            this.name = name;
            this.path = blacklistBasePath.resolve(name);
            this.falsePositiveProbability = falsePositiveProbability;
            if (!Files.exists(this.path, new LinkOption[0])) {
                throw new IllegalArgumentException("Password blacklist " + name + " not found!");
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public double getFalsePositiveProbability() {
            return this.falsePositiveProbability;
        }

        @Override
        public boolean contains(String password) {
            return this.blacklist != null && this.blacklist.mightContain((Object)password);
        }

        void lazyInit() {
            if (this.blacklist != null) {
                return;
            }
            this.blacklist = this.load();
        }

        private BloomFilter<String> load() {
            try {
                LOG.infof("Loading blacklist start: name=%s path=%s", (Object)this.name, (Object)this.path);
                long passwordCount = this.countPasswordsInBlacklistFile();
                double fpp = this.getFalsePositiveProbability();
                BloomFilter filter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (long)passwordCount, (double)fpp);
                this.insertPasswordsInto((BloomFilter<String>)filter);
                double expectedFfp = filter.expectedFpp();
                LOG.infof("Loading blacklist finished: name=%s passwords=%s path=%s falsePositiveProbability=%s expectedFalsePositiveProbability=%s", new Object[]{this.name, passwordCount, this.path, fpp, expectedFfp});
                return filter;
            }
            catch (IOException e) {
                throw new RuntimeException("Loading blacklist failed: Could not load password blacklist path=" + this.path, e);
            }
        }

        protected void insertPasswordsInto(BloomFilter<String> filter) throws IOException {
            try (BufferedReader br = FileBasedPasswordBlacklist.newReader(this.path);){
                br.lines().forEach(arg_0 -> filter.put(arg_0));
            }
        }

        private long countPasswordsInBlacklistFile() throws IOException {
            try (BufferedReader br = FileBasedPasswordBlacklist.newReader(this.path);){
                long l = br.lines().count();
                return l;
            }
        }

        private static BufferedReader newReader(Path path) throws IOException {
            return new BufferedReader(Files.newBufferedReader(path), 524288);
        }

        private static Path detectBlacklistsBasePath(Config.Scope config, Supplier<String> defaultPathSupplier) {
            String pathFromSysProperty = System.getProperty(BlacklistPasswordPolicyProviderFactory.SYSTEM_PROPERTY);
            if (pathFromSysProperty != null) {
                return FileBasedPasswordBlacklist.ensureExists(Paths.get(pathFromSysProperty, new String[0]));
            }
            String pathFromSpiConfig = config.get(BlacklistPasswordPolicyProviderFactory.BLACKLISTS_PATH_PROPERTY);
            if (pathFromSpiConfig != null) {
                return FileBasedPasswordBlacklist.ensureExists(Paths.get(pathFromSpiConfig, new String[0]));
            }
            String pathFromJbossDataPath = defaultPathSupplier.get();
            if (pathFromJbossDataPath == null) {
                throw new IllegalStateException("Default path for the blacklist folder was null");
            }
            if (!Files.exists(Paths.get(pathFromJbossDataPath, new String[0]), new LinkOption[0]) && !Paths.get(pathFromJbossDataPath, new String[0]).toFile().mkdirs()) {
                LOG.errorf("Could not create folder for password blacklists: %s", (Object)pathFromJbossDataPath);
            }
            return FileBasedPasswordBlacklist.ensureExists(Paths.get(pathFromJbossDataPath, new String[0]));
        }

        private static Path ensureExists(Path path) {
            Objects.requireNonNull(path, "path");
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
            throw new IllegalStateException("Password blacklists location does not exist: " + path);
        }
    }

    public static interface PasswordBlacklist {
        public String getName();

        public boolean contains(String var1);
    }
}

