/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.validate.ValidationError;

public interface Attributes {
    public static final List<String> EMPTY_VALUE = Collections.emptyList();

    default public String getFirstValue(String name) {
        List<String> values = this.getValues(name);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getValues(String var1);

    public boolean isReadOnly(String var1);

    public boolean validate(String var1, Consumer<ValidationError> ... var2);

    public boolean contains(String var1);

    public Set<String> nameSet();

    public Set<Map.Entry<String, List<String>>> attributeSet();

    public AttributeMetadata getMetadata(String var1);

    public boolean isRequired(String var1);

    default public Map<String, List<String>> getReadable(boolean includeBuiltin) {
        return this.getReadable().entrySet().stream().filter(entry -> {
            if (includeBuiltin) {
                return true;
            }
            if (this.isRootAttribute((String)entry.getKey())) {
                return "locale".equals(entry.getKey()) && !((List)entry.getValue()).isEmpty();
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, List<String>> getReadable();

    default public boolean isRootAttribute(String name) {
        return "username".equals(name) || "email".equals(name) || "firstName".equals(name) || "lastName".equals(name) || "locale".equals(name);
    }

    public Map<String, List<String>> toMap();
}

