/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.evaluator.Evaluators;
import org.keycloak.authorization.policy.evaluation.PolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PermissionTicketStore;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.Provider;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public final class AuthorizationProvider
implements Provider {
    private final PolicyEvaluator policyEvaluator;
    private StoreFactory storeFactory;
    private StoreFactory storeFactoryDelegate;
    private final KeycloakSession keycloakSession;
    private final RealmModel realm;

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, PolicyEvaluator policyEvaluator) {
        this.keycloakSession = session;
        this.realm = realm;
        this.policyEvaluator = policyEvaluator;
    }

    public Evaluators evaluators() {
        return new Evaluators(this);
    }

    public StoreFactory getStoreFactory() {
        if (this.storeFactory != null) {
            return this.storeFactory;
        }
        this.storeFactory = (StoreFactory)this.keycloakSession.getProvider(CachedStoreFactoryProvider.class);
        if (this.storeFactory == null) {
            this.storeFactory = this.getLocalStoreFactory();
        }
        this.storeFactory = this.createStoreFactory(this.storeFactory);
        return this.storeFactory;
    }

    public StoreFactory getLocalStoreFactory() {
        if (this.storeFactoryDelegate != null) {
            return this.storeFactoryDelegate;
        }
        this.storeFactoryDelegate = (StoreFactory)this.keycloakSession.getProvider(StoreFactory.class);
        return this.storeFactoryDelegate;
    }

    public Stream<PolicyProviderFactory> getProviderFactoriesStream() {
        return this.keycloakSession.getKeycloakSessionFactory().getProviderFactoriesStream(PolicyProvider.class).map(PolicyProviderFactory.class::cast);
    }

    public PolicyProviderFactory getProviderFactory(String type) {
        return (PolicyProviderFactory)this.keycloakSession.getKeycloakSessionFactory().getProviderFactory(PolicyProvider.class, type);
    }

    public <P extends PolicyProvider> P getProvider(String type) {
        PolicyProviderFactory policyProviderFactory = this.getProviderFactory(type);
        if (policyProviderFactory == null) {
            return null;
        }
        return (P)policyProviderFactory.create(this);
    }

    public KeycloakSession getKeycloakSession() {
        return this.keycloakSession;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public PolicyEvaluator getPolicyEvaluator(ResourceServer resourceServer) {
        PolicyEvaluator schemaPolicyEvaluator = AdminPermissionsSchema.SCHEMA.getPolicyEvaluator(this.keycloakSession, resourceServer);
        return schemaPolicyEvaluator == null ? this.policyEvaluator : schemaPolicyEvaluator;
    }

    public void close() {
    }

    private StoreFactory createStoreFactory(final StoreFactory storeFactory) {
        return new StoreFactory(){
            ResourceStore resourceStore;
            ScopeStore scopeStore;
            PolicyStore policyStore;

            @Override
            public ResourceStore getResourceStore() {
                if (this.resourceStore == null) {
                    this.resourceStore = AuthorizationProvider.this.createResourceStoreWrapper(storeFactory);
                }
                return this.resourceStore;
            }

            @Override
            public ResourceServerStore getResourceServerStore() {
                return storeFactory.getResourceServerStore();
            }

            @Override
            public ScopeStore getScopeStore() {
                if (this.scopeStore == null) {
                    this.scopeStore = AuthorizationProvider.this.createScopeWrapper(storeFactory);
                }
                return this.scopeStore;
            }

            @Override
            public PolicyStore getPolicyStore() {
                if (this.policyStore == null) {
                    this.policyStore = AuthorizationProvider.this.createPolicyWrapper(storeFactory);
                }
                return this.policyStore;
            }

            @Override
            public PermissionTicketStore getPermissionTicketStore() {
                return storeFactory.getPermissionTicketStore();
            }

            public void close() {
                storeFactory.close();
            }

            @Override
            public void setReadOnly(boolean readOnly) {
                storeFactory.setReadOnly(readOnly);
            }

            @Override
            public boolean isReadOnly() {
                return storeFactory.isReadOnly();
            }
        };
    }

    private ScopeStore createScopeWrapper(final StoreFactory storeFactory) {
        return new ScopeStore(){
            ScopeStore delegate;
            {
                this.delegate = storeFactory.getScopeStore();
            }

            @Override
            public Scope create(ResourceServer resourceServer, String name) {
                return this.delegate.create(resourceServer, name);
            }

            @Override
            public Scope create(ResourceServer resourceServer, String id, String name) {
                return this.delegate.create(resourceServer, id, name);
            }

            @Override
            public void delete(String id) {
                Scope scope = this.findById(null, id);
                PermissionTicketStore ticketStore = AuthorizationProvider.this.getStoreFactory().getPermissionTicketStore();
                List<PermissionTicket> permissions = ticketStore.findByScope(scope.getResourceServer(), scope);
                for (PermissionTicket permission : permissions) {
                    ticketStore.delete(permission.getId());
                }
                this.delegate.delete(id);
            }

            @Override
            public Scope findById(ResourceServer resourceServer, String id) {
                return this.delegate.findById(resourceServer, id);
            }

            @Override
            public Scope findByName(ResourceServer resourceServer, String name) {
                return this.delegate.findByName(resourceServer, name);
            }

            @Override
            public List<Scope> findByResourceServer(ResourceServer resourceServer) {
                return this.delegate.findByResourceServer(resourceServer);
            }

            @Override
            public List<Scope> findByResourceServer(ResourceServer resourceServer, Map<Scope.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
                return this.delegate.findByResourceServer(resourceServer, attributes, firstResult, maxResults);
            }
        };
    }

    private PolicyStore createPolicyWrapper(final StoreFactory storeFactory) {
        return new PolicyStore(){
            PolicyStore policyStore;
            {
                this.policyStore = storeFactory.getPolicyStore();
            }

            @Override
            public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
                Set policies;
                Set scopes;
                AdminPermissionsSchema.SCHEMA.throwExceptionIfResourceTypeOrScopesNotProvided(AuthorizationProvider.this.keycloakSession, resourceServer, representation);
                Set resources = representation.getResources();
                if (resources != null && !resources.isEmpty()) {
                    representation.setResources(resources.stream().map(id -> {
                        Resource resource = AdminPermissionsSchema.SCHEMA.getOrCreateResource(AuthorizationProvider.this.keycloakSession, resourceServer, representation.getType(), representation.getResourceType(), (String)id);
                        if (resource == null) {
                            resource = storeFactory.getResourceStore().findById(resourceServer, (String)id);
                            if (resource == null) {
                                resource = storeFactory.getResourceStore().findByName(resourceServer, (String)id);
                            }
                            if (resource == null) {
                                throw new RuntimeException("Resource [" + id + "] does not exist or is not owned by the resource server.");
                            }
                            return resource.getId();
                        }
                        return Optional.ofNullable(resource).map(Resource::getId).orElse(null);
                    }).filter(Objects::nonNull).collect(Collectors.toSet()));
                }
                if ((scopes = representation.getScopes()) != null) {
                    representation.setScopes(scopes.stream().map(id -> AdminPermissionsSchema.SCHEMA.getScope(AuthorizationProvider.this.keycloakSession, resourceServer, representation.getResourceType(), (String)id).getId()).collect(Collectors.toSet()));
                }
                if ((policies = representation.getPolicies()) != null) {
                    representation.setPolicies(policies.stream().map(id -> {
                        Policy policy = storeFactory.getPolicyStore().findById(resourceServer, (String)id);
                        if (policy == null) {
                            policy = storeFactory.getPolicyStore().findByName(resourceServer, (String)id);
                        }
                        if (policy == null) {
                            throw new RuntimeException("Policy [" + id + "] does not exist");
                        }
                        return policy.getId();
                    }).collect(Collectors.toSet()));
                }
                Policy policy = RepresentationToModel.toModel(representation, AuthorizationProvider.this, this.policyStore.create(resourceServer, representation));
                AdminPermissionsSchema.SCHEMA.addUResourceTypeResource(AuthorizationProvider.this.keycloakSession, resourceServer, policy, representation.getResourceType());
                return policy;
            }

            @Override
            public void delete(String id) {
                Policy policy = this.findById(null, id);
                if (policy != null) {
                    ResourceServer resourceServer = policy.getResourceServer();
                    if (policy.getOwner() != null) {
                        for (Policy associatedPolicy : policy.getAssociatedPolicies()) {
                            if (associatedPolicy.getOwner() == null) continue;
                            policy.removeAssociatedPolicy(associatedPolicy);
                            this.policyStore.delete(associatedPolicy.getId());
                        }
                    }
                    this.findDependentPolicies(resourceServer, policy.getId()).forEach(dependentPolicy -> {
                        dependentPolicy.removeAssociatedPolicy(policy);
                        if (dependentPolicy.getAssociatedPolicies().isEmpty()) {
                            this.delete(dependentPolicy.getId());
                        }
                    });
                    this.policyStore.delete(id);
                }
            }

            @Override
            public Policy findById(ResourceServer resourceServer, String id) {
                return this.policyStore.findById(resourceServer, id);
            }

            @Override
            public Policy findByName(ResourceServer resourceServer, String name) {
                return this.policyStore.findByName(resourceServer, name);
            }

            @Override
            public List<Policy> findByResourceServer(ResourceServer resourceServer) {
                return this.policyStore.findByResourceServer(resourceServer);
            }

            @Override
            public List<Policy> find(ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
                return this.policyStore.find(resourceServer, attributes, firstResult, maxResults);
            }

            @Override
            public List<Policy> findByResource(ResourceServer resourceServer, Resource resource) {
                return this.policyStore.findByResource(resourceServer, resource);
            }

            @Override
            public void findByResource(ResourceServer resourceServer, Resource resource, Consumer<Policy> consumer) {
                this.policyStore.findByResource(resourceServer, resource, consumer);
            }

            @Override
            public List<Policy> findByResourceType(ResourceServer resourceServer, String resourceType) {
                return this.policyStore.findByResourceType(resourceServer, resourceType);
            }

            @Override
            public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
                return this.policyStore.findByScopes(resourceServer, scopes);
            }

            @Override
            public List<Policy> findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes) {
                return this.policyStore.findByScopes(resourceServer, resource, scopes);
            }

            @Override
            public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
                this.policyStore.findByScopes(resourceServer, resource, scopes, consumer);
            }

            @Override
            public List<Policy> findByType(ResourceServer resourceServer, String type) {
                return this.policyStore.findByType(resourceServer, type);
            }

            @Override
            public List<Policy> findDependentPolicies(ResourceServer resourceServer, String id) {
                return this.policyStore.findDependentPolicies(resourceServer, id);
            }

            @Override
            public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String associatedPolicyType, String configKey, String configValue) {
                return this.policyStore.findDependentPolicies(resourceServer, resourceType, associatedPolicyType, configKey, configValue);
            }

            @Override
            public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String associatedPolicyType, String configKey, List<String> configValues) {
                return this.policyStore.findDependentPolicies(resourceServer, resourceType, associatedPolicyType, configKey, configValues);
            }

            @Override
            public void findByResourceType(ResourceServer resourceServer, String type, Consumer<Policy> policyConsumer) {
                this.policyStore.findByResourceType(resourceServer, type, policyConsumer);
            }
        };
    }

    private ResourceStore createResourceStoreWrapper(final StoreFactory storeFactory) {
        return new ResourceStore(){
            ResourceStore delegate;
            {
                this.delegate = storeFactory.getResourceStore();
            }

            @Override
            public Resource create(ResourceServer resourceServer, String name, String owner) {
                return this.delegate.create(resourceServer, name, owner);
            }

            @Override
            public Resource create(ResourceServer resourceServer, String id, String name, String owner) {
                return this.delegate.create(resourceServer, id, name, owner);
            }

            @Override
            public void delete(String id) {
                Resource resource = this.findById(null, id);
                StoreFactory storeFactory2 = AuthorizationProvider.this.getStoreFactory();
                PermissionTicketStore ticketStore = storeFactory2.getPermissionTicketStore();
                ResourceServer resourceServer = resource.getResourceServer();
                List<PermissionTicket> permissions = ticketStore.findByResource(resourceServer, resource);
                for (PermissionTicket permission : permissions) {
                    ticketStore.delete(permission.getId());
                }
                PolicyStore policyStore = storeFactory2.getPolicyStore();
                List<Policy> policies = policyStore.findByResource(resourceServer, resource);
                for (Policy policyModel : policies) {
                    if (policyModel.getResources().size() == 1 && !AdminPermissionsSchema.SCHEMA.isAdminPermissionClient(AuthorizationProvider.this.realm, resourceServer.getId())) {
                        policyStore.delete(policyModel.getId());
                        continue;
                    }
                    policyModel.removeResource(resource);
                }
                this.delegate.delete(id);
            }

            @Override
            public Resource findById(ResourceServer resourceServer, String id) {
                return this.delegate.findById(resourceServer, id);
            }

            @Override
            public List<Resource> findByOwner(ResourceServer resourceServer, String ownerId) {
                return this.delegate.findByOwner(resourceServer, ownerId);
            }

            @Override
            public void findByOwner(ResourceServer resourceServer, String ownerId, Consumer<Resource> consumer) {
                this.delegate.findByOwner(resourceServer, ownerId, consumer);
            }

            @Override
            public List<Resource> findByResourceServer(ResourceServer resourceServer) {
                return this.delegate.findByResourceServer(resourceServer);
            }

            @Override
            public List<Resource> find(ResourceServer resourceServer, Map<Resource.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
                return this.delegate.find(resourceServer, attributes, firstResult, maxResults);
            }

            @Override
            public List<Resource> findByScopes(ResourceServer resourceServer, Set<Scope> scopes) {
                return this.delegate.findByScopes(resourceServer, scopes);
            }

            @Override
            public void findByScopes(ResourceServer resourceServer, Set<Scope> scopes, Consumer<Resource> consumer) {
                this.delegate.findByScopes(resourceServer, scopes, consumer);
            }

            @Override
            public Resource findByName(ResourceServer resourceServer, String name, String ownerId) {
                return this.delegate.findByName(resourceServer, name, ownerId);
            }

            @Override
            public List<Resource> findByType(ResourceServer resourceServer, String type) {
                return this.delegate.findByType(resourceServer, type);
            }

            @Override
            public void findByType(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
                this.delegate.findByType(resourceServer, type, consumer);
            }

            @Override
            public void findByType(ResourceServer resourceServer, String type, String owner, Consumer<Resource> consumer) {
                this.delegate.findByType(resourceServer, type, owner, consumer);
            }

            @Override
            public void findByTypeInstance(ResourceServer resourceServer, String type, Consumer<Resource> consumer) {
                this.delegate.findByTypeInstance(resourceServer, type, consumer);
            }
        };
    }
}

