/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.ResourceTypePolicyEvaluator;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class UserResourceTypePolicyEvaluator
implements ResourceTypePolicyEvaluator {
    @Override
    public void evaluate(ResourcePermission permission, AuthorizationProvider authorization, Consumer<Policy> policyConsumer) {
        UserModel user = this.resolveUser(permission, authorization);
        if (user != null) {
            this.evaluateGroupMembershipPermissions(permission, user, authorization, policyConsumer);
        }
    }

    private UserModel resolveUser(ResourcePermission permission, AuthorizationProvider authorization) {
        RealmModel realm = authorization.getRealm();
        KeycloakSession session = authorization.getKeycloakSession();
        String resourceType = permission.getResourceType();
        if (resourceType == null) {
            return null;
        }
        Resource resource = permission.getResource();
        if (resource == null) {
            return null;
        }
        ResourceServer resourceServer = resource.getResourceServer();
        String userName = AdminPermissionsSchema.SCHEMA.getResourceName(session, resourceServer, resourceType, resource.getName());
        if (userName == null) {
            return null;
        }
        return session.users().getUserByUsername(realm, userName);
    }

    private void evaluateGroupMembershipPermissions(ResourcePermission permission, UserModel user, AuthorizationProvider authorization, Consumer<Policy> policyConsumer) {
        StoreFactory storeFactory = authorization.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        ResourceServer resourceServer = permission.getResourceServer();
        this.evaluateHierarchy(user, group -> {
            Resource groupResource = resourceStore.findByName(resourceServer, group.getId());
            if (groupResource != null) {
                policyStore.findByResource(resourceServer, groupResource, policyConsumer);
            }
        });
        Stream groups = user.getGroupsStream();
        if (groups.findAny().isPresent()) {
            KeycloakSession session = authorization.getKeycloakSession();
            Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(session, resourceServer, "Groups");
            policyStore.findByResource(resourceServer, resourceTypeResource, policyConsumer);
        }
    }

    private void evaluateHierarchy(UserModel user, Consumer<GroupModel> eval) {
        user.getGroupsStream().forEach(group -> this.evaluateHierarchy(eval, (GroupModel)group, (Set<GroupModel>)new HashSet<GroupModel>()));
    }

    private void evaluateHierarchy(Consumer<GroupModel> eval, GroupModel group, Set<GroupModel> visited) {
        if (visited.contains(group)) {
            return;
        }
        eval.accept(group);
        visited.add(group);
        if (group.getParent() == null) {
            return;
        }
        this.evaluateHierarchy(eval, group.getParent(), visited);
    }
}

