/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.common.Profile;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.RealmModel;

public class IdentityProviderModel
implements Serializable {
    public static final String ALIAS = "alias";
    public static final String ALIAS_NOT_IN = "aliasNotIn";
    public static final String ALLOWED_CLOCK_SKEW = "allowedClockSkew";
    public static final String AUTHENTICATE_BY_DEFAULT = "authenticateByDefault";
    public static final String CASE_SENSITIVE_ORIGINAL_USERNAME = "caseSensitiveOriginalUsername";
    public static final String CLAIM_FILTER_NAME = "claimFilterName";
    public static final String CLAIM_FILTER_VALUE = "claimFilterValue";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DO_NOT_STORE_USERS = "doNotStoreUsers";
    public static final String ENABLED = "enabled";
    public static final String FILTERED_BY_CLAIMS = "filteredByClaim";
    public static final String FIRST_BROKER_LOGIN_FLOW_ID = "firstBrokerLoginFlowId";
    public static final String HIDE_ON_LOGIN = "hideOnLogin";
    @Deprecated
    public static final String LEGACY_HIDE_ON_LOGIN_ATTR = "hideOnLoginPage";
    public static final String LINK_ONLY = "linkOnly";
    public static final String LOGIN_HINT = "loginHint";
    public static final String METADATA_DESCRIPTOR_URL = "metadataDescriptorUrl";
    public static final String ORGANIZATION_ID = "organizationId";
    public static final String ORGANIZATION_ID_NOT_NULL = "organizationIdNotNull";
    public static final String PASS_MAX_AGE = "passMaxAge";
    public static final String POST_BROKER_LOGIN_FLOW_ID = "postBrokerLoginFlowId";
    public static final String SEARCH = "search";
    public static final String SYNC_MODE = "syncMode";
    private String internalId;
    private String alias;
    private String providerId;
    private boolean enabled;
    private boolean trustEmail;
    private boolean storeToken;
    protected boolean addReadTokenRoleOnCreate;
    protected boolean linkOnly;
    private boolean authenticateByDefault;
    private String firstBrokerLoginFlowId;
    private String postBrokerLoginFlowId;
    private String organizationId;
    private String displayName;
    private String displayIconClasses;
    private boolean hideOnLogin;
    private Map<String, String> config = new HashMap<String, String>();

    public IdentityProviderModel() {
    }

    public IdentityProviderModel(IdentityProviderModel model) {
        if (model != null) {
            this.internalId = model.getInternalId();
            this.providerId = model.getProviderId();
            this.alias = model.getAlias();
            this.displayName = model.getDisplayName();
            this.config = new HashMap<String, String>(model.getConfig());
            this.enabled = model.isEnabled();
            this.trustEmail = model.isTrustEmail();
            this.storeToken = model.isStoreToken();
            this.linkOnly = model.isLinkOnly();
            this.authenticateByDefault = model.isAuthenticateByDefault();
            this.addReadTokenRoleOnCreate = model.addReadTokenRoleOnCreate;
            this.firstBrokerLoginFlowId = model.getFirstBrokerLoginFlowId();
            this.postBrokerLoginFlowId = model.getPostBrokerLoginFlowId();
            this.organizationId = model.getOrganizationId();
            this.displayIconClasses = model.getDisplayIconClasses();
            this.hideOnLogin = model.isHideOnLogin();
        }
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String id) {
        this.alias = id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isStoreToken() {
        return this.storeToken;
    }

    public void setStoreToken(boolean storeToken) {
        this.storeToken = storeToken;
    }

    public boolean isLinkOnly() {
        return this.linkOnly;
    }

    public void setLinkOnly(boolean linkOnly) {
        this.linkOnly = linkOnly;
    }

    @Deprecated
    public boolean isAuthenticateByDefault() {
        return this.authenticateByDefault;
    }

    @Deprecated
    public void setAuthenticateByDefault(boolean authenticateByDefault) {
        this.authenticateByDefault = authenticateByDefault;
    }

    public String getFirstBrokerLoginFlowId() {
        return this.firstBrokerLoginFlowId;
    }

    public void setFirstBrokerLoginFlowId(String firstBrokerLoginFlowId) {
        this.firstBrokerLoginFlowId = firstBrokerLoginFlowId;
    }

    public String getPostBrokerLoginFlowId() {
        return this.postBrokerLoginFlowId;
    }

    public void setPostBrokerLoginFlowId(String postBrokerLoginFlowId) {
        this.postBrokerLoginFlowId = postBrokerLoginFlowId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public boolean isAddReadTokenRoleOnCreate() {
        return this.addReadTokenRoleOnCreate;
    }

    public void setAddReadTokenRoleOnCreate(boolean addReadTokenRoleOnCreate) {
        this.addReadTokenRoleOnCreate = addReadTokenRoleOnCreate;
    }

    public boolean isTrustEmail() {
        return this.trustEmail;
    }

    public void setTrustEmail(boolean trustEmail) {
        this.trustEmail = trustEmail;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayIconClasses() {
        return this.displayIconClasses;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void validate(RealmModel realm) {
    }

    public IdentityProviderSyncMode getSyncMode() {
        return IdentityProviderSyncMode.valueOf(this.getConfig().getOrDefault(SYNC_MODE, "LEGACY"));
    }

    public void setSyncMode(IdentityProviderSyncMode syncMode) {
        this.getConfig().put(SYNC_MODE, syncMode.toString());
    }

    public boolean isLoginHint() {
        return Boolean.valueOf(this.getConfig().get(LOGIN_HINT));
    }

    public void setLoginHint(boolean loginHint) {
        this.getConfig().put(LOGIN_HINT, String.valueOf(loginHint));
    }

    public boolean isPassMaxAge() {
        return Boolean.valueOf(this.getConfig().get(PASS_MAX_AGE));
    }

    public void setPassMaxAge(boolean passMaxAge) {
        this.getConfig().put(PASS_MAX_AGE, String.valueOf(passMaxAge));
    }

    public boolean isHideOnLogin() {
        return this.hideOnLogin;
    }

    public void setHideOnLogin(boolean hideOnLogin) {
        this.hideOnLogin = hideOnLogin;
    }

    public boolean isTransientUsers() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && Boolean.valueOf(this.getConfig().get(DO_NOT_STORE_USERS)) != false;
    }

    public void setTransientUsers(boolean transientUsers) {
        this.getConfig().put(DO_NOT_STORE_USERS, String.valueOf(transientUsers));
    }

    public boolean isFilteredByClaims() {
        return Boolean.valueOf(this.getConfig().getOrDefault(FILTERED_BY_CLAIMS, Boolean.toString(false)));
    }

    public void setFilteredByClaims(boolean filteredByClaims) {
        this.getConfig().put(FILTERED_BY_CLAIMS, String.valueOf(filteredByClaims));
    }

    public String getClaimFilterName() {
        return String.valueOf(this.getConfig().getOrDefault(CLAIM_FILTER_NAME, ""));
    }

    public void setClaimFilterName(String claimFilterName) {
        this.getConfig().put(CLAIM_FILTER_NAME, claimFilterName);
    }

    public String getClaimFilterValue() {
        return String.valueOf(this.getConfig().getOrDefault(CLAIM_FILTER_VALUE, ""));
    }

    public void setClaimFilterValue(String claimFilterValue) {
        this.getConfig().put(CLAIM_FILTER_VALUE, claimFilterValue);
    }

    public String getMetadataDescriptorUrl() {
        return this.getConfig().get(METADATA_DESCRIPTOR_URL);
    }

    public void setMetadataDescriptorUrl(String metadataDescriptorUrl) {
        this.getConfig().put(METADATA_DESCRIPTOR_URL, metadataDescriptorUrl);
    }

    public boolean isCaseSensitiveOriginalUsername() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault(CASE_SENSITIVE_ORIGINAL_USERNAME, Boolean.FALSE.toString()));
    }

    public void setCaseSensitiveOriginalUsername(boolean caseSensitive) {
        this.getConfig().put(CASE_SENSITIVE_ORIGINAL_USERNAME, Boolean.valueOf(caseSensitive).toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.internalId);
        hash = 61 * hash + Objects.hashCode(this.alias);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdentityProviderModel)) {
            return false;
        }
        return Objects.equals(this.getInternalId(), ((IdentityProviderModel)obj).getInternalId()) && Objects.equals(this.getAlias(), ((IdentityProviderModel)obj).getAlias());
    }
}

