/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Set;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.ThemeManager;
import org.keycloak.models.TokenManager;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.cache.UserCache;
import org.keycloak.provider.Provider;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.vault.VaultTranscriber;

public interface KeycloakSession {
    public KeycloakContext getContext();

    public KeycloakTransactionManager getTransactionManager();

    public <T extends Provider> T getProvider(Class<T> var1);

    public <T extends Provider> T getProvider(Class<T> var1, String var2);

    public <T extends Provider> T getProvider(Class<T> var1, ComponentModel var2);

    public <T extends Provider> Set<String> listProviderIds(Class<T> var1);

    public <T extends Provider> Set<T> getAllProviders(Class<T> var1);

    public Class<? extends Provider> getProviderClass(String var1);

    public Object getAttribute(String var1);

    public <T> T getAttribute(String var1, Class<T> var2);

    default public <T> T getAttributeOrDefault(String attribute, T defaultValue) {
        Object value = this.getAttribute(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Object removeAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public void enlistForClose(Provider var1);

    public KeycloakSessionFactory getKeycloakSessionFactory();

    public RealmProvider realms();

    public UserSessionProvider sessions();

    public AuthenticationSessionProvider authenticationSessions();

    public void close();

    public UserCache userCache();

    public UserProvider users();

    public ClientProvider clientStorageManager();

    public UserProvider userStorageManager();

    public UserCredentialManager userCredentialManager();

    public UserProvider userLocalStorage();

    public RealmProvider realmLocalStorage();

    public ClientProvider clientLocalStorage();

    public UserFederatedStorageProvider userFederatedStorage();

    public KeyManager keys();

    public ThemeManager theme();

    public TokenManager tokens();

    public VaultTranscriber vault();
}

