/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.TokenIdGenerator;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.admin.LogoutAction;
import org.keycloak.services.managers.TokenManager;

public class ResourceAdminManager {
    protected Logger logger = Logger.getLogger(ResourceAdminManager.class);

    public void logoutAll(RealmModel realm) {
        this.singleLogOut(realm, null);
    }

    public void singleLogOut(RealmModel realm, String user) {
        ResteasyClient client = new ResteasyClientBuilder().disableTrustManager().build();
        List resources = realm.getApplications();
        this.logger.debug("logging out {0} resources ", new Object[]{resources.size()});
        for (ApplicationModel resource : resources) {
            this.logoutResource(realm, resource, user, client);
        }
    }

    protected boolean logoutResource(RealmModel realm, ApplicationModel resource, String user, ResteasyClient client) {
        String managementUrl = resource.getManagementUrl();
        if (managementUrl != null) {
            LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), System.currentTimeMillis() / 1000L + 30L, resource.getName(), user);
            String token = new TokenManager().encodeToken(realm, adminAction);
            Form form = new Form();
            form.param("token", token);
            this.logger.debug("logout user: {0} resource: {1} url: {2}", new Object[]{user, resource.getName(), managementUrl});
            Response response = client.target(managementUrl).queryParam("action", new Object[]{"logout"}).request().post(Entity.form((Form)form));
            boolean success = response.getStatus() == 204;
            response.close();
            return success;
        }
        return false;
    }
}

