/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;

public class OAuthClientResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected OAuthClientModel oauthClient;
    protected KeycloakSession session;

    public OAuthClientResource(RealmModel realm, OAuthClientModel oauthClient, KeycloakSession session) {
        this.realm = realm;
        this.oauthClient = oauthClient;
        this.session = session;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(OAuthClientRepresentation rep) {
        OAuthClientManager manager = new OAuthClientManager(this.realm);
        manager.update(rep, this.oauthClient);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public OAuthClientRepresentation getOAuthClient() {
        return OAuthClientManager.toRepresentation(this.oauthClient);
    }

    @DELETE
    @NoCache
    public void deleteOAuthClient() {
        this.realm.removeOAuthClient(this.oauthClient.getId());
    }

    @Path(value="credentials")
    @PUT
    @Consumes(value={"application/json"})
    public void updateCredentials(List<CredentialRepresentation> credentials) {
        logger.debug("updateCredentials");
        if (credentials == null) {
            return;
        }
        for (CredentialRepresentation rep : credentials) {
            UserCredentialModel cred = RealmManager.fromRepresentation(rep);
            this.realm.updateCredential(this.oauthClient.getOAuthAgent(), cred);
        }
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.oauthClient.getOAuthAgent(), this.session);
    }
}

