/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.ApplicationsResource;
import org.keycloak.services.resources.admin.OAuthClientsResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UsersResource;

public class RealmAdminResource
extends RoleContainerResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected UserModel admin;
    protected RealmModel realm;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public RealmAdminResource(UserModel admin, RealmModel realm) {
        super((RoleContainerModel)realm);
        this.admin = admin;
        this.realm = realm;
    }

    @Path(value="applications")
    public ApplicationsResource getApplications() {
        ApplicationsResource applicationsResource = new ApplicationsResource(this.realm);
        this.resourceContext.initResource((Object)applicationsResource);
        return applicationsResource;
    }

    @Path(value="oauth-clients")
    public OAuthClientsResource getOAuthClients() {
        OAuthClientsResource oauth = new OAuthClientsResource(this.realm, this.session);
        return oauth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        return RealmManager.toRepresentation(this.realm);
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateRealm(RealmRepresentation rep) {
        logger.debug("updating realm: " + this.realm.getName());
        new RealmManager(this.session).updateRealm(rep, this.realm);
    }

    @DELETE
    public void deleteRealms() {
        if (!this.session.removeRealm(this.realm.getId())) {
            throw new NotFoundException();
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.realm);
        this.resourceContext.initResource((Object)users);
        return users;
    }
}

