/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RequiredActionsService;
import org.keycloak.services.resources.SaasService;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.TokenService;

public class Urls {
    public static URI accountAccessPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "accessPage").build(new Object[]{realmId});
    }

    public static UriBuilder accountBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getAccountService");
    }

    public static URI accountPage(URI baseUri, String realmId) {
        return Urls.accountPageBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder accountPageBuilder(URI baseUri) {
        return Urls.accountBase(baseUri).path(AccountService.class, "accountPage");
    }

    public static URI accountPasswordPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "passwordPage").build(new Object[]{realmId});
    }

    public static URI accountSocialPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "socialPage").build(new Object[]{realmId});
    }

    public static URI accountTotpPage(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "totpPage").build(new Object[]{realmId});
    }

    public static URI accountTotpRemove(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "processTotpRemove").build(new Object[]{realmId});
    }

    public static URI accountLogout(URI baseUri, String realmId) {
        return Urls.accountBase(baseUri).path(AccountService.class, "logout").build(new Object[]{realmId});
    }

    public static URI loginActionUpdatePassword(URI baseUri, String realmId) {
        return Urls.requiredActionsBase(baseUri).path(RequiredActionsService.class, "updatePassword").build(new Object[]{realmId});
    }

    public static URI loginActionUpdateTotp(URI baseUri, String realmId) {
        return Urls.requiredActionsBase(baseUri).path(RequiredActionsService.class, "updateTotp").build(new Object[]{realmId});
    }

    public static URI loginActionUpdateProfile(URI baseUri, String realmId) {
        return Urls.requiredActionsBase(baseUri).path(RequiredActionsService.class, "updateProfile").build(new Object[]{realmId});
    }

    public static URI loginActionEmailVerification(URI baseUri, String realmId) {
        return Urls.loginActionEmailVerificationBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder loginActionEmailVerificationBuilder(URI baseUri) {
        return Urls.requiredActionsBase(baseUri).path(RequiredActionsService.class, "emailVerification");
    }

    public static URI loginPasswordReset(URI baseUri, String realmId) {
        return Urls.loginPasswordResetBuilder(baseUri).build(new Object[]{realmId});
    }

    public static UriBuilder loginPasswordResetBuilder(URI baseUri) {
        return Urls.requiredActionsBase(baseUri).path(RequiredActionsService.class, "passwordReset");
    }

    private static UriBuilder realmBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(RealmsResource.class);
    }

    public static URI realmLoginAction(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "processLogin").build(new Object[]{realmId});
    }

    public static URI realmLoginPage(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "loginPage").build(new Object[]{realmId});
    }

    public static URI realmRegisterAction(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "processRegister").build(new Object[]{realmId});
    }

    public static URI realmRegisterPage(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "registerPage").build(new Object[]{realmId});
    }

    public static URI realmCode(URI baseUri, String realmId) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "accessCodeToToken").build(new Object[]{realmId});
    }

    private static UriBuilder saasBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(SaasService.class);
    }

    public static URI saasLoginAction(URI baseUri) {
        return Urls.saasBase(baseUri).path(SaasService.class, "processLogin").build(new Object[0]);
    }

    public static URI saasLoginPage(URI baseUri) {
        return Urls.saasBase(baseUri).path(SaasService.class, "loginPage").build(new Object[0]);
    }

    public static URI saasRegisterAction(URI baseUri) {
        return Urls.saasBase(baseUri).path(SaasService.class, "processRegister").build(new Object[0]);
    }

    public static URI saasRegisterPage(URI baseUri) {
        return Urls.saasBase(baseUri).path(SaasService.class, "registerPage").build(new Object[0]);
    }

    public static UriBuilder socialBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(SocialResource.class);
    }

    public static URI socialCallback(URI baseUri) {
        return Urls.socialBase(baseUri).path(SocialResource.class, "callback").build(new Object[0]);
    }

    public static URI socialRedirectToProviderAuth(URI baseUri, String realmId) {
        return Urls.socialBase(baseUri).path(SocialResource.class, "redirectToProviderAuth").build(new Object[]{realmId});
    }

    public static URI socialRegisterAction(URI baseUri, String realmId) {
        return Urls.socialBase(baseUri).path(SocialResource.class, "socialRegistration").build(new Object[]{realmId});
    }

    private static UriBuilder requiredActionsBase(URI baseUri) {
        return Urls.tokenBase(baseUri).path(TokenService.class, "getRequiredActionsService");
    }

    private static UriBuilder tokenBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getTokenService");
    }
}

