/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.HashMap;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientRepresentation;

public class OIDCAdvancedConfigWrapper {
    private final ClientModel clientModel;
    private final ClientRepresentation clientRep;

    private OIDCAdvancedConfigWrapper(ClientModel client, ClientRepresentation clientRep) {
        this.clientModel = client;
        this.clientRep = clientRep;
    }

    public static OIDCAdvancedConfigWrapper fromClientModel(ClientModel client) {
        return new OIDCAdvancedConfigWrapper(client, null);
    }

    public static OIDCAdvancedConfigWrapper fromClientRepresentation(ClientRepresentation clientRep) {
        return new OIDCAdvancedConfigWrapper(null, clientRep);
    }

    public Algorithm getUserInfoSignedResponseAlg() {
        String alg = this.getAttribute("user.info.response.signature.alg");
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setUserInfoSignedResponseAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute("user.info.response.signature.alg", algStr);
    }

    public boolean isUserInfoSignatureRequired() {
        return this.getUserInfoSignedResponseAlg() != null;
    }

    public Algorithm getRequestObjectSignatureAlg() {
        String alg = this.getAttribute("request.object.signature.alg");
        return alg == null ? null : Enum.valueOf(Algorithm.class, alg);
    }

    public void setRequestObjectSignatureAlg(Algorithm alg) {
        String algStr = alg == null ? null : alg.toString();
        this.setAttribute("request.object.signature.alg", algStr);
    }

    public String getRequestObjectRequired() {
        return this.getAttribute("request.object.required");
    }

    public void setRequestObjectRequired(String requestObjectRequired) {
        this.setAttribute("request.object.required", requestObjectRequired);
    }

    public boolean isUseJwksUrl() {
        String useJwksUrl = this.getAttribute("use.jwks.url");
        return Boolean.parseBoolean(useJwksUrl);
    }

    public void setUseJwksUrl(boolean useJwksUrl) {
        String val = String.valueOf(useJwksUrl);
        this.setAttribute("use.jwks.url", val);
    }

    public String getJwksUrl() {
        return this.getAttribute("jwks.url");
    }

    public void setJwksUrl(String jwksUrl) {
        this.setAttribute("jwks.url", jwksUrl);
    }

    public boolean isExcludeSessionStateFromAuthResponse() {
        String excludeSessionStateFromAuthResponse = this.getAttribute("exclude.session.state.from.auth.response");
        return Boolean.parseBoolean(excludeSessionStateFromAuthResponse);
    }

    public void setExcludeSessionStateFromAuthResponse(boolean excludeSessionStateFromAuthResponse) {
        String val = String.valueOf(excludeSessionStateFromAuthResponse);
        this.setAttribute("exclude.session.state.from.auth.response", val);
    }

    public boolean isUseMtlsHokToken() {
        String useUtlsHokToken = this.getAttribute("tls.client.certificate.bound.access.tokens");
        return Boolean.parseBoolean(useUtlsHokToken);
    }

    public void setUseMtlsHoKToken(boolean useUtlsHokToken) {
        String val = String.valueOf(useUtlsHokToken);
        this.setAttribute("tls.client.certificate.bound.access.tokens", val);
    }

    public String getTlsClientAuthSubjectDn() {
        return this.getAttribute("x509.subjectdn");
    }

    public void setTlsClientAuthSubjectDn(String tls_client_auth_subject_dn) {
        this.setAttribute("x509.subjectdn", tls_client_auth_subject_dn);
    }

    public String getPkceCodeChallengeMethod() {
        return this.getAttribute("pkce.code.challenge.method");
    }

    public void setPkceCodeChallengeMethod(String codeChallengeMethodName) {
        this.setAttribute("pkce.code.challenge.method", codeChallengeMethodName);
    }

    public String getIdTokenSignedResponseAlg() {
        return this.getAttribute("id.token.signed.response.alg");
    }

    public void setIdTokenSignedResponseAlg(String algName) {
        this.setAttribute("id.token.signed.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.getAttribute("id.token.encrypted.response.alg");
    }

    public void setIdTokenEncryptedResponseAlg(String algName) {
        this.setAttribute("id.token.encrypted.response.alg", algName);
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.getAttribute("id.token.encrypted.response.enc");
    }

    public void setIdTokenEncryptedResponseEnc(String encName) {
        this.setAttribute("id.token.encrypted.response.enc", encName);
    }

    public String getTokenEndpointAuthSigningAlg() {
        return this.getAttribute("token.endpoint.auth.signing.alg");
    }

    public void setTokenEndpointAuthSigningAlg(String algName) {
        this.setAttribute("token.endpoint.auth.signing.alg", algName);
    }

    private String getAttribute(String attrKey) {
        if (this.clientModel != null) {
            return this.clientModel.getAttribute(attrKey);
        }
        return this.clientRep.getAttributes() == null ? null : (String)this.clientRep.getAttributes().get(attrKey);
    }

    private void setAttribute(String attrKey, String attrValue) {
        if (this.clientModel != null) {
            if (attrValue != null) {
                this.clientModel.setAttribute(attrKey, attrValue);
            } else {
                this.clientModel.removeAttribute(attrKey);
            }
        } else if (attrValue != null) {
            if (this.clientRep.getAttributes() == null) {
                this.clientRep.setAttributes(new HashMap());
            }
            this.clientRep.getAttributes().put(attrKey, attrValue);
        } else if (this.clientRep.getAttributes() != null) {
            this.clientRep.getAttributes().put(attrKey, null);
        }
    }
}

