/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.Map;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.AccessToken;

public class RoleResolveUtil {
    private static final String RESOLVED_ROLES_ATTR = "RESOLVED_ROLES";

    public static AccessToken.Access getResolvedRealmRoles(KeycloakSession session, ClientSessionContext clientSessionCtx, boolean createIfMissing) {
        AccessToken rolesToken = RoleResolveUtil.getAndCacheResolvedRoles(session, clientSessionCtx);
        AccessToken.Access access = rolesToken.getRealmAccess();
        if (access == null && createIfMissing) {
            access = new AccessToken.Access();
            rolesToken.setRealmAccess(access);
        }
        return access;
    }

    public static AccessToken.Access getResolvedClientRoles(KeycloakSession session, ClientSessionContext clientSessionCtx, String clientId, boolean createIfMissing) {
        AccessToken rolesToken = RoleResolveUtil.getAndCacheResolvedRoles(session, clientSessionCtx);
        AccessToken.Access access = rolesToken.getResourceAccess(clientId);
        if (access == null && createIfMissing) {
            access = rolesToken.addAccess(clientId);
        }
        return access;
    }

    public static Map<String, AccessToken.Access> getAllResolvedClientRoles(KeycloakSession session, ClientSessionContext clientSessionCtx) {
        return RoleResolveUtil.getAndCacheResolvedRoles(session, clientSessionCtx).getResourceAccess();
    }

    private static AccessToken getAndCacheResolvedRoles(KeycloakSession session, ClientSessionContext clientSessionCtx) {
        ClientModel client = clientSessionCtx.getClientSession().getClient();
        String resolvedRolesAttrName = "RESOLVED_ROLES:" + clientSessionCtx.getClientSession().getUserSession().getId() + ":" + client.getId();
        AccessToken token = (AccessToken)session.getAttribute(resolvedRolesAttrName, AccessToken.class);
        if (token == null) {
            AccessToken finalToken = new AccessToken();
            clientSessionCtx.getRolesStream().forEach(role -> RoleResolveUtil.addToToken(finalToken, role));
            token = finalToken;
            session.setAttribute(resolvedRolesAttrName, (Object)token);
        }
        return token;
    }

    private static void addToToken(AccessToken token, RoleModel role) {
        AccessToken.Access access = null;
        if (role.getContainer() instanceof RealmModel) {
            access = token.getRealmAccess();
            if (token.getRealmAccess() == null) {
                access = new AccessToken.Access();
                token.setRealmAccess(access);
            } else if (token.getRealmAccess().getRoles() != null && token.getRealmAccess().isUserInRole(role.getName())) {
                return;
            }
        } else {
            ClientModel app = (ClientModel)role.getContainer();
            access = token.getResourceAccess(app.getClientId());
            if (access == null) {
                access = token.addAccess(app.getClientId());
                if (app.isSurrogateAuthRequired()) {
                    access.verifyCaller(Boolean.valueOf(true));
                }
            } else if (access.isUserInRole(role.getName())) {
                return;
            }
        }
        access.addRole(role.getName());
    }
}

