/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.grants.ciba.channel.CIBAAuthenticationRequest;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelAuthenticationRequestContext;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.context.BackchannelTokenRequestContext;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenRequestContext;
import org.keycloak.services.clientpolicy.context.TokenRequestContext;

public class ClientScopesCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientScopesCondition.class);

    public ClientScopesCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-scopes";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case AUTHORIZATION_REQUEST: {
                if (this.isScopeMatched(((AuthorizationRequestContext)context).getAuthorizationEndpointRequest())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case TOKEN_REQUEST: {
                if (this.isScopeMatched(((TokenRequestContext)context).getParseResult().getClientSession())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case SERVICE_ACCOUNT_TOKEN_REQUEST: {
                if (this.isScopeMatched(((ServiceAccountTokenRequestContext)context).getClientSession())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case BACKCHANNEL_AUTHENTICATION_REQUEST: {
                if (this.isScopeMatched(((BackchannelAuthenticationRequestContext)context).getParsedRequest())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
            case BACKCHANNEL_TOKEN_REQUEST: {
                if (this.isScopeMatched(((BackchannelTokenRequestContext)context).getParsedRequest())) {
                    return ClientPolicyVote.YES;
                }
                return ClientPolicyVote.NO;
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean isScopeMatched(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            return false;
        }
        return this.isScopeMatched(clientSession.getNote("scope"), clientSession.getClient());
    }

    private boolean isScopeMatched(AuthorizationEndpointRequest request) {
        if (request == null) {
            return false;
        }
        return this.isScopeMatched(request.getScope(), this.session.getContext().getRealm().getClientByClientId(request.getClientId()));
    }

    private boolean isScopeMatched(CIBAAuthenticationRequest request) {
        if (request == null || request.getClient() == null) {
            return false;
        }
        return this.isScopeMatched(request.getScope(), this.session.getContext().getRealm().getClientByClientId(request.getClient().getClientId()));
    }

    private boolean isScopeMatched(String explicitScopes, ClientModel client) {
        boolean isDefaultScope;
        if (explicitScopes == null) {
            explicitScopes = "";
        }
        HashSet<String> explicitSpecifiedScopes = new HashSet<String>(Arrays.asList(explicitScopes.split(" ")));
        Set defaultScopes = client.getClientScopes(true).keySet();
        Set optionalScopes = client.getClientScopes(false).keySet();
        Set<String> expectedScopes = this.getScopesForMatching();
        if (expectedScopes == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            explicitSpecifiedScopes.forEach(i -> logger.tracev("explicit specified client scope = {0}", i));
            defaultScopes.forEach(i -> logger.tracev("default client scope = {0}", i));
            optionalScopes.forEach(i -> logger.tracev("optional client scope = {0}", i));
            expectedScopes.forEach(i -> logger.tracev("expected scope = {0}", i));
        }
        if (isDefaultScope = "Default".equals(((Configuration)this.configuration).getType())) {
            expectedScopes.retainAll(defaultScopes);
            return !expectedScopes.isEmpty();
        }
        explicitSpecifiedScopes.retainAll(expectedScopes);
        explicitSpecifiedScopes.retainAll(optionalScopes);
        if (!explicitSpecifiedScopes.isEmpty()) {
            if (logger.isTraceEnabled()) {
                explicitSpecifiedScopes.forEach(i -> logger.tracev("matched scope = {0}", i));
            }
            return true;
        }
        return false;
    }

    private Set<String> getScopesForMatching() {
        List<String> scopes = ((Configuration)this.configuration).getScopes();
        if (scopes == null) {
            return null;
        }
        return new HashSet<String>(scopes);
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected String type;
        protected List<String> scopes;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(List<String> scope) {
            this.scopes = scope;
        }
    }
}

