/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyEvaluationService;
import org.keycloak.authorization.admin.PolicyResourceService;
import org.keycloak.authorization.admin.PolicyTypeService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyProviderRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.util.JsonSerialization;

public class PolicyService {
    protected final ResourceServer resourceServer;
    protected final AuthorizationProvider authorization;
    protected final AdminPermissionEvaluator auth;
    protected final AdminEventBuilder adminEvent;

    public PolicyService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTHORIZATION_POLICY);
    }

    @Path(value="{type}")
    public Object getResource(@PathParam(value="type") String type) {
        PolicyProviderFactory providerFactory = this.getPolicyProviderFactory(type);
        if (providerFactory != null) {
            return this.doCreatePolicyTypeResource(type);
        }
        Policy policy = this.authorization.getStoreFactory().getPolicyStore().findById(this.resourceServer, type);
        return this.doCreatePolicyResource(policy);
    }

    protected PolicyTypeService doCreatePolicyTypeResource(String type) {
        return new PolicyTypeService(type, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    protected Object doCreatePolicyResource(Policy policy) {
        return new PolicyResourceService(policy, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response create(String payload, @Context KeycloakSession session) {
        if (this.auth != null) {
            this.auth.realm().requireManageAuthorization();
        }
        AbstractPolicyRepresentation representation = this.doCreateRepresentation(payload);
        Policy policy = this.create(representation);
        representation.setId(policy.getId());
        this.audit(representation, representation.getId(), OperationType.CREATE, session);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    protected AbstractPolicyRepresentation doCreateRepresentation(String payload) {
        PolicyRepresentation representation;
        try {
            representation = (PolicyRepresentation)JsonSerialization.readValue((String)payload, PolicyRepresentation.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize representation", cause);
        }
        return representation;
    }

    public Policy create(AbstractPolicyRepresentation representation) {
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        Policy existing = policyStore.findByName(this.resourceServer, representation.getName());
        if (existing != null) {
            throw new ErrorResponseException("Policy with name [" + representation.getName() + "] already exists", "Conflicting policy", Response.Status.CONFLICT);
        }
        return policyStore.create(this.resourceServer, representation);
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findByName(@QueryParam(value="name") String name, @QueryParam(value="fields") String fields) {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Policy model = storeFactory.getPolicyStore().findByName(this.resourceServer, name);
        if (model == null) {
            return Response.noContent().build();
        }
        return Response.ok((Object)this.toRepresentation(model, fields, this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findAll(@QueryParam(value="policyId") String id, @QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="resource") String resource, @QueryParam(value="scope") String scope, @QueryParam(value="permission") Boolean permission, @QueryParam(value="owner") String owner, @QueryParam(value="fields") String fields, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        EnumMap<Policy.FilterOption, String[]> search = new EnumMap<Policy.FilterOption, String[]>(Policy.FilterOption.class);
        if (id != null && !"".equals(id.trim())) {
            search.put(Policy.FilterOption.ID, new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put(Policy.FilterOption.NAME, new String[]{name});
        }
        if (type != null && !"".equals(type.trim())) {
            search.put(Policy.FilterOption.TYPE, new String[]{type});
        }
        if (owner != null && !"".equals(owner.trim())) {
            search.put(Policy.FilterOption.OWNER, new String[]{owner});
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (resource != null && !"".equals(resource.trim())) {
            ResourceStore resourceStore = storeFactory.getResourceStore();
            Resource resourceModel = resourceStore.findById(this.resourceServer, resource);
            if (resourceModel == null) {
                Set<String> resources;
                EnumMap<Resource.FilterOption, String[]> resourceFilters = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
                resourceFilters.put(Resource.FilterOption.NAME, new String[]{resource});
                if (owner != null) {
                    resourceFilters.put(Resource.FilterOption.OWNER, new String[]{owner});
                }
                if ((resources = resourceStore.findByResourceServer(this.resourceServer, resourceFilters, Integer.valueOf(-1), Integer.valueOf(1)).stream().map(Resource::getId).collect(Collectors.toSet())).isEmpty()) {
                    return Response.noContent().build();
                }
                search.put(Policy.FilterOption.RESOURCE_ID, resources.toArray(new String[resources.size()]));
            } else {
                search.put(Policy.FilterOption.RESOURCE_ID, new String[]{resourceModel.getId()});
            }
        }
        if (scope != null && !"".equals(scope.trim())) {
            ScopeStore scopeStore = storeFactory.getScopeStore();
            Scope scopeModel = scopeStore.findById(this.resourceServer, scope);
            if (scopeModel == null) {
                EnumMap<Scope.FilterOption, String[]> scopeFilters = new EnumMap<Scope.FilterOption, String[]>(Scope.FilterOption.class);
                scopeFilters.put(Scope.FilterOption.NAME, new String[]{scope});
                Set<String> scopes = scopeStore.findByResourceServer(this.resourceServer, scopeFilters, Integer.valueOf(-1), Integer.valueOf(1)).stream().map(Scope::getId).collect(Collectors.toSet());
                if (scopes.isEmpty()) {
                    return Response.noContent().build();
                }
                search.put(Policy.FilterOption.SCOPE_ID, scopes.toArray(new String[scopes.size()]));
            } else {
                search.put(Policy.FilterOption.SCOPE_ID, new String[]{scopeModel.getId()});
            }
        }
        if (permission != null) {
            search.put(Policy.FilterOption.PERMISSION, new String[]{permission.toString()});
        }
        return Response.ok(this.doSearch(firstResult, maxResult, fields, search)).build();
    }

    protected AbstractPolicyRepresentation toRepresentation(Policy model, String fields, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation((Policy)model, (AuthorizationProvider)authorization, (boolean)true, (boolean)false, (fields != null && fields.equals("*") ? 1 : 0) != 0);
    }

    protected List<Object> doSearch(Integer firstResult, Integer maxResult, String fields, Map<Policy.FilterOption, String[]> filters) {
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        return policyStore.findByResourceServer(this.resourceServer, filters, Integer.valueOf(firstResult != null ? firstResult : -1), Integer.valueOf(maxResult != null ? maxResult : 100)).stream().map(policy -> this.toRepresentation((Policy)policy, fields, this.authorization)).collect(Collectors.toList());
    }

    @Path(value="providers")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findPolicyProviders() {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        return Response.ok(this.authorization.getProviderFactoriesStream().filter(((Predicate<PolicyProviderFactory>)PolicyProviderFactory::isInternal).negate()).map(factory -> {
            PolicyProviderRepresentation representation = new PolicyProviderRepresentation();
            representation.setName(factory.getName());
            representation.setGroup(factory.getGroup());
            representation.setType(factory.getId());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="evaluate")
    public PolicyEvaluationService getPolicyEvaluateResource() {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        PolicyEvaluationService resource = new PolicyEvaluationService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    protected PolicyProviderAdminService getPolicyProviderAdminResource(String policyType) {
        return this.getPolicyProviderFactory(policyType).getAdminResource(this.resourceServer, this.authorization);
    }

    protected PolicyProviderFactory getPolicyProviderFactory(String policyType) {
        return this.authorization.getProviderFactory(policyType);
    }

    private void audit(AbstractPolicyRepresentation resource, String id, OperationType operation, KeycloakSession session) {
        if (id != null) {
            this.adminEvent.operation(operation).resourcePath((UriInfo)session.getContext().getUri(), id).representation(resource).success();
        } else {
            this.adminEvent.operation(operation).resourcePath((UriInfo)session.getContext().getUri()).representation(resource).success();
        }
    }
}

