/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.net.URI;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCClientSecretConfigWrapper;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperUtils;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.ClientRegistrationException;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class DescriptionConverter {
    public static ClientRepresentation toInternal(KeycloakSession session, OIDCClientRepresentation clientOIDC) throws ClientRegistrationException {
        Boolean requirePushedAuthorizationRequests;
        String backchannelAuthenticationRequestSigningAlg;
        String backchannelClientNotificationEndpoint;
        String backchannelTokenDeliveryMode;
        Boolean tlsClientCertificateBoundAccessTokens;
        Algorithm algorithm;
        List<String> oidcResponseTypes;
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientOIDC.getClientId());
        client.setName(clientOIDC.getClientName());
        client.setRedirectUris(clientOIDC.getRedirectUris());
        client.setBaseUrl(clientOIDC.getClientUri());
        client.setProtocol("openid-connect");
        String scopeParam = clientOIDC.getScope();
        if (scopeParam != null) {
            client.setOptionalClientScopes(new ArrayList<String>(Arrays.asList(scopeParam.split(" "))));
        }
        if ((oidcResponseTypes = clientOIDC.getResponseTypes()) == null || oidcResponseTypes.isEmpty()) {
            oidcResponseTypes = Collections.singletonList("code");
        }
        List oidcGrantTypes = clientOIDC.getGrantTypes();
        try {
            OIDCResponseType responseType = OIDCResponseType.parse(oidcResponseTypes);
            client.setStandardFlowEnabled(Boolean.valueOf(responseType.hasResponseType("code")));
            client.setImplicitFlowEnabled(Boolean.valueOf(responseType.isImplicitOrHybridFlow()));
            if (oidcGrantTypes != null) {
                client.setDirectAccessGrantsEnabled(Boolean.valueOf(oidcGrantTypes.contains("password")));
                client.setServiceAccountsEnabled(Boolean.valueOf(oidcGrantTypes.contains("client_credentials")));
                DescriptionConverter.setOidcCibaGrantEnabled(client, oidcGrantTypes.contains("urn:openid:params:grant-type:ciba"));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ClientRegistrationException(iae.getMessage(), iae);
        }
        String authMethod = clientOIDC.getTokenEndpointAuthMethod();
        client.setPublicClient(Boolean.FALSE);
        if ("none".equals(authMethod)) {
            client.setClientAuthenticatorType("none");
            client.setPublicClient(Boolean.TRUE);
        } else {
            ClientAuthenticatorFactory clientAuthFactory = authMethod == null ? (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, KeycloakModelUtils.getDefaultClientAuthenticatorType()) : AuthorizeClientUtil.findClientAuthenticatorForOIDCAuthMethod(session, authMethod);
            if (clientAuthFactory == null) {
                throw new ClientRegistrationException("Not found clientAuthenticator for requested token_endpoint_auth_method");
            }
            client.setClientAuthenticatorType(clientAuthFactory.getId());
        }
        boolean publicKeySet = DescriptionConverter.setPublicKey(clientOIDC, client);
        if (authMethod != null && authMethod.equals("private_key_jwt") && !publicKeySet) {
            throw new ClientRegistrationException("Didn't find key of supported keyType for use " + JWK.Use.SIG.asString());
        }
        OIDCAdvancedConfigWrapper configWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
        if (clientOIDC.getUserinfoSignedResponseAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getUserinfoSignedResponseAlg());
            configWrapper.setUserInfoSignedResponseAlg(algorithm);
        }
        if (clientOIDC.getRequestObjectSigningAlg() != null) {
            algorithm = Enum.valueOf(Algorithm.class, clientOIDC.getRequestObjectSigningAlg());
            configWrapper.setRequestObjectSignatureAlg(algorithm);
        }
        if (clientOIDC.getUserinfoEncryptedResponseAlg() != null) {
            configWrapper.setUserInfoEncryptedResponseAlg(clientOIDC.getUserinfoEncryptedResponseAlg());
        }
        if (clientOIDC.getUserinfoEncryptedResponseEnc() != null) {
            configWrapper.setUserInfoEncryptedResponseEnc(clientOIDC.getUserinfoEncryptedResponseEnc());
        }
        if ((tlsClientCertificateBoundAccessTokens = clientOIDC.getTlsClientCertificateBoundAccessTokens()) != null) {
            if (tlsClientCertificateBoundAccessTokens.booleanValue()) {
                configWrapper.setUseMtlsHoKToken(true);
            } else {
                configWrapper.setUseMtlsHoKToken(false);
            }
        }
        if (clientOIDC.getTlsClientAuthSubjectDn() != null) {
            configWrapper.setTlsClientAuthSubjectDn(clientOIDC.getTlsClientAuthSubjectDn());
            configWrapper.setAllowRegexPatternComparison(false);
        }
        if (clientOIDC.getIdTokenSignedResponseAlg() != null) {
            configWrapper.setIdTokenSignedResponseAlg(clientOIDC.getIdTokenSignedResponseAlg());
        }
        if (clientOIDC.getIdTokenEncryptedResponseAlg() != null) {
            configWrapper.setIdTokenEncryptedResponseAlg(clientOIDC.getIdTokenEncryptedResponseAlg());
        }
        if (clientOIDC.getIdTokenEncryptedResponseEnc() != null) {
            configWrapper.setIdTokenEncryptedResponseEnc(clientOIDC.getIdTokenEncryptedResponseEnc());
        }
        configWrapper.setAuthorizationSignedResponseAlg(clientOIDC.getAuthorizationSignedResponseAlg());
        configWrapper.setAuthorizationEncryptedResponseAlg(clientOIDC.getAuthorizationEncryptedResponseAlg());
        configWrapper.setAuthorizationEncryptedResponseEnc(clientOIDC.getAuthorizationEncryptedResponseEnc());
        if (clientOIDC.getRequestUris() != null) {
            configWrapper.setRequestUris(clientOIDC.getRequestUris());
        }
        configWrapper.setTokenEndpointAuthSigningAlg(clientOIDC.getTokenEndpointAuthSigningAlg());
        configWrapper.setBackchannelLogoutUrl(clientOIDC.getBackchannelLogoutUri());
        if (clientOIDC.getBackchannelLogoutSessionRequired() == null) {
            configWrapper.setBackchannelLogoutSessionRequired(true);
        } else {
            configWrapper.setBackchannelLogoutSessionRequired(clientOIDC.getBackchannelLogoutSessionRequired());
        }
        if (clientOIDC.getBackchannelLogoutRevokeOfflineTokens() == null) {
            configWrapper.setBackchannelLogoutRevokeOfflineTokens(false);
        } else {
            configWrapper.setBackchannelLogoutRevokeOfflineTokens(clientOIDC.getBackchannelLogoutRevokeOfflineTokens());
        }
        if (clientOIDC.getLogoUri() != null) {
            configWrapper.setLogoUri(clientOIDC.getLogoUri());
        }
        if (clientOIDC.getPolicyUri() != null) {
            configWrapper.setPolicyUri(clientOIDC.getPolicyUri());
        }
        if (clientOIDC.getTosUri() != null) {
            configWrapper.setTosUri(clientOIDC.getTosUri());
        }
        if ((backchannelTokenDeliveryMode = clientOIDC.getBackchannelTokenDeliveryMode()) != null) {
            Map attr = Optional.ofNullable(client.getAttributes()).orElse(new HashMap());
            attr.put("ciba.backchannel.token.delivery.mode", backchannelTokenDeliveryMode);
            client.setAttributes(attr);
        }
        if ((backchannelClientNotificationEndpoint = clientOIDC.getBackchannelClientNotificationEndpoint()) != null) {
            Map attr = Optional.ofNullable(client.getAttributes()).orElse(new HashMap());
            attr.put("ciba.backchannel.client.notification.endpoint", backchannelClientNotificationEndpoint);
            client.setAttributes(attr);
        }
        if ((backchannelAuthenticationRequestSigningAlg = clientOIDC.getBackchannelAuthenticationRequestSigningAlg()) != null) {
            Map attr = Optional.ofNullable(client.getAttributes()).orElse(new HashMap());
            attr.put("ciba.backchannel.auth.request.signing.alg", backchannelAuthenticationRequestSigningAlg);
            client.setAttributes(attr);
        }
        if ((requirePushedAuthorizationRequests = clientOIDC.getRequirePushedAuthorizationRequests()) != null) {
            Map attr = Optional.ofNullable(client.getAttributes()).orElse(new HashMap());
            attr.put("require.pushed.authorization.requests", requirePushedAuthorizationRequests.toString());
            client.setAttributes(attr);
        }
        configWrapper.setFrontChannelLogoutUrl(Optional.ofNullable(clientOIDC.getFrontChannelLogoutUri()).orElse(null));
        if (clientOIDC.getFrontchannelLogoutSessionRequired() == null) {
            configWrapper.setFrontChannelLogoutSessionRequired(false);
        } else {
            configWrapper.setFrontChannelLogoutSessionRequired(clientOIDC.getFrontchannelLogoutSessionRequired());
        }
        if (clientOIDC.getDefaultAcrValues() != null) {
            configWrapper.setAttributeMultivalued("default.acr.values", clientOIDC.getDefaultAcrValues());
        }
        return client;
    }

    private static void setOidcCibaGrantEnabled(ClientRepresentation client, Boolean isEnabled) {
        if (isEnabled == null) {
            return;
        }
        Map attributes = Optional.ofNullable(client.getAttributes()).orElse(new HashMap());
        attributes.put("oidc.ciba.grant.enabled", isEnabled.toString());
        client.setAttributes(attributes);
    }

    private static List<String> getSupportedAlgorithms(KeycloakSession session, Class<? extends Provider> clazz, boolean includeNone) {
        Stream supportedAlgorithms = session.getKeycloakSessionFactory().getProviderFactoriesStream(clazz).map(ProviderFactory::getId);
        if (includeNone) {
            supportedAlgorithms = Streams.concat((Stream[])new Stream[]{supportedAlgorithms, Stream.of("none")});
        }
        return supportedAlgorithms.collect(Collectors.toList());
    }

    private static boolean setPublicKey(OIDCClientRepresentation clientOIDC, ClientRepresentation clientRep) {
        OIDCAdvancedConfigWrapper configWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(clientRep);
        if (clientOIDC.getJwks() != null) {
            if (clientOIDC.getJwksUri() != null) {
                throw new ClientRegistrationException("Illegal to use both jwks_uri and jwks");
            }
            JSONWebKeySet keySet = clientOIDC.getJwks();
            JWK publicKeyJWk = JWKSUtils.getKeyForUse((JSONWebKeySet)keySet, (JWK.Use)JWK.Use.SIG);
            try {
                configWrapper.setJwksString(JsonSerialization.writeValueAsPrettyString((Object)clientOIDC.getJwks()));
            }
            catch (IOException e) {
                throw new ClientRegistrationException("Illegal jwks format");
            }
            configWrapper.setUseJwksString(true);
            configWrapper.setUseJwksUrl(false);
            if (publicKeyJWk == null) {
                return false;
            }
            PublicKey publicKey = JWKParser.create((JWK)publicKeyJWk).toPublicKey();
            String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
            CertificateRepresentation rep = new CertificateRepresentation();
            rep.setPublicKey(publicKeyPem);
            rep.setKid(publicKeyJWk.getKeyId());
            CertificateInfoHelper.updateClientRepresentationCertificateInfo(clientRep, rep, "jwt.credential");
            return true;
        }
        if (clientOIDC.getJwksUri() != null) {
            configWrapper.setUseJwksUrl(true);
            configWrapper.setJwksUrl(clientOIDC.getJwksUri());
            configWrapper.setUseJwksString(false);
            return true;
        }
        return false;
    }

    public static OIDCClientRepresentation toExternalResponse(KeycloakSession session, ClientRepresentation client, URI uri) {
        List<ProtocolMapperRepresentation> foundPairwiseMappers;
        OIDCAdvancedConfigWrapper config;
        OIDCClientRepresentation response = new OIDCClientRepresentation();
        response.setClientId(client.getClientId());
        if ("none".equals(client.getClientAuthenticatorType())) {
            response.setTokenEndpointAuthMethod("none");
        } else {
            ClientAuthenticatorFactory clientAuth = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, client.getClientAuthenticatorType());
            Set oidcClientAuthMethods = clientAuth.getProtocolAuthenticatorMethods("openid-connect");
            if (oidcClientAuthMethods != null && !oidcClientAuthMethods.isEmpty()) {
                response.setTokenEndpointAuthMethod((String)oidcClientAuthMethods.iterator().next());
            }
        }
        if (client.getClientAuthenticatorType().equals("client-secret")) {
            response.setClientSecret(client.getSecret());
            response.setClientSecretExpiresAt(Integer.valueOf(OIDCClientSecretConfigWrapper.fromClientRepresentation(client).getClientSecretExpirationTime()));
        }
        response.setClientName(client.getName());
        response.setClientUri(client.getBaseUrl());
        response.setRedirectUris(client.getRedirectUris());
        response.setRegistrationAccessToken(client.getRegistrationAccessToken());
        response.setRegistrationClientUri(uri.toString());
        response.setResponseTypes(DescriptionConverter.getOIDCResponseTypes(client));
        response.setGrantTypes(DescriptionConverter.getOIDCGrantTypes(client));
        List scopes = client.getOptionalClientScopes();
        if (scopes != null) {
            response.setScope(scopes.stream().collect(Collectors.joining(" ")));
        }
        if ((config = OIDCAdvancedConfigWrapper.fromClientRepresentation(client)).isUserInfoSignatureRequired()) {
            response.setUserinfoSignedResponseAlg(config.getUserInfoSignedResponseAlg().toString());
        }
        if (config.getUserInfoEncryptedResponseAlg() != null) {
            response.setUserinfoEncryptedResponseAlg(config.getUserInfoEncryptedResponseAlg());
        }
        if (config.getUserInfoEncryptedResponseEnc() != null) {
            response.setUserinfoEncryptedResponseEnc(config.getUserInfoEncryptedResponseEnc());
        }
        if (config.getRequestObjectSignatureAlg() != null) {
            response.setRequestObjectSigningAlg(config.getRequestObjectSignatureAlg().toString());
        }
        if (config.getRequestObjectEncryptionAlg() != null) {
            response.setRequestObjectEncryptionAlg(config.getRequestObjectEncryptionAlg());
        }
        if (config.getRequestObjectEncryptionEnc() != null) {
            response.setRequestObjectEncryptionEnc(config.getRequestObjectEncryptionEnc());
        }
        if (config.isUseJwksUrl()) {
            response.setJwksUri(config.getJwksUrl());
        }
        if (config.isUseJwksString()) {
            try {
                response.setJwks((JSONWebKeySet)JsonSerialization.readValue((String)config.getJwksString(), JSONWebKeySet.class));
            }
            catch (IOException e) {
                throw new ClientRegistrationException("Illegal jwks format");
            }
        }
        if (config.isUseMtlsHokToken()) {
            response.setTlsClientCertificateBoundAccessTokens(Boolean.TRUE);
        } else {
            response.setTlsClientCertificateBoundAccessTokens(Boolean.FALSE);
        }
        if (config.getTlsClientAuthSubjectDn() != null) {
            response.setTlsClientAuthSubjectDn(config.getTlsClientAuthSubjectDn());
        }
        if (config.getIdTokenSignedResponseAlg() != null) {
            response.setIdTokenSignedResponseAlg(config.getIdTokenSignedResponseAlg());
        }
        if (config.getIdTokenEncryptedResponseAlg() != null) {
            response.setIdTokenEncryptedResponseAlg(config.getIdTokenEncryptedResponseAlg());
        }
        if (config.getIdTokenEncryptedResponseEnc() != null) {
            response.setIdTokenEncryptedResponseEnc(config.getIdTokenEncryptedResponseEnc());
        }
        if (config.getAuthorizationSignedResponseAlg() != null) {
            response.setAuthorizationSignedResponseAlg(config.getAuthorizationSignedResponseAlg());
        }
        if (config.getAuthorizationEncryptedResponseAlg() != null) {
            response.setAuthorizationEncryptedResponseAlg(config.getAuthorizationEncryptedResponseAlg());
        }
        if (config.getAuthorizationEncryptedResponseEnc() != null) {
            response.setAuthorizationEncryptedResponseEnc(config.getAuthorizationEncryptedResponseEnc());
        }
        if (config.getRequestUris() != null) {
            response.setRequestUris(config.getRequestUris());
        }
        if (config.getTokenEndpointAuthSigningAlg() != null) {
            response.setTokenEndpointAuthSigningAlg(config.getTokenEndpointAuthSigningAlg());
        }
        response.setBackchannelLogoutUri(config.getBackchannelLogoutUrl());
        response.setBackchannelLogoutSessionRequired(Boolean.valueOf(config.isBackchannelLogoutSessionRequired()));
        response.setBackchannelLogoutSessionRequired(Boolean.valueOf(config.getBackchannelLogoutRevokeOfflineTokens()));
        if (client.getAttributes() != null) {
            String alg;
            String clientNotificationEndpoint;
            String mode = (String)client.getAttributes().get("ciba.backchannel.token.delivery.mode");
            if (StringUtil.isNotBlank((String)mode)) {
                response.setBackchannelTokenDeliveryMode(mode);
            }
            if (StringUtil.isNotBlank((String)(clientNotificationEndpoint = (String)client.getAttributes().get("ciba.backchannel.client.notification.endpoint")))) {
                response.setBackchannelClientNotificationEndpoint(clientNotificationEndpoint);
            }
            if (StringUtil.isNotBlank((String)(alg = (String)client.getAttributes().get("ciba.backchannel.auth.request.signing.alg")))) {
                response.setBackchannelAuthenticationRequestSigningAlg(alg);
            }
            Boolean requirePushedAuthorizationRequests = Boolean.valueOf((String)client.getAttributes().get("require.pushed.authorization.requests"));
            response.setRequirePushedAuthorizationRequests(Boolean.valueOf(requirePushedAuthorizationRequests));
        }
        SubjectType subjectType = (foundPairwiseMappers = PairwiseSubMapperUtils.getPairwiseSubMappers(client)).isEmpty() ? SubjectType.PUBLIC : SubjectType.PAIRWISE;
        response.setSubjectType(subjectType.toString().toLowerCase());
        if (subjectType.equals((Object)SubjectType.PAIRWISE)) {
            String sectorIdentifierUri = PairwiseSubMapperHelper.getSectorIdentifierUri(foundPairwiseMappers.get(0));
            response.setSectorIdentifierUri(sectorIdentifierUri);
        }
        response.setFrontChannelLogoutUri(config.getFrontChannelLogoutUrl());
        response.setFrontchannelLogoutSessionRequired(Boolean.valueOf(config.isFrontChannelLogoutSessionRequired()));
        List<String> defaultAcrValues = config.getAttributeMultivalued("default.acr.values");
        if (!defaultAcrValues.isEmpty()) {
            response.setDefaultAcrValues(defaultAcrValues);
        }
        return response;
    }

    private static List<String> getOIDCResponseTypes(ClientRepresentation client) {
        ArrayList<String> responseTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            responseTypes.add("code");
            responseTypes.add("none");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("id_token");
            responseTypes.add("id_token token");
        }
        if (client.isStandardFlowEnabled().booleanValue() && client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("code id_token");
            responseTypes.add("code token");
            responseTypes.add("code id_token token");
        }
        return responseTypes;
    }

    private static List<String> getOIDCGrantTypes(ClientRepresentation client) {
        boolean oidcCibaEnabled;
        boolean oauth2DeviceEnabled;
        ArrayList<String> grantTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            grantTypes.add("authorization_code");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            grantTypes.add("implicit");
        }
        if (client.isDirectAccessGrantsEnabled().booleanValue()) {
            grantTypes.add("password");
        }
        if (client.isServiceAccountsEnabled().booleanValue()) {
            grantTypes.add("client_credentials");
        }
        boolean bl = oauth2DeviceEnabled = client.getAttributes() != null && Boolean.parseBoolean((String)client.getAttributes().get("oauth2.device.authorization.grant.enabled"));
        if (oauth2DeviceEnabled) {
            grantTypes.add("urn:ietf:params:oauth:grant-type:device_code");
        }
        boolean bl2 = oidcCibaEnabled = client.getAttributes() != null && Boolean.parseBoolean((String)client.getAttributes().get("oidc.ciba.grant.enabled"));
        if (oidcCibaEnabled) {
            grantTypes.add("urn:openid:params:grant-type:ciba");
        }
        if (client.getAuthorizationServicesEnabled() != null && client.getAuthorizationServicesEnabled().booleanValue()) {
            grantTypes.add("urn:ietf:params:oauth:grant-type:uma-ticket");
        }
        if (OIDCAdvancedConfigWrapper.fromClientRepresentation(client).isUseRefreshToken()) {
            grantTypes.add("refresh_token");
        }
        return grantTypes;
    }
}

