/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.LinkedList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.services.ServicesLogger;
import org.keycloak.transaction.JtaTransactionManagerLookup;
import org.keycloak.transaction.JtaTransactionWrapper;

public class DefaultKeycloakTransactionManager
implements KeycloakTransactionManager {
    private static final Logger logger = Logger.getLogger(DefaultKeycloakTransactionManager.class);
    private List<KeycloakTransaction> prepare = new LinkedList<KeycloakTransaction>();
    private List<KeycloakTransaction> transactions = new LinkedList<KeycloakTransaction>();
    private List<KeycloakTransaction> afterCompletion = new LinkedList<KeycloakTransaction>();
    private boolean active;
    private boolean rollback;
    private KeycloakSession session;
    private KeycloakTransactionManager.JTAPolicy jtaPolicy = KeycloakTransactionManager.JTAPolicy.REQUIRES_NEW;
    protected boolean completed;

    public DefaultKeycloakTransactionManager(KeycloakSession session) {
        this.session = session;
    }

    public void enlist(KeycloakTransaction transaction) {
        if (this.active && !transaction.isActive()) {
            transaction.begin();
        }
        this.transactions.add(transaction);
    }

    public void enlistAfterCompletion(KeycloakTransaction transaction) {
        if (this.active && !transaction.isActive()) {
            transaction.begin();
        }
        this.afterCompletion.add(transaction);
    }

    public void enlistPrepare(KeycloakTransaction transaction) {
        if (this.active && !transaction.isActive()) {
            transaction.begin();
        }
        this.prepare.add(transaction);
    }

    public KeycloakTransactionManager.JTAPolicy getJTAPolicy() {
        return this.jtaPolicy;
    }

    public void setJTAPolicy(KeycloakTransactionManager.JTAPolicy policy) {
        this.jtaPolicy = policy;
    }

    public void begin() {
        TransactionManager tm;
        JtaTransactionManagerLookup jtaLookup;
        if (this.active) {
            throw new IllegalStateException("Transaction already active");
        }
        this.completed = false;
        if (this.jtaPolicy == KeycloakTransactionManager.JTAPolicy.REQUIRES_NEW && (jtaLookup = (JtaTransactionManagerLookup)this.session.getProvider(JtaTransactionManagerLookup.class)) != null && (tm = jtaLookup.getTransactionManager()) != null) {
            this.enlist(new JtaTransactionWrapper(this.session.getKeycloakSessionFactory(), tm));
        }
        for (KeycloakTransaction tx : this.transactions) {
            tx.begin();
        }
        this.active = true;
    }

    public void commit() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        RuntimeException exception = null;
        for (KeycloakTransaction tx : this.prepare) {
            try {
                tx.commit();
            }
            catch (RuntimeException e) {
                exception = exception == null ? e : exception;
            }
        }
        if (exception != null) {
            this.rollback(exception);
            return;
        }
        for (KeycloakTransaction tx : this.transactions) {
            try {
                tx.commit();
            }
            catch (RuntimeException e) {
                exception = exception == null ? e : exception;
            }
        }
        if (exception == null) {
            for (KeycloakTransaction tx : this.afterCompletion) {
                try {
                    tx.commit();
                }
                catch (RuntimeException e) {
                    exception = exception == null ? e : exception;
                }
            }
        } else {
            for (KeycloakTransaction tx : this.afterCompletion) {
                try {
                    tx.rollback();
                }
                catch (RuntimeException e) {
                    ServicesLogger.LOGGER.exceptionDuringRollback(e);
                }
            }
        }
        this.active = false;
        if (exception != null) {
            throw exception;
        }
    }

    public void rollback() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        RuntimeException exception = null;
        this.rollback(exception);
    }

    protected void rollback(RuntimeException exception) {
        for (KeycloakTransaction tx : this.transactions) {
            try {
                tx.rollback();
            }
            catch (RuntimeException e) {
                exception = exception != null ? e : exception;
            }
        }
        for (KeycloakTransaction tx : this.afterCompletion) {
            try {
                tx.rollback();
            }
            catch (RuntimeException e) {
                exception = exception != null ? e : exception;
            }
        }
        this.active = false;
        if (exception != null) {
            throw exception;
        }
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        if (this.rollback) {
            return true;
        }
        for (KeycloakTransaction tx : this.transactions) {
            if (!tx.getRollbackOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }
}

