/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.core.Response;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.util.Tokens;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.util.JsonSerialization;

public class KeycloakIdentity
implements Identity {
    private final AccessToken accessToken;
    private final RealmModel realm;
    private final KeycloakSession keycloakSession;
    private final Attributes attributes;

    public KeycloakIdentity(KeycloakSession keycloakSession) {
        this(Tokens.getAccessToken(keycloakSession), keycloakSession);
    }

    public KeycloakIdentity(AccessToken accessToken, KeycloakSession keycloakSession) {
        this.accessToken = accessToken;
        if (this.accessToken == null) {
            throw new ErrorResponseException("invalid_bearer_token", "Could not obtain bearer access_token from request.", Response.Status.FORBIDDEN);
        }
        this.keycloakSession = keycloakSession;
        this.realm = keycloakSession.getContext().getRealm();
        HashMap attributes = new HashMap();
        try {
            ObjectNode objectNode = JsonSerialization.createObjectNode((Object)this.accessToken);
            Iterator iterator = objectNode.fieldNames();
            ArrayList<String> roleNames = new ArrayList<String>();
            while (iterator.hasNext()) {
                JsonNode grantedRoles;
                String fieldName = (String)iterator.next();
                JsonNode fieldValue = objectNode.get(fieldName);
                ArrayList<String> values = new ArrayList<String>();
                values.add(fieldValue.asText());
                if (fieldName.equals("realm_access") && (grantedRoles = fieldValue.get("roles")) != null) {
                    Iterator rolesIt = grantedRoles.iterator();
                    while (rolesIt.hasNext()) {
                        roleNames.add(((JsonNode)rolesIt.next()).asText());
                    }
                }
                if (fieldName.equals("resource_access")) {
                    Iterator resourceAccessIt = fieldValue.iterator();
                    while (resourceAccessIt.hasNext()) {
                        JsonNode grantedRoles2 = ((JsonNode)resourceAccessIt.next()).get("roles");
                        if (grantedRoles2 == null) continue;
                        Iterator rolesIt = grantedRoles2.iterator();
                        while (rolesIt.hasNext()) {
                            roleNames.add(((JsonNode)rolesIt.next()).asText());
                        }
                    }
                }
                attributes.put(fieldName, values);
            }
            attributes.put("roles", roleNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading attributes from security token.", e);
        }
        this.attributes = Attributes.from(attributes);
    }

    public String getId() {
        if (this.isResourceServer()) {
            ClientSessionModel clientSession = this.keycloakSession.sessions().getClientSession(this.accessToken.getClientSession());
            return clientSession.getClient().getId();
        }
        return this.accessToken.getSubject();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    private boolean isResourceServer() {
        UserModel clientUser = null;
        if (this.accessToken.getClientSession() != null) {
            ClientSessionModel clientSession = this.keycloakSession.sessions().getClientSession(this.accessToken.getClientSession());
            clientUser = this.keycloakSession.users().getUserByServiceAccountClient(clientSession.getClient());
        } else if (this.accessToken.getIssuedFor() != null) {
            ClientModel clientModel = this.keycloakSession.realms().getClientById(this.accessToken.getIssuedFor(), this.realm);
            clientUser = this.keycloakSession.users().getUserByServiceAccountClient(clientModel);
        }
        if (clientUser == null) {
            return false;
        }
        return this.accessToken.getSubject().equals(clientUser.getId());
    }
}

