/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;

public class ClientRegistrationAuth {
    private KeycloakSession session;
    private EventBuilder event;
    private RealmModel realm;
    private JsonWebToken jwt;
    private ClientInitialAccessModel initialAccessModel;

    public ClientRegistrationAuth(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.event = event;
    }

    private void init() {
        this.realm = this.session.getContext().getRealm();
        UriInfo uri = this.session.getContext().getUri();
        String authorizationHeader = (String)this.session.getContext().getRequestHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authorizationHeader == null) {
            return;
        }
        String[] split = authorizationHeader.split(" ");
        if (!split[0].equalsIgnoreCase("bearer")) {
            return;
        }
        this.jwt = ClientRegistrationTokenUtils.verifyToken(this.realm, uri, split[1]);
        if (this.jwt == null) {
            throw this.unauthorized();
        }
        if (this.isInitialAccessToken()) {
            this.initialAccessModel = this.session.sessions().getClientInitialAccessModel(this.session.getContext().getRealm(), this.jwt.getId());
            if (this.initialAccessModel == null) {
                throw this.unauthorized();
            }
        }
    }

    private boolean isBearerToken() {
        return this.jwt != null && "Bearer".equals(this.jwt.getType());
    }

    public boolean isInitialAccessToken() {
        return this.jwt != null && "InitialAccessToken".equals(this.jwt.getType());
    }

    public boolean isRegistrationAccessToken() {
        return this.jwt != null && "RegistrationAccessToken".equals(this.jwt.getType());
    }

    public void requireCreate() {
        this.init();
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.CREATE_CLIENT)) {
                return;
            }
            throw this.forbidden();
        }
        if (this.isInitialAccessToken() && this.initialAccessModel.getRemainingCount() > 0 && (this.initialAccessModel.getExpiration() == 0 || this.initialAccessModel.getTimestamp() + this.initialAccessModel.getExpiration() > Time.currentTime())) {
            return;
        }
        throw this.unauthorized();
    }

    public void requireView(ClientModel client) {
        this.init();
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS)) {
                if (client == null) {
                    throw this.notFound();
                }
                return;
            }
            throw this.forbidden();
        }
        if (this.isRegistrationAccessToken()) {
            if (client.getRegistrationToken() != null && client != null && client.getRegistrationToken().equals(this.jwt.getId())) {
                return;
            }
        } else {
            if (this.isInitialAccessToken()) {
                throw this.unauthorized();
            }
            if (this.authenticateClient(client)) {
                return;
            }
        }
        throw this.unauthorized();
    }

    public void requireUpdate(ClientModel client) {
        this.init();
        if (this.isBearerToken()) {
            if (this.hasRole(AdminRoles.MANAGE_CLIENTS)) {
                if (client == null) {
                    throw this.notFound();
                }
                return;
            }
            throw this.forbidden();
        }
        if (this.isRegistrationAccessToken() && client.getRegistrationToken() != null && client != null && client.getRegistrationToken().equals(this.jwt.getId())) {
            return;
        }
        throw this.unauthorized();
    }

    public ClientInitialAccessModel getInitialAccessModel() {
        return this.initialAccessModel;
    }

    private boolean hasRole(String ... role) {
        try {
            Map otherClaims = this.jwt.getOtherClaims();
            if (otherClaims != null) {
                Map resourceAccess = (Map)this.jwt.getOtherClaims().get("resource_access");
                if (resourceAccess == null) {
                    return false;
                }
                List roles = null;
                Map map = this.realm.getName().equals(Config.getAdminRealm()) ? (Map)resourceAccess.get(this.realm.getMasterAdminClient().getClientId()) : (Map)resourceAccess.get("realm-management");
                if (map != null) {
                    roles = (List)map.get("roles");
                }
                if (roles == null) {
                    return false;
                }
                for (String r : role) {
                    if (!roles.contains(r)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean authenticateClient(ClientModel client) {
        if (client.isPublicClient()) {
            return true;
        }
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(this.session, this.event);
        Response response = processor.authenticateClient();
        if (response != null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized();
        }
        ClientModel authClient = processor.getClient();
        if (client == null) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized();
        }
        if (!authClient.getClientId().equals(client.getClientId())) {
            this.event.client(client.getClientId()).error("not_allowed");
            throw this.unauthorized();
        }
        return true;
    }

    private Failure unauthorized() {
        this.event.error("not_allowed");
        return new UnauthorizedException();
    }

    private Failure forbidden() {
        this.event.error("not_allowed");
        return new ForbiddenException();
    }

    private Failure notFound() {
        this.event.error("not_allowed");
        return new NotFoundException("Client not found");
    }
}

