/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import java.util.concurrent.Callable;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;

public class ClusterAwareScheduledTaskRunner
extends ScheduledTaskRunner {
    private final int intervalSecs;

    public ClusterAwareScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task, long intervalMillis) {
        super(sessionFactory, task);
        this.intervalSecs = (int)(intervalMillis / 1000L);
    }

    @Override
    protected void runTask(final KeycloakSession session) {
        session.getTransaction().begin();
        ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
        String taskKey = this.task.getClass().getSimpleName();
        ExecutionResult result = clusterProvider.executeIfNotExecuted(taskKey, this.intervalSecs, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClusterAwareScheduledTaskRunner.this.task.run(session);
                return null;
            }
        });
        session.getTransaction().commit();
        if (result.isExecuted()) {
            logger.debugf("Executed scheduled task %s", taskKey);
        } else {
            logger.debugf("Skipped execution of task %s as other cluster node is executing it", taskKey);
        }
    }
}

