/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.util.Set;
import javax.ws.rs.core.UriInfo;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;

public class WebOriginsUtils {
    public static final String INCLUDE_REDIRECTS = "+";

    public static Set<String> resolveValidWebOrigins(UriInfo uriInfo, ClientModel client) {
        Set webOrigins = client.getWebOrigins();
        if (webOrigins != null && webOrigins.contains(INCLUDE_REDIRECTS)) {
            webOrigins.remove(INCLUDE_REDIRECTS);
            client.getRedirectUris();
            for (String redirectUri : RedirectUtils.resolveValidRedirects(uriInfo, client.getRootUrl(), client.getRedirectUris())) {
                if (!redirectUri.startsWith("http://") && !redirectUri.startsWith("https://")) continue;
                webOrigins.add(UriUtils.getOrigin((String)redirectUri));
            }
        }
        return webOrigins;
    }
}

