/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.InvocableScript;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptExecutionException;
import org.keycloak.scripting.ScriptingProvider;

public class DefaultScriptingProvider
implements ScriptingProvider {
    private final ScriptEngineManager scriptEngineManager;

    public DefaultScriptingProvider(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public InvocableScript prepareScript(ScriptModel script) {
        return this.prepareScript(script, ScriptBindingsConfigurer.EMPTY);
    }

    public InvocableScript prepareScript(ScriptModel script, ScriptBindingsConfigurer bindingsConfigurer) {
        if (script == null) {
            throw new NullPointerException("script must not be null");
        }
        if (script.getCode() == null || script.getCode().trim().isEmpty()) {
            throw new IllegalArgumentException("script must not be null or empty");
        }
        if (bindingsConfigurer == null) {
            throw new NullPointerException("bindingsConfigurer must not be null");
        }
        ScriptEngine engine = this.lookupScriptEngineFor(script);
        if (engine == null) {
            throw new IllegalStateException("Could not find ScriptEngine for script: " + script);
        }
        this.configureBindings(bindingsConfigurer, engine);
        this.loadScriptIntoEngine(script, engine);
        return new InvocableScript(script, engine);
    }

    private void configureBindings(ScriptBindingsConfigurer bindingsConfigurer, ScriptEngine engine) {
        Bindings bindings = engine.createBindings();
        bindingsConfigurer.configureBindings(bindings);
        engine.setBindings(bindings, 100);
    }

    private void loadScriptIntoEngine(ScriptModel script, ScriptEngine engine) {
        try {
            engine.eval(script.getCode());
        }
        catch (ScriptException se) {
            throw new ScriptExecutionException(script, se);
        }
    }

    private ScriptEngine lookupScriptEngineFor(ScriptModel script) {
        return this.scriptEngineManager.getEngineByMimeType(script.getMimeType());
    }

    public void close() {
    }
}

