/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.IdentityProviderResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.ReservedCharValidator;

public class IdentityProvidersResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;

    public IdentityProvidersResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.IDENTITY_PROVIDER);
    }

    @Path(value="/providers/{provider_id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getIdentityProviders(@PathParam(value="provider_id") String providerId) {
        this.auth.realm().requireViewIdentityProviders();
        IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
        if (providerFactory != null) {
            return Response.ok((Object)providerFactory).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Map<String, String> importFrom(MultipartFormDataInput input) throws IOException {
        this.auth.realm().requireManageIdentityProviders();
        Map formDataMap = input.getFormDataMap();
        if (!formDataMap.containsKey("providerId") || !formDataMap.containsKey("file")) {
            throw new BadRequestException();
        }
        String providerId = ((InputPart)((List)formDataMap.get("providerId")).get(0)).getBodyAsString();
        InputPart file = (InputPart)((List)formDataMap.get("file")).get(0);
        InputStream inputStream = (InputStream)file.getBody(InputStream.class, null);
        IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
        Map config = providerFactory.parseConfig(this.session, inputStream);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="import-config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> importFrom(Map<String, Object> data) throws IOException {
        this.auth.realm().requireManageIdentityProviders();
        if (!data.containsKey("providerId") || !data.containsKey("fromUrl")) {
            throw new BadRequestException();
        }
        ReservedCharValidator.validate((String)data.get("alias"));
        String providerId = data.get("providerId").toString();
        String from = data.get("fromUrl").toString();
        InputStream inputStream = ((HttpClientProvider)this.session.getProvider(HttpClientProvider.class)).get(from);
        try {
            Map config;
            IdentityProviderFactory providerFactory = this.getProviderFactoryById(providerId);
            Map map = config = providerFactory.parseConfig(this.session, inputStream);
            return map;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @GET
    @Path(value="instances")
    @NoCache
    @Produces(value={"application/json"})
    public Stream<IdentityProviderRepresentation> getIdentityProviders() {
        this.auth.realm().requireViewIdentityProviders();
        return this.realm.getIdentityProvidersStream().map(provider -> StripSecretsUtils.strip((IdentityProviderRepresentation)ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)provider)));
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    public Response create(IdentityProviderRepresentation representation) {
        this.auth.realm().requireManageIdentityProviders();
        ReservedCharValidator.validate(representation.getAlias());
        try {
            IdentityProviderModel identityProvider = RepresentationToModel.toModel((RealmModel)this.realm, (IdentityProviderRepresentation)representation, (KeycloakSession)this.session);
            this.realm.addIdentityProvider(identityProvider);
            representation.setInternalId(identityProvider.getInternalId());
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), identityProvider.getAlias()).representation(StripSecretsUtils.strip((IdentityProviderRepresentation)representation)).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(representation.getAlias()).build(new Object[0])).build();
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message == null) {
                message = "Invalid request";
            }
            return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Identity Provider " + representation.getAlias() + " already exists");
        }
    }

    @Path(value="instances/{alias}")
    public IdentityProviderResource getIdentityProvider(@PathParam(value="alias") String alias) {
        this.auth.realm().requireViewIdentityProviders();
        IdentityProviderModel identityProviderModel = this.realm.getIdentityProvidersStream().filter(p -> Objects.equals(p.getAlias(), alias) || Objects.equals(p.getInternalId(), alias)).findFirst().orElse(null);
        IdentityProviderResource identityProviderResource = new IdentityProviderResource(this.auth, this.realm, this.session, identityProviderModel, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)identityProviderResource);
        return identityProviderResource;
    }

    private IdentityProviderFactory getProviderFactoryById(String providerId) {
        return this.getProviderFactories().filter(providerFactory -> Objects.equals(providerId, providerFactory.getId())).map(IdentityProviderFactory.class::cast).findFirst().orElse(null);
    }

    private Stream<ProviderFactory> getProviderFactories() {
        return Streams.concat((Stream[])new Stream[]{this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class), this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class)});
    }
}

