/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.AbstractUserProfileProvider;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeGroupMetadata;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.DefaultAttributes;
import org.keycloak.userprofile.LegacyAttributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.config.DeclarativeUserProfileModel;
import org.keycloak.userprofile.config.UPAttribute;
import org.keycloak.userprofile.config.UPAttributePermissions;
import org.keycloak.userprofile.config.UPAttributeRequired;
import org.keycloak.userprofile.config.UPAttributeSelector;
import org.keycloak.userprofile.config.UPConfig;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.userprofile.config.UPGroup;
import org.keycloak.userprofile.validator.BlankAttributeValidator;
import org.keycloak.validate.ValidatorConfig;

public class DeclarativeUserProfileProvider
extends AbstractUserProfileProvider<UserProfileProvider>
implements AmphibianProviderFactory<UserProfileProvider> {
    public static final String ID = "declarative-user-profile";
    public static final int PROVIDER_PRIORITY = 1;
    public static final String UP_PIECES_COUNT_COMPONENT_CONFIG_KEY = "config-pieces-count";
    public static final String REALM_USER_PROFILE_ENABLED = "userProfileEnabled";
    private static final String PARSED_CONFIG_COMPONENT_KEY = "kc.user.profile.metadata";
    private static final String UP_PIECE_COMPONENT_CONFIG_KEY_BASE = "config-piece-";
    private static boolean isDeclarativeConfigurationEnabled;
    private String defaultRawConfig;

    private static boolean requestedScopePredicate(AttributeContext context, Set<String> configuredScopes) {
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (authenticationSession == null) {
            return false;
        }
        String requestedScopesString = authenticationSession.getClientNote("scope");
        ClientModel client = authenticationSession.getClient();
        return TokenManager.getRequestedClientScopes(requestedScopesString, client).map(csm -> csm.getName()).anyMatch(configuredScopes::contains);
    }

    public DeclarativeUserProfileProvider() {
        this.defaultRawConfig = UPConfigUtils.readDefaultConfig();
    }

    public DeclarativeUserProfileProvider(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry, String defaultRawConfig) {
        super(session, metadataRegistry);
        this.defaultRawConfig = defaultRawConfig;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected UserProfileProvider create(KeycloakSession session, Map<UserProfileContext, UserProfileMetadata> metadataRegistry) {
        return new DeclarativeUserProfileProvider(session, metadataRegistry, this.defaultRawConfig);
    }

    @Override
    protected Attributes createAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata metadata) {
        if (this.isEnabled(this.session).booleanValue()) {
            return new DefaultAttributes(context, attributes, user, metadata, this.session);
        }
        return new LegacyAttributes(context, attributes, user, metadata, this.session);
    }

    @Override
    protected UserProfileMetadata configureUserProfile(UserProfileMetadata metadata, KeycloakSession session) {
        UserProfileContext context = metadata.getContext();
        UserProfileMetadata decoratedMetadata = metadata.clone();
        if (!this.isEnabled(session).booleanValue()) {
            if (!(context.equals((Object)UserProfileContext.USER_API) || context.equals((Object)UserProfileContext.REGISTRATION_USER_CREATION) || context.equals((Object)UserProfileContext.UPDATE_EMAIL))) {
                decoratedMetadata.addAttribute("firstName", 1, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingFirstNameMessage", metadata.getContext() == UserProfileContext.IDP_REVIEW))}).setAttributeDisplayName("${firstName}");
                decoratedMetadata.addAttribute("lastName", 2, new AttributeValidatorMetadata[]{new AttributeValidatorMetadata("up-blank-attribute-value", BlankAttributeValidator.createConfig("missingLastNameMessage", metadata.getContext() == UserProfileContext.IDP_REVIEW))}).setAttributeDisplayName("${lastName}");
            }
            return decoratedMetadata;
        }
        ComponentModel model = this.getComponentModelOrCreate(session);
        HashMap<UserProfileContext, UserProfileMetadata> metadataMap = (HashMap<UserProfileContext, UserProfileMetadata>)model.getNote(PARSED_CONFIG_COMPONENT_KEY);
        if (metadataMap == null) {
            metadataMap = new HashMap<UserProfileContext, UserProfileMetadata>();
            model.setNote(PARSED_CONFIG_COMPONENT_KEY, metadataMap);
        }
        return metadataMap.computeIfAbsent(context, c -> this.decorateUserProfileForCache(decoratedMetadata, model));
    }

    public String getHelpText() {
        return null;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        String upConfigJson = this.getConfigJsonFromComponentModel(model);
        if (!ObjectUtil.isBlank((CharSequence)upConfigJson)) {
            try {
                UPConfig upc = this.parseConfig(upConfigJson);
                List<String> errors = UPConfigUtils.validate(session, upc);
                if (!errors.isEmpty()) {
                    throw new ComponentValidationException(errors.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                throw new ComponentValidationException(e.getMessage(), (Throwable)e);
            }
        }
        if (model != null) {
            model.removeNote(PARSED_CONFIG_COMPONENT_KEY);
        }
    }

    @Override
    public String getConfiguration() {
        if (!this.isEnabled(this.session).booleanValue()) {
            return null;
        }
        String cfg = this.getConfigJsonFromComponentModel(this.getComponentModel());
        if (ObjectUtil.isBlank((CharSequence)cfg)) {
            return this.defaultRawConfig;
        }
        return cfg;
    }

    @Override
    public void setConfiguration(String configuration) {
        ComponentModel component = this.getComponentModel();
        this.removeConfigJsonFromComponentModel(component);
        RealmModel realm = this.session.getContext().getRealm();
        if (!ObjectUtil.isBlank((CharSequence)configuration)) {
            List<String> parts = UPConfigUtils.getChunks(configuration, 3800);
            MultivaluedHashMap config = component.getConfig();
            config.putSingle((Object)UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, (Object)("" + parts.size()));
            int i = 0;
            for (String part : parts) {
                config.putSingle((Object)(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i++), (Object)part);
            }
            realm.updateComponent(component);
        } else {
            realm.removeComponent(component);
        }
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        isDeclarativeConfigurationEnabled = Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DECLARATIVE_USER_PROFILE);
    }

    public int order() {
        return 1;
    }

    public ComponentModel getComponentModel() {
        return this.getComponentModelOrCreate(this.session);
    }

    protected UserProfileMetadata decorateUserProfileForCache(UserProfileMetadata decoratedMetadata, ComponentModel model) {
        UserProfileContext context = decoratedMetadata.getContext();
        UPConfig parsedConfig = this.getParsedConfig(model);
        if (parsedConfig == null || context == UserProfileContext.REGISTRATION_USER_CREATION || context == UserProfileContext.UPDATE_EMAIL) {
            return decoratedMetadata;
        }
        Map<String, UPGroup> groupsByName = this.asHashMap(parsedConfig.getGroups());
        RealmModel realm = this.session.getContext().getRealm();
        int guiOrder = 0;
        for (UPAttribute attrConfig : parsedConfig.getAttributes()) {
            UPAttributeRequired rc;
            String attributeName = attrConfig.getName();
            ArrayList<AttributeValidatorMetadata> validators = new ArrayList<AttributeValidatorMetadata>();
            Map<String, Map<String, Object>> validationsConfig = attrConfig.getValidations();
            if (validationsConfig != null) {
                for (Map.Entry<String, Map<String, Object>> vc : validationsConfig.entrySet()) {
                    validators.add(this.createConfiguredValidator(vc.getKey(), vc.getValue()));
                }
            }
            if ((rc = attrConfig.getRequired()) != null) {
                validators.add(new AttributeValidatorMetadata("up-attribute-required-by-metadata-value"));
            }
            Predicate<AttributeContext> required = AttributeMetadata.ALWAYS_FALSE;
            if (rc != null && !this.isUsernameOrEmailAttribute(attributeName)) {
                if (rc.isAlways() || UPConfigUtils.isRoleForContext(context, rc.getRoles())) {
                    required = AttributeMetadata.ALWAYS_TRUE;
                } else if (UPConfigUtils.canBeAuthFlowContext(context) && rc.getScopes() != null && !rc.getScopes().isEmpty()) {
                    required = c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, rc.getScopes());
                }
            }
            Predicate<Object> writeAllowed = AttributeMetadata.ALWAYS_FALSE;
            Predicate<Object> readAllowed = AttributeMetadata.ALWAYS_FALSE;
            UPAttributePermissions permissions = attrConfig.getPermissions();
            if (permissions != null) {
                Set<String> viewRoles;
                Set<String> editRoles = permissions.getEdit();
                if (!editRoles.isEmpty()) {
                    writeAllowed = ac -> UPConfigUtils.isRoleForContext(ac.getContext(), editRoles);
                }
                readAllowed = (viewRoles = permissions.getView()).isEmpty() ? writeAllowed : this.createViewAllowedPredicate(writeAllowed, viewRoles);
            }
            Predicate<AttributeContext> selector = AttributeMetadata.ALWAYS_TRUE;
            UPAttributeSelector sc = attrConfig.getSelector();
            if (sc != null && !this.isUsernameOrEmailAttribute(attributeName) && UPConfigUtils.canBeAuthFlowContext(context) && sc.getScopes() != null && !sc.getScopes().isEmpty()) {
                selector = c -> DeclarativeUserProfileProvider.requestedScopePredicate(c, sc.getScopes());
            }
            Map<String, Object> annotations = attrConfig.getAnnotations();
            String attributeGroup = attrConfig.getGroup();
            AttributeGroupMetadata groupMetadata = this.toAttributeGroupMeta(groupsByName.get(attributeGroup));
            if (this.isUsernameOrEmailAttribute(attributeName)) {
                if (permissions == null || permissions.isEmpty()) {
                    writeAllowed = AttributeMetadata.ALWAYS_TRUE;
                    readAllowed = AttributeMetadata.ALWAYS_TRUE;
                }
                List atts = decoratedMetadata.getAttribute(attributeName);
                if (!realm.isRegistrationEmailAsUsername() || !"username".equals(attributeName)) {
                    validators.add(new AttributeValidatorMetadata("up-immutable-attribute"));
                }
                if (atts.isEmpty()) {
                    decoratedMetadata.addAttribute(attributeName, guiOrder++, (Predicate)writeAllowed, validators).addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setAttributeGroupMetadata(groupMetadata);
                    continue;
                }
                int localGuiOrder = guiOrder++;
                Predicate<Object> readAllowedFinal = readAllowed;
                Predicate<Object> writeAllowedFinal = writeAllowed;
                atts.stream().forEach(c -> c.addValidator(validators).addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setGuiOrder(localGuiOrder).setAttributeGroupMetadata(groupMetadata).addReadCondition(readAllowedFinal).addWriteCondition(writeAllowedFinal));
                continue;
            }
            validators.add(new AttributeValidatorMetadata("up-immutable-attribute"));
            decoratedMetadata.addAttribute(attributeName, guiOrder++, validators, selector, (Predicate)writeAllowed, required, (Predicate)readAllowed).addAnnotations(annotations).setAttributeDisplayName(attrConfig.getDisplayName()).setAttributeGroupMetadata(groupMetadata);
        }
        return decoratedMetadata;
    }

    private Map<String, UPGroup> asHashMap(List<UPGroup> groups) {
        return groups.stream().collect(Collectors.toMap(g -> g.getName(), g -> g));
    }

    private AttributeGroupMetadata toAttributeGroupMeta(UPGroup group) {
        if (group == null) {
            return null;
        }
        return new AttributeGroupMetadata(group.getName(), group.getDisplayHeader(), group.getDisplayDescription(), group.getAnnotations());
    }

    private boolean isUsernameOrEmailAttribute(String attributeName) {
        return "username".equals(attributeName) || "email".equals(attributeName);
    }

    private Predicate<AttributeContext> createViewAllowedPredicate(Predicate<AttributeContext> canEdit, Set<String> viewRoles) {
        return ac -> UPConfigUtils.isRoleForContext(ac.getContext(), viewRoles) || canEdit.test((AttributeContext)ac);
    }

    protected UPConfig getParsedConfig(ComponentModel model) {
        String rawConfig = this.getConfigJsonFromComponentModel(model);
        if (!ObjectUtil.isBlank((CharSequence)rawConfig)) {
            try {
                UPConfig upc = this.parseConfig(rawConfig);
                List<String> errors = UPConfigUtils.validate(this.session, upc);
                if (!errors.isEmpty()) {
                    throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid: " + errors.toString());
                }
                return upc;
            }
            catch (IOException e) {
                throw new RuntimeException("UserProfile configuration for realm '" + this.session.getContext().getRealm().getName() + "' is invalid:" + e.getMessage(), e);
            }
        }
        return null;
    }

    private UPConfig parseConfig(String rawConfig) throws IOException {
        return UPConfigUtils.readConfig(new ByteArrayInputStream(rawConfig.getBytes("UTF-8")));
    }

    private ComponentModel getComponentModelOrCreate(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).findAny().orElseGet(() -> realm.addComponentModel(this.createComponentModel()));
    }

    protected ComponentModel createComponentModel() {
        return new DeclarativeUserProfileModel(this.getId());
    }

    protected AttributeValidatorMetadata createConfiguredValidator(String validator, Map<String, Object> validatorConfig) {
        return new AttributeValidatorMetadata(validator, ValidatorConfig.builder().config(validatorConfig).config("ignore.empty.value", (Object)true).build());
    }

    private String getConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return null;
        }
        int count = model.get(UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, 0);
        if (count < 1) {
            return this.defaultRawConfig;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String v = model.get(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i);
            if (v == null) continue;
            sb.append(v);
        }
        return sb.toString();
    }

    private void removeConfigJsonFromComponentModel(ComponentModel model) {
        if (model == null) {
            return;
        }
        int count = model.get(UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, 0);
        if (count < 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            model.getConfig().remove((Object)(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i));
        }
        model.getConfig().remove((Object)UP_PIECES_COUNT_COMPONENT_CONFIG_KEY);
    }

    private Boolean isEnabled(KeycloakSession session) {
        return isDeclarativeConfigurationEnabled && session.getContext().getRealm().getAttribute(REALM_USER_PROFILE_ENABLED, Boolean.valueOf(false)) != false;
    }
}

