/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.ExchangeExternalToken;
import org.keycloak.broker.provider.ExchangeTokenToIdentityProviderToken;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.IdentityBrokerState;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.AsymmetricSignatureProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.MacSignatureSignerContext;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.utils.PkceUtils;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.vault.VaultStringSecret;

public abstract class AbstractOAuth2IdentityProvider<C extends OAuth2IdentityProviderConfig>
extends AbstractIdentityProvider<C>
implements ExchangeTokenToIdentityProviderToken,
ExchangeExternalToken {
    protected static final Logger logger = Logger.getLogger(AbstractOAuth2IdentityProvider.class);
    public static final String OAUTH2_GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String FEDERATED_REFRESH_TOKEN = "FEDERATED_REFRESH_TOKEN";
    public static final String FEDERATED_TOKEN_EXPIRATION = "FEDERATED_TOKEN_EXPIRATION";
    public static final String ACCESS_DENIED = "access_denied";
    protected static ObjectMapper mapper = new ObjectMapper();
    public static final String OAUTH2_PARAMETER_ACCESS_TOKEN = "access_token";
    public static final String OAUTH2_PARAMETER_SCOPE = "scope";
    public static final String OAUTH2_PARAMETER_STATE = "state";
    public static final String OAUTH2_PARAMETER_RESPONSE_TYPE = "response_type";
    public static final String OAUTH2_PARAMETER_REDIRECT_URI = "redirect_uri";
    public static final String OAUTH2_PARAMETER_CODE = "code";
    public static final String OAUTH2_PARAMETER_CLIENT_ID = "client_id";
    public static final String OAUTH2_PARAMETER_CLIENT_SECRET = "client_secret";
    public static final String OAUTH2_PARAMETER_GRANT_TYPE = "grant_type";
    private static final String BROKER_CODE_CHALLENGE_PARAM = "BROKER_CODE_CHALLENGE";
    private static final String BROKER_CODE_CHALLENGE_METHOD_PARAM = "BROKER_CODE_CHALLENGE_METHOD";

    public AbstractOAuth2IdentityProvider(KeycloakSession session, C config) {
        super(session, config);
        if (((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope() == null || ((OAuth2IdentityProviderConfig)((Object)config)).getDefaultScope().isEmpty()) {
            ((OAuth2IdentityProviderConfig)((Object)config)).setDefaultScope(this.getDefaultScopes());
        }
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new Endpoint(callback, realm, event, this);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            URI authorizationUrl = this.createAuthorizationUrl(request).build(new Object[0]);
            return Response.seeOther((URI)authorizationUrl).build();
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    public Response retrieveToken(KeycloakSession session, FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).type("application/json").build();
    }

    public C getConfig() {
        return (C)((Object)((OAuth2IdentityProviderConfig)super.getConfig()));
    }

    protected String extractTokenFromResponse(String response, String tokenName) {
        if (response == null) {
            return null;
        }
        if (response.startsWith("{")) {
            try {
                JsonNode node = mapper.readTree(response);
                if (node.has(tokenName)) {
                    String s = node.get(tokenName).textValue();
                    if (s == null || s.trim().isEmpty()) {
                        return null;
                    }
                    return s;
                }
                return null;
            }
            catch (IOException e) {
                throw new IdentityBrokerException("Could not extract token [" + tokenName + "] from response [" + response + "] due: " + e.getMessage(), (Throwable)e);
            }
        }
        Matcher matcher = Pattern.compile(tokenName + "=([^&]+)").matcher(response);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public Response exchangeFromToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject, MultivaluedMap<String, String> params) {
        Response tokenResponse = this.hasExternalExchangeToken(event, tokenUserSession, params);
        if (tokenResponse != null) {
            return tokenResponse;
        }
        String requestedType = (String)params.getFirst((Object)"requested_token_type");
        if (requestedType != null && !requestedType.equals("urn:ietf:params:oauth:token-type:access_token")) {
            event.detail("reason", "requested_token_type unsupported");
            event.error("invalid_request");
            return this.exchangeUnsupportedRequiredType();
        }
        if (!this.getConfig().isStoreToken()) {
            String brokerId = tokenUserSession.getNote("identity_provider");
            String string = brokerId = brokerId == null ? tokenUserSession.getNote("EXTERNAL_IDENTITY_PROVIDER") : brokerId;
            if (brokerId == null || !brokerId.equals(this.getConfig().getAlias())) {
                event.detail("reason", "requested_issuer has not linked");
                event.error("invalid_request");
                return this.exchangeNotLinkedNoStore(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
            }
            return this.exchangeSessionToken(uriInfo, event, authorizedClient, tokenUserSession, tokenSubject);
        }
        return this.exchangeStoredToken(uriInfo, event, authorizedClient, tokenUserSession, tokenSubject);
    }

    protected Response hasExternalExchangeToken(EventBuilder event, UserSessionModel tokenUserSession, MultivaluedMap<String, String> params) {
        if (this.getConfig().getAlias().equals(tokenUserSession.getNote("EXCHANGE_PROVIDER"))) {
            String idToken;
            String requestedType = (String)params.getFirst((Object)"requested_token_type");
            if (requestedType == null || requestedType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
                if (accessToken != null) {
                    AccessTokenResponse tokenResponse = new AccessTokenResponse();
                    tokenResponse.setToken(accessToken);
                    tokenResponse.setIdToken(null);
                    tokenResponse.setRefreshToken(null);
                    tokenResponse.setRefreshExpiresIn(0L);
                    tokenResponse.setExpiresIn(0L);
                    tokenResponse.getOtherClaims().clear();
                    tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
                    event.success();
                    return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
                }
            } else if ("urn:ietf:params:oauth:token-type:id_token".equals(requestedType) && (idToken = tokenUserSession.getNote("FEDERATED_ID_TOKEN")) != null) {
                AccessTokenResponse tokenResponse = new AccessTokenResponse();
                tokenResponse.setToken(null);
                tokenResponse.setIdToken(idToken);
                tokenResponse.setRefreshToken(null);
                tokenResponse.setRefreshExpiresIn(0L);
                tokenResponse.setExpiresIn(0L);
                tokenResponse.getOtherClaims().clear();
                tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:id_token");
                event.success();
                return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
        }
        return null;
    }

    protected Response exchangeStoredToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        FederatedIdentityModel model = this.session.users().getFederatedIdentity(authorizedClient.getRealm(), tokenSubject, this.getConfig().getAlias());
        if (model == null || model.getToken() == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeNotLinked(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        String accessToken = this.extractTokenFromResponse(model.getToken(), this.getAccessTokenResponseParameter());
        if (accessToken == null) {
            model.setToken(null);
            this.session.users().updateFederatedIdentity(authorizedClient.getRealm(), tokenSubject, model);
            event.detail("reason", "requested_issuer token expired");
            event.error("invalid_token");
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        event.success();
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected Response exchangeSessionToken(UriInfo uriInfo, EventBuilder event, ClientModel authorizedClient, UserSessionModel tokenUserSession, UserModel tokenSubject) {
        String accessToken = tokenUserSession.getNote("FEDERATED_ACCESS_TOKEN");
        if (accessToken == null) {
            event.detail("reason", "requested_issuer is not linked");
            event.error("invalid_token");
            return this.exchangeTokenExpired(uriInfo, authorizedClient, tokenUserSession, tokenSubject);
        }
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setToken(accessToken);
        tokenResponse.setIdToken(null);
        tokenResponse.setRefreshToken(null);
        tokenResponse.setRefreshExpiresIn(0L);
        tokenResponse.getOtherClaims().clear();
        tokenResponse.getOtherClaims().put("issued_token_type", "urn:ietf:params:oauth:token-type:access_token");
        tokenResponse.getOtherClaims().put("account-link-url", this.getLinkingUrl(uriInfo, authorizedClient, tokenUserSession));
        event.success();
        return Response.ok((Object)tokenResponse).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public BrokeredIdentityContext getFederatedIdentity(String response) {
        String accessToken = this.extractTokenFromResponse(response, this.getAccessTokenResponseParameter());
        if (accessToken == null) {
            throw new IdentityBrokerException("No access token available in OAuth server response: " + response);
        }
        BrokeredIdentityContext context = this.doGetFederatedIdentity(accessToken);
        context.getContextData().put("FEDERATED_ACCESS_TOKEN", accessToken);
        return context;
    }

    protected String getAccessTokenResponseParameter() {
        return OAUTH2_PARAMETER_ACCESS_TOKEN;
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        return null;
    }

    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        String acr;
        String prompt;
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.getConfig().getAuthorizationUrl()).queryParam(OAUTH2_PARAMETER_SCOPE, new Object[]{this.getConfig().getDefaultScope()}).queryParam(OAUTH2_PARAMETER_STATE, new Object[]{request.getState().getEncoded()}).queryParam(OAUTH2_PARAMETER_RESPONSE_TYPE, new Object[]{OAUTH2_PARAMETER_CODE}).queryParam(OAUTH2_PARAMETER_CLIENT_ID, new Object[]{this.getConfig().getClientId()}).queryParam(OAUTH2_PARAMETER_REDIRECT_URI, new Object[]{request.getRedirectUri()});
        String loginHint = request.getAuthenticationSession().getClientNote("login_hint");
        if (this.getConfig().isLoginHint() && loginHint != null) {
            uriBuilder.queryParam("login_hint", new Object[]{loginHint});
        }
        if (this.getConfig().isUiLocales()) {
            uriBuilder.queryParam("ui_locales", new Object[]{this.session.getContext().resolveLocale(null).toLanguageTag()});
        }
        if ((prompt = this.getConfig().getPrompt()) == null || prompt.isEmpty()) {
            prompt = request.getAuthenticationSession().getClientNote("prompt");
        }
        if (prompt != null) {
            uriBuilder.queryParam("prompt", new Object[]{prompt});
        }
        if ((acr = request.getAuthenticationSession().getClientNote("acr_values")) != null) {
            uriBuilder.queryParam("acr_values", new Object[]{acr});
        }
        String forwardParameterConfig = this.getConfig().getForwardParameters() != null ? this.getConfig().getForwardParameters() : "";
        List<String> forwardParameters = Arrays.asList(forwardParameterConfig.split("\\s*,\\s*"));
        for (String forwardParameter : forwardParameters) {
            String name = "client_request_param_" + forwardParameter.trim();
            String parameter = request.getAuthenticationSession().getClientNote(name);
            if (parameter == null || parameter.isEmpty()) continue;
            uriBuilder.queryParam(forwardParameter, new Object[]{parameter});
        }
        if (this.getConfig().isPkceEnabled()) {
            String codeVerifier = PkceUtils.generateCodeVerifier();
            String codeChallengeMethod = this.getConfig().getPkceMethod();
            request.getAuthenticationSession().setClientNote(BROKER_CODE_CHALLENGE_PARAM, codeVerifier);
            request.getAuthenticationSession().setClientNote(BROKER_CODE_CHALLENGE_METHOD_PARAM, codeChallengeMethod);
            String codeChallenge = PkceUtils.encodeCodeChallenge(codeVerifier, codeChallengeMethod);
            uriBuilder.queryParam("code_challenge", new Object[]{codeChallenge});
            uriBuilder.queryParam("code_challenge_method", new Object[]{codeChallengeMethod});
        }
        return uriBuilder;
    }

    public String getJsonProperty(JsonNode jsonNode, String name) {
        if (jsonNode.has(name) && !jsonNode.get(name).isNull()) {
            String s = jsonNode.get(name).asText();
            if (s != null && !s.isEmpty()) {
                return s;
            }
            return null;
        }
        return null;
    }

    public JsonNode asJsonNode(String json) throws IOException {
        return mapper.readTree(json);
    }

    protected abstract String getDefaultScopes();

    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        String token = (String)context.getContextData().get("FEDERATED_ACCESS_TOKEN");
        if (token != null) {
            authSession.setUserSessionNote("FEDERATED_ACCESS_TOKEN", token);
        }
    }

    public SimpleHttp authenticateTokenRequest(SimpleHttp tokenRequest) {
        if (this.getConfig().isJWTAuthentication()) {
            String jws = new JWSBuilder().type("JWT").jsonContent((Object)this.generateToken()).sign(this.getSignatureContext());
            return tokenRequest.param("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer").param("client_assertion", jws);
        }
        try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(this.getConfig().getClientSecret());){
            if (this.getConfig().isBasicAuthentication()) {
                SimpleHttp simpleHttp = tokenRequest.authBasic(this.getConfig().getClientId(), vaultStringSecret.get().orElse(this.getConfig().getClientSecret()));
                return simpleHttp;
            }
            SimpleHttp simpleHttp = tokenRequest.param(OAUTH2_PARAMETER_CLIENT_ID, this.getConfig().getClientId()).param(OAUTH2_PARAMETER_CLIENT_SECRET, vaultStringSecret.get().orElse(this.getConfig().getClientSecret()));
            return simpleHttp;
        }
    }

    protected JsonWebToken generateToken() {
        JsonWebToken jwt = new JsonWebToken();
        jwt.id(KeycloakModelUtils.generateId());
        jwt.type("JWT");
        jwt.issuer(this.getConfig().getClientId());
        jwt.subject(this.getConfig().getClientId());
        jwt.audience(new String[]{this.getConfig().getTokenUrl()});
        int expirationDelay = this.session.getContext().getRealm().getAccessCodeLifespan();
        jwt.expiration(Time.currentTime() + expirationDelay);
        jwt.issuedNow();
        return jwt;
    }

    protected SignatureSignerContext getSignatureContext() {
        if (this.getConfig().getClientAuthMethod().equals("client_secret_jwt")) {
            try (VaultStringSecret vaultStringSecret = this.session.vault().getStringSecret(this.getConfig().getClientSecret());){
                KeyWrapper key = new KeyWrapper();
                String alg = this.getConfig().getClientAssertionSigningAlg() != null ? this.getConfig().getClientAssertionSigningAlg() : "HS256";
                key.setAlgorithm(alg);
                byte[] decodedSecret = vaultStringSecret.get().orElse(this.getConfig().getClientSecret()).getBytes();
                SecretKeySpec secret = new SecretKeySpec(decodedSecret, 0, decodedSecret.length, alg);
                key.setSecretKey((SecretKey)secret);
                MacSignatureSignerContext macSignatureSignerContext = new MacSignatureSignerContext(key);
                return macSignatureSignerContext;
            }
        }
        String alg = this.getConfig().getClientAssertionSigningAlg() != null ? this.getConfig().getClientAssertionSigningAlg() : "RS256";
        return new AsymmetricSignatureProvider(this.session, alg).signer();
    }

    protected String getProfileEndpointForValidation(EventBuilder event) {
        event.detail("reason", "exchange unsupported");
        event.error("invalid_token");
        throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
    }

    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode node) {
        return null;
    }

    protected BrokeredIdentityContext validateExternalTokenThroughUserInfo(EventBuilder event, String subjectToken, String subjectTokenType) {
        event.detail("validation_method", "user info");
        SimpleHttp.Response response = null;
        int status = 0;
        try {
            String userInfoUrl = this.getProfileEndpointForValidation(event);
            response = this.buildUserInfoRequest(subjectToken, userInfoUrl).asResponse();
            status = response.getStatus();
        }
        catch (IOException e) {
            logger.debug((Object)"Failed to invoke user info for external exchange", (Throwable)e);
        }
        if (status != 200) {
            logger.debug((Object)("Failed to invoke user info status: " + status));
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        JsonNode profile = null;
        try {
            profile = response.asJson();
        }
        catch (IOException e) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        BrokeredIdentityContext context = this.extractIdentityFromProfile(event, profile);
        if (context.getId() == null) {
            event.detail("reason", "user info call failure");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "invalid token", Response.Status.BAD_REQUEST);
        }
        return context;
    }

    protected SimpleHttp buildUserInfoRequest(String subjectToken, String userInfoUrl) {
        return SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + subjectToken);
    }

    protected boolean supportsExternalExchange() {
        return false;
    }

    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        if (!this.supportsExternalExchange()) {
            return false;
        }
        String requestedIssuer = (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        return requestedIssuer.equals(this.getConfig().getAlias());
    }

    public final BrokeredIdentityContext exchangeExternal(EventBuilder event, MultivaluedMap<String, String> params) {
        if (!this.supportsExternalExchange()) {
            return null;
        }
        BrokeredIdentityContext context = this.exchangeExternalImpl(event, params);
        if (context != null) {
            context.setIdp((IdentityProvider)this);
            context.setIdpConfig(this.getConfig());
        }
        return context;
    }

    protected BrokeredIdentityContext exchangeExternalImpl(EventBuilder event, MultivaluedMap<String, String> params) {
        return this.exchangeExternalUserInfoValidationOnly(event, params);
    }

    protected BrokeredIdentityContext exchangeExternalUserInfoValidationOnly(EventBuilder event, MultivaluedMap<String, String> params) {
        String subjectToken = (String)params.getFirst((Object)"subject_token");
        if (subjectToken == null) {
            event.detail("reason", "subject_token param unset");
            event.error("invalid_token");
            throw new ErrorResponseException("invalid_token", "token not set", Response.Status.BAD_REQUEST);
        }
        String subjectTokenType = (String)params.getFirst((Object)"subject_token_type");
        if (subjectTokenType == null) {
            subjectTokenType = "urn:ietf:params:oauth:token-type:access_token";
        }
        if (!"urn:ietf:params:oauth:token-type:access_token".equals(subjectTokenType)) {
            event.detail("reason", "subject_token_type invalid");
            event.error("invalid_token_type");
            throw new ErrorResponseException("invalid_token", "invalid token type", Response.Status.BAD_REQUEST);
        }
        return this.validateExternalTokenThroughUserInfo(event, subjectToken, subjectTokenType);
    }

    public void exchangeExternalComplete(UserSessionModel userSession, BrokeredIdentityContext context, MultivaluedMap<String, String> params) {
        if (context.getContextData().containsKey("VALIDATED_ID_TOKEN")) {
            userSession.setNote("FEDERATED_ACCESS_TOKEN", (String)params.getFirst((Object)"subject_token"));
        }
        if (context.getContextData().containsKey("VALIDATED_ID_TOKEN")) {
            userSession.setNote("FEDERATED_ID_TOKEN", (String)params.getFirst((Object)"subject_token"));
        }
        userSession.setNote("EXCHANGE_PROVIDER", this.getConfig().getAlias());
    }

    protected static class Endpoint {
        protected final IdentityProvider.AuthenticationCallback callback;
        protected final RealmModel realm;
        protected final EventBuilder event;
        private final AbstractOAuth2IdentityProvider provider;
        protected final KeycloakSession session;
        protected final ClientConnection clientConnection;
        protected final HttpHeaders headers;
        protected final HttpRequest httpRequest;

        public Endpoint(IdentityProvider.AuthenticationCallback callback, RealmModel realm, EventBuilder event, AbstractOAuth2IdentityProvider provider) {
            this.callback = callback;
            this.realm = realm;
            this.event = event;
            this.provider = provider;
            this.session = provider.session;
            this.clientConnection = this.session.getContext().getConnection();
            this.httpRequest = this.session.getContext().getHttpRequest();
            this.headers = this.session.getContext().getRequestHeaders();
        }

        @GET
        public Response authResponse(@QueryParam(value="state") String state, @QueryParam(value="code") String authorizationCode, @QueryParam(value="error") String error) {
            if (state == null) {
                return this.errorIdentityProviderLogin("identityProviderMissingStateMessage");
            }
            try {
                AuthenticationSessionModel authSession = this.callback.getAndVerifyAuthenticationSession(state);
                this.session.getContext().setAuthenticationSession(authSession);
                IdentityProviderModel providerConfig = this.provider.getConfig();
                if (error != null) {
                    logger.error((Object)(error + " for broker login " + providerConfig.getProviderId()));
                    if (error.equals(AbstractOAuth2IdentityProvider.ACCESS_DENIED)) {
                        return this.callback.cancelled(providerConfig);
                    }
                    if (error.equals("login_required") || error.equals("interaction_required")) {
                        return this.callback.error(error);
                    }
                    return this.callback.error("identityProviderUnexpectedErrorMessage");
                }
                if (authorizationCode != null) {
                    String response = this.generateTokenRequest(authorizationCode).asString();
                    BrokeredIdentityContext federatedIdentity = this.provider.getFederatedIdentity(response);
                    if (providerConfig.isStoreToken() && federatedIdentity.getToken() == null) {
                        federatedIdentity.setToken(response);
                    }
                    federatedIdentity.setIdpConfig(providerConfig);
                    federatedIdentity.setIdp((IdentityProvider)this.provider);
                    federatedIdentity.setAuthenticationSession(authSession);
                    return this.callback.authenticated(federatedIdentity);
                }
            }
            catch (WebApplicationException e) {
                return e.getResponse();
            }
            catch (IdentityBrokerException e) {
                if (e.getMessageCode() != null) {
                    return this.errorIdentityProviderLogin(e.getMessageCode());
                }
                logger.error((Object)"Failed to make identity provider oauth callback", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to make identity provider oauth callback", (Throwable)e);
            }
            return this.errorIdentityProviderLogin("identityProviderUnexpectedErrorMessage");
        }

        private Response errorIdentityProviderLogin(String message) {
            this.event.event(EventType.IDENTITY_PROVIDER_LOGIN);
            this.event.error("identity_provider_login_failure");
            return ErrorPage.error(this.session, null, Response.Status.BAD_GATEWAY, message, new Object[0]);
        }

        public SimpleHttp generateTokenRequest(String authorizationCode) {
            KeycloakContext context = this.session.getContext();
            IdentityProviderModel providerConfig = this.provider.getConfig();
            SimpleHttp tokenRequest = SimpleHttp.doPost((String)providerConfig.getTokenUrl(), (KeycloakSession)this.session).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_CODE, authorizationCode).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_REDIRECT_URI, Urls.identityProviderAuthnResponse(context.getUri().getBaseUri(), providerConfig.getAlias(), context.getRealm().getName()).toString()).param(AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_GRANT_TYPE, AbstractOAuth2IdentityProvider.OAUTH2_GRANT_TYPE_AUTHORIZATION_CODE);
            if (providerConfig.isPkceEnabled()) {
                String stateParam = (String)this.session.getContext().getUri().getQueryParameters().getFirst((Object)AbstractOAuth2IdentityProvider.OAUTH2_PARAMETER_STATE);
                if (stateParam == null) {
                    logger.warn((Object)"Cannot lookup PKCE code_verifier: state param is missing.");
                    return tokenRequest;
                }
                RealmModel realm = context.getRealm();
                IdentityBrokerState idpBrokerState = IdentityBrokerState.encoded((String)stateParam, (RealmModel)realm);
                ClientModel client = realm.getClientByClientId(idpBrokerState.getClientId());
                AuthenticationSessionModel authSession = ClientSessionCode.getClientSession(idpBrokerState.getEncoded(), idpBrokerState.getTabId(), this.session, realm, client, this.event, AuthenticationSessionModel.class);
                if (authSession == null) {
                    logger.warnf("Cannot lookup PKCE code_verifier: authSession not found. state=%s", (Object)stateParam);
                    return tokenRequest;
                }
                String brokerCodeChallenge = authSession.getClientNote(AbstractOAuth2IdentityProvider.BROKER_CODE_CHALLENGE_PARAM);
                if (brokerCodeChallenge == null) {
                    logger.warnf("Cannot lookup PKCE code_verifier: brokerCodeChallenge not found. state=%s", (Object)stateParam);
                    return tokenRequest;
                }
                tokenRequest.param("code_verifier", brokerCodeChallenge);
            }
            return this.provider.authenticateTokenRequest(tokenRequest);
        }
    }
}

