/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.broker.provider.IdentityProviderMapperSyncModeDelegate;
import org.keycloak.broker.provider.util.IdentityBrokerState;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.Time;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.SessionCodeChecks;
import org.keycloak.services.util.AuthenticationFlowURLHelper;
import org.keycloak.services.util.BrowserHistoryHelper;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.validation.Validation;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

public class IdentityBrokerService
implements IdentityProvider.AuthenticationCallback {
    private static final String LINKING_IDENTITY_PROVIDER = "LINKING_IDENTITY_PROVIDER";
    private static final Logger logger = Logger.getLogger(IdentityBrokerService.class);
    private final RealmModel realmModel;
    private final KeycloakSession session;
    private final ClientConnection clientConnection;
    private final HttpRequest request;
    private final HttpHeaders headers;
    private EventBuilder event;

    public IdentityBrokerService(KeycloakSession session) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realmModel = session.getContext().getRealm();
        if (this.realmModel == null) {
            throw new IllegalArgumentException("Realm can not be null.");
        }
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    public void init() {
        this.event = new EventBuilder(this.realmModel, this.session, this.clientConnection).event(EventType.IDENTITY_PROVIDER_LOGIN);
    }

    private void checkRealm() {
        if (!this.realmModel.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
        }
    }

    private ClientModel checkClient(String clientId) {
        if (clientId == null) {
            this.event.error("invalid_request");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "missingParameterMessage", "client_id");
        }
        this.event.client(clientId);
        ClientModel client = this.realmModel.getClientByClientId(clientId);
        if (client == null) {
            this.event.error("client_not_found");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
        if (!client.isEnabled()) {
            this.event.error("client_disabled");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
        return client;
    }

    @OPTIONS
    @Path(value="/{provider_id}/link")
    public Response clientIntiatedAccountLinkingPreflight(@PathParam(value="provider_id") String providerId) {
        return Response.status((int)403).build();
    }

    @GET
    @NoCache
    @Path(value="/{provider_id}/link")
    public Response clientInitiatedAccountLinking(@PathParam(value="provider_id") String providerId, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="client_id") String clientId, @QueryParam(value="nonce") String nonce, @QueryParam(value="hash") String hash) {
        IdentityProviderModel identityProviderModel;
        this.event.event(EventType.CLIENT_INITIATED_ACCOUNT_LINKING);
        this.checkRealm();
        ClientModel client = this.checkClient(clientId);
        redirectUri = RedirectUtils.verifyRedirectUri(this.session, redirectUri, client);
        if (redirectUri == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
        this.event.detail("redirect_uri", redirectUri);
        if (nonce == null || hash == null) {
            this.event.error("invalid_redirect_uri");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
        AuthenticationManager.AuthResult cookieResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realmModel, true);
        String errorParam = "link_error";
        if (cookieResult == null) {
            this.event.error("not_logged_in");
            UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"not_logged_in"}).queryParam("nonce", new Object[]{nonce});
            return Response.status((int)302).location(builder.build(new Object[0])).build();
        }
        cookieResult.getSession();
        this.event.session(cookieResult.getSession());
        this.event.user(cookieResult.getUser());
        this.event.detail("username", cookieResult.getUser().getUsername());
        AuthenticatedClientSessionModel clientSession = null;
        for (AuthenticatedClientSessionModel cs : cookieResult.getSession().getAuthenticatedClientSessions().values()) {
            if (!cs.getClient().getClientId().equals(clientId)) continue;
            byte[] decoded = Base64Url.decode((String)hash);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new ErrorPageException(this.session, Response.Status.INTERNAL_SERVER_ERROR, "unexpectedErrorHandlingRequestMessage", new Object[0]);
            }
            String input = nonce + cookieResult.getSession().getId() + clientId + providerId;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            if (!MessageDigest.isEqual(decoded, check)) continue;
            clientSession = cs;
            break;
        }
        if (clientSession == null) {
            this.event.error("invalid_token");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }
        this.event.detail("identity_provider", providerId);
        ClientModel accountService = this.realmModel.getClientByClientId("account");
        if (!accountService.getId().equals(client.getId())) {
            RoleModel linkRole;
            RoleModel manageAccountRole = accountService.getRole("manage-account");
            DefaultClientSessionContext ctx = DefaultClientSessionContext.fromClientSessionScopeParameter(clientSession, this.session);
            Set userAccountRoles = ctx.getRolesStream().collect(Collectors.toSet());
            if (!userAccountRoles.contains(manageAccountRole) && !userAccountRoles.contains(linkRole = accountService.getRole("manage-account-links"))) {
                this.event.error("not_allowed");
                UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"not_allowed"}).queryParam("nonce", new Object[]{nonce});
                return Response.status((int)302).location(builder.build(new Object[0])).build();
            }
        }
        if ((identityProviderModel = this.realmModel.getIdentityProviderByAlias(providerId)) == null) {
            this.event.error("unknown_identity_provider");
            UriBuilder builder = UriBuilder.fromUri((String)redirectUri).queryParam(errorParam, new Object[]{"unknown_identity_provider"}).queryParam("nonce", new Object[]{nonce});
            return Response.status((int)302).location(builder.build(new Object[0])).build();
        }
        UserSessionModel userSession = cookieResult.getSession();
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(this.realmModel, userSession.getId());
        if (rootAuthSession == null) {
            rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(this.realmModel, userSession.getId());
        }
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        new AuthenticationSessionManager(this.session).setAuthSessionCookie(userSession.getId(), this.realmModel);
        ClientSessionCode<AuthenticationSessionModel> clientSessionCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realmModel, authSession);
        clientSessionCode.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        clientSessionCode.getOrGenerateCode();
        authSession.setProtocol(client.getProtocol());
        authSession.setRedirectUri(redirectUri);
        authSession.setClientNote("state", UUID.randomUUID().toString());
        authSession.setAuthNote(LINKING_IDENTITY_PROVIDER, cookieResult.getSession().getId() + clientId + providerId);
        this.event.detail("code_id", userSession.getId());
        this.event.success();
        try {
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
            Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                if (this.isDebugEnabled()) {
                    logger.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage(authSession, Response.Status.INTERNAL_SERVER_ERROR, "couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage(authSession, Response.Status.INTERNAL_SERVER_ERROR, "unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage(authSession, Response.Status.INTERNAL_SERVER_ERROR, "couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @POST
    @Path(value="/{provider_id}/login")
    public Response performPostLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="session_code") String code, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="login_hint") String loginHint) {
        return this.performLogin(providerId, code, clientId, tabId, loginHint);
    }

    @GET
    @NoCache
    @Path(value="/{provider_id}/login")
    public Response performLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="session_code") String code, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId, @QueryParam(value="login_hint") String loginHint) {
        this.event.detail("identity_provider", providerId);
        if (this.isDebugEnabled()) {
            logger.debugf("Sending authentication request to identity provider [%s].", (Object)providerId);
        }
        try {
            IdentityProviderFactory providerFactory;
            IdentityProvider identityProvider;
            Response response;
            AuthenticationSessionModel authSession = this.parseSessionCode(code, clientId, tabId);
            ClientSessionCode<AuthenticationSessionModel> clientSessionCode = new ClientSessionCode<AuthenticationSessionModel>(this.session, this.realmModel, authSession);
            clientSessionCode.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
            IdentityProviderModel identityProviderModel = this.realmModel.getIdentityProviderByAlias(providerId);
            if (identityProviderModel == null) {
                throw new IdentityBrokerException("Identity Provider [" + providerId + "] not found.");
            }
            if (identityProviderModel.isLinkOnly()) {
                throw new IdentityBrokerException("Identity Provider [" + providerId + "] is not allowed to perform a login.");
            }
            if (clientSessionCode != null && clientSessionCode.getClientSession() != null && loginHint != null) {
                clientSessionCode.getClientSession().setClientNote("login_hint", loginHint);
            }
            if ((response = (identityProvider = (providerFactory = IdentityBrokerService.getIdentityProviderFactory(this.session, identityProviderModel)).create(this.session, identityProviderModel)).performLogin(this.createAuthenticationRequest(providerId, clientSessionCode))) != null) {
                if (this.isDebugEnabled()) {
                    logger.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage(Response.Status.BAD_GATEWAY, "couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage(Response.Status.INTERNAL_SERVER_ERROR, "unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage(Response.Status.INTERNAL_SERVER_ERROR, "couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @Path(value="{provider_id}/endpoint")
    public Object getEndpoint(@PathParam(value="provider_id") String providerId) {
        IdentityProvider identityProvider;
        try {
            identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
        }
        catch (IdentityBrokerException e) {
            throw new NotFoundException(e.getMessage());
        }
        return identityProvider.callback(this.realmModel, (IdentityProvider.AuthenticationCallback)this, this.event);
    }

    @Path(value="{provider_id}/token")
    @OPTIONS
    public Response retrieveTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    @Path(value="{provider_id}/token")
    public Response retrieveToken(@PathParam(value="provider_id") String providerId) {
        return this.getToken(providerId, false);
    }

    private boolean canReadBrokerToken(AccessToken token) {
        Map resourceAccess = token.getResourceAccess();
        AccessToken.Access brokerRoles = resourceAccess == null ? null : (AccessToken.Access)resourceAccess.get("broker");
        return brokerRoles != null && brokerRoles.isUserInRole("read-token");
    }

    private Response getToken(String providerId, boolean forceRetrieval) {
        this.event.event(EventType.IDENTITY_PROVIDER_RETRIEVE_TOKEN);
        try {
            AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(this.realmModel).setConnection(this.clientConnection).setHeaders(this.request.getHttpHeaders()).authenticate();
            if (authResult != null) {
                AccessToken token = authResult.getToken();
                ClientModel clientModel = authResult.getClient();
                this.session.getContext().setClient(clientModel);
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    return this.corsResponse(this.forbidden("Realm has not migrated to support the broker token exchange service"), clientModel);
                }
                if (!this.canReadBrokerToken(token)) {
                    return this.corsResponse(this.forbidden("Client [" + clientModel.getClientId() + "] not authorized to retrieve tokens from identity provider [" + providerId + "]."), clientModel);
                }
                IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
                IdentityProviderModel identityProviderConfig = this.getIdentityProviderConfig(providerId);
                if (identityProviderConfig.isStoreToken()) {
                    FederatedIdentityModel identity = this.session.users().getFederatedIdentity(this.realmModel, authResult.getUser(), providerId);
                    if (identity == null) {
                        return this.corsResponse(this.badRequest("User [" + authResult.getUser().getId() + "] is not associated with identity provider [" + providerId + "]."), clientModel);
                    }
                    if (identity.getToken() == null) {
                        return this.corsResponse(this.notFound("No token stored for user [" + authResult.getUser().getId() + "] with associated identity provider [" + providerId + "]."), clientModel);
                    }
                    this.event.success();
                    return this.corsResponse(identityProvider.retrieveToken(this.session, identity), clientModel);
                }
                return this.corsResponse(this.badRequest("Identity Provider [" + providerId + "] does not support this operation."), clientModel);
            }
            return this.badRequest("Invalid token.");
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage(Response.Status.BAD_GATEWAY, "couldNotObtainTokenMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage(Response.Status.BAD_GATEWAY, "unexpectedErrorRetrievingTokenMessage", e, providerId);
        }
    }

    public Response authenticated(BrokeredIdentityContext context) {
        UserSessionModel userSession;
        StatusResponseType loginResponse;
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        AuthenticationSessionModel authenticationSession = context.getAuthenticationSession();
        String providerId = identityProviderConfig.getAlias();
        if (!identityProviderConfig.isStoreToken()) {
            if (this.isDebugEnabled()) {
                logger.debugf("Token will not be stored for identity provider [%s].", (Object)providerId);
            }
            context.setToken(null);
        }
        if ((loginResponse = (StatusResponseType)context.getContextData().get("SAML_LOGIN_RESPONSE")) != null) {
            Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(this.session);
            while (it.hasNext()) {
                loginResponse = it.next().beforeProcessingLoginResponse(loginResponse, authenticationSession);
            }
        }
        this.session.getContext().setClient(authenticationSession.getClient());
        context.getIdp().preprocessFederatedIdentity(this.session, this.realmModel, context);
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        this.realmModel.getIdentityProviderMappersByAliasStream(context.getIdpConfig().getAlias()).forEach(mapper -> {
            IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
            target.preprocessFederatedIdentity(this.session, this.realmModel, mapper, context);
        });
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
        this.event.event(EventType.IDENTITY_PROVIDER_LOGIN).detail("redirect_uri", authenticationSession.getRedirectUri()).detail("identity_provider", providerId).detail("identity_provider_identity", context.getUsername());
        UserModel federatedUser = this.session.users().getUserByFederatedIdentity(this.realmModel, federatedIdentityModel);
        boolean shouldMigrateId = false;
        if (federatedUser == null && context.getLegacyId() != null) {
            federatedIdentityModel = new FederatedIdentityModel(federatedIdentityModel, context.getLegacyId());
            federatedUser = this.session.users().getUserByFederatedIdentity(this.realmModel, federatedIdentityModel);
            shouldMigrateId = true;
        }
        if (this.shouldPerformAccountLinking(authenticationSession, userSession = new AuthenticationSessionManager(this.session).getUserSession(authenticationSession), providerId)) {
            return this.performAccountLinking(authenticationSession, userSession, context, federatedIdentityModel, federatedUser);
        }
        if (federatedUser == null) {
            logger.debugf("Federated user not found for provider '%s' and broker username '%s'", (Object)providerId, (Object)context.getUsername());
            authenticationSession.setAuthNote("ATTEMPTED_USERNAME", context.getUsername());
            String username = context.getModelUsername();
            if (username == null) {
                username = this.realmModel.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getUsername());
            }
            username = username.trim();
            context.setModelUsername(username);
            SerializedBrokeredIdentityContext ctx0 = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authenticationSession, "BROKERED_CONTEXT");
            if (ctx0 != null) {
                SerializedBrokeredIdentityContext ctx1 = SerializedBrokeredIdentityContext.serialize(context);
                ctx1.saveToAuthenticationSession(authenticationSession, "NESTED_FIRST_BROKER_CONTEXT");
                logger.warnv("Nested first broker flow detected: {0} -> {1}", (Object)ctx0.getIdentityProviderId(), (Object)ctx1.getIdentityProviderId());
                logger.debug((Object)"Resuming last execution");
                URI redirect = new AuthenticationFlowURLHelper(this.session, this.realmModel, (UriInfo)this.session.getContext().getUri()).getLastExecutionUrl(authenticationSession);
                return Response.status((Response.Status)Response.Status.FOUND).location(redirect).build();
            }
            logger.debug((Object)"Redirecting to flow for firstBrokerLogin");
            boolean forwardedPassiveLogin = "true".equals(authenticationSession.getAuthNote("forwarded.passive.login"));
            Map<String, String> extractedAuthNotes = this.extractAuthNotesFromSession(authenticationSession);
            AuthenticationProcessor.resetFlow(authenticationSession, "first-broker-login");
            extractedAuthNotes.forEach((arg_0, arg_1) -> ((AuthenticationSessionModel)authenticationSession).setAuthNote(arg_0, arg_1));
            if (forwardedPassiveLogin) {
                authenticationSession.setAuthNote("forwarded.passive.login", "true");
            }
            SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
            ctx.saveToAuthenticationSession(authenticationSession, "BROKERED_CONTEXT");
            URI redirect = LoginActionsService.firstBrokerLoginProcessor((UriInfo)this.session.getContext().getUri()).queryParam("client_id", new Object[]{authenticationSession.getClient().getClientId()}).queryParam("tab_id", new Object[]{authenticationSession.getTabId()}).build(new Object[]{this.realmModel.getName()});
            return Response.status((int)302).location(redirect).build();
        }
        authenticationSession.setAuthNote("ATTEMPTED_USERNAME", federatedUser.getUsername());
        Response response = this.validateUser(authenticationSession, federatedUser, this.realmModel);
        if (response != null) {
            return response;
        }
        this.updateFederatedIdentity(context, federatedUser);
        if (shouldMigrateId) {
            this.migrateFederatedIdentityId(context, federatedUser);
        }
        authenticationSession.setAuthenticatedUser(federatedUser);
        return this.finishOrRedirectToPostBrokerLogin(authenticationSession, context, false);
    }

    private Map<String, String> extractAuthNotesFromSession(AuthenticationSessionModel authenticationSession) {
        return Stream.of("locale_user_requested", "locale_client_requested").filter(it -> authenticationSession.getAuthNote(it) != null).collect(Collectors.toMap(Function.identity(), arg_0 -> ((AuthenticationSessionModel)authenticationSession).getAuthNote(arg_0)));
    }

    public Response validateUser(AuthenticationSessionModel authSession, UserModel user, RealmModel realm) {
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "accountDisabledMessage", new Object[0]);
        }
        if (realm.isBruteForceProtected() && ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, realm, user)) {
            this.event.error("user_temporarily_disabled");
            return ErrorPage.error(this.session, authSession, Response.Status.BAD_REQUEST, "accountDisabledMessage", new Object[0]);
        }
        return null;
    }

    @GET
    @NoCache
    @Path(value="/after-first-broker-login")
    public Response afterFirstBrokerLogin(@QueryParam(value="session_code") String code, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        AuthenticationSessionModel authSession = this.parseSessionCode(code, clientId, tabId);
        return this.afterFirstBrokerLogin(authSession);
    }

    private Response afterFirstBrokerLogin(AuthenticationSessionModel authSession) {
        try {
            this.event.detail("code_id", authSession.getParentSession().getId()).removeDetail("auth_method");
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, "BROKERED_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, authSession);
            String providerId = context.getIdpConfig().getAlias();
            this.event.detail("identity_provider", providerId);
            this.event.detail("identity_provider_identity", context.getUsername());
            String authProvider = authSession.getAuthNote("FIRST_BROKER_LOGIN_SUCCESS");
            if (authProvider == null || !authProvider.equals(providerId)) {
                throw new IdentityBrokerException("Invalid request. Not found the flag that first-broker-login flow was finished");
            }
            authSession.removeAuthNote("BROKERED_CONTEXT");
            UserModel federatedUser = authSession.getAuthenticatedUser();
            if (federatedUser == null) {
                throw new IdentityBrokerException("Couldn't found authenticated federatedUser in authentication session");
            }
            this.event.user(federatedUser);
            this.event.detail("username", federatedUser.getUsername());
            if (context.getIdpConfig().isAddReadTokenRoleOnCreate()) {
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    throw new IdentityBrokerException("Client 'broker' not available. Maybe realm has not migrated to support the broker token exchange service");
                }
                RoleModel readTokenRole = brokerClient.getRole("read-token");
                federatedUser.grantRole(readTokenRole);
            }
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getUsername(), context.getToken());
            this.session.users().addFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            String isRegisteredNewUser = authSession.getAuthNote("BROKER_REGISTERED_NEW_USER");
            if (Boolean.parseBoolean(isRegisteredNewUser)) {
                logger.debugf("Registered new user '%s' after first login with identity provider '%s'. Identity provider username is '%s' . ", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                context.getIdp().importNewUser(this.session, this.realmModel, federatedUser, context);
                KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
                this.realmModel.getIdentityProviderMappersByAliasStream(providerId).forEach(mapper -> {
                    IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                    target.importNewUser(this.session, this.realmModel, federatedUser, mapper, context);
                });
                if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(federatedUser.getEmail()) && !Boolean.parseBoolean(authSession.getAuthNote("UPDATE_PROFILE_EMAIL_CHANGED"))) {
                    logger.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)federatedUser.getUsername(), (Object)context.getIdpConfig().getAlias());
                    federatedUser.setEmailVerified(true);
                }
                this.event.clone().event(EventType.REGISTER).detail("register_method", "broker").detail("email", federatedUser.getEmail()).success();
            } else {
                logger.debugf("Linked existing keycloak user '%s' with identity provider '%s' . Identity provider username is '%s' .", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                this.event.event(EventType.FEDERATED_IDENTITY_LINK).success();
                this.updateFederatedIdentity(context, federatedUser);
            }
            return this.finishOrRedirectToPostBrokerLogin(authSession, context, true);
        }
        catch (Exception e) {
            return this.redirectToErrorPage(authSession, Response.Status.INTERNAL_SERVER_ERROR, "identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response finishOrRedirectToPostBrokerLogin(AuthenticationSessionModel authSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin) {
        String postBrokerLoginFlowId = context.getIdpConfig().getPostBrokerLoginFlowId();
        if (postBrokerLoginFlowId == null) {
            logger.debugf("Skip redirect to postBrokerLogin flow. PostBrokerLogin flow not set for identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
            return this.afterPostBrokerLoginFlowSuccess(authSession, context, wasFirstBrokerLogin);
        }
        logger.debugf("Redirect to postBrokerLogin flow after authentication with identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
        authSession.getParentSession().setTimestamp(Time.currentTime());
        SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
        ctx.saveToAuthenticationSession(authSession, "PBL_BROKERED_IDENTITY_CONTEXT");
        authSession.setAuthNote("PBL_AFTER_FIRST_BROKER_LOGIN", String.valueOf(wasFirstBrokerLogin));
        URI redirect = LoginActionsService.postBrokerLoginProcessor((UriInfo)this.session.getContext().getUri()).queryParam("client_id", new Object[]{authSession.getClient().getClientId()}).queryParam("tab_id", new Object[]{authSession.getTabId()}).build(new Object[]{this.realmModel.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    @GET
    @NoCache
    @Path(value="/after-post-broker-login")
    public Response afterPostBrokerLoginFlow(@QueryParam(value="session_code") String code, @QueryParam(value="client_id") String clientId, @QueryParam(value="tab_id") String tabId) {
        AuthenticationSessionModel authenticationSession = this.parseSessionCode(code, clientId, tabId);
        try {
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authenticationSession, "PBL_BROKERED_IDENTITY_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession. Note PBL_BROKERED_IDENTITY_CONTEXT was null");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, authenticationSession);
            String wasFirstBrokerLoginNote = authenticationSession.getAuthNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            boolean wasFirstBrokerLogin = Boolean.parseBoolean(wasFirstBrokerLoginNote);
            String authStateNoteKey = "PBL_AUTH_STATE." + context.getIdpConfig().getAlias();
            String authState = authenticationSession.getAuthNote(authStateNoteKey);
            if (!Boolean.parseBoolean(authState)) {
                throw new IdentityBrokerException("Invalid request. Not found the flag that post-broker-login flow was finished");
            }
            authenticationSession.removeAuthNote("PBL_BROKERED_IDENTITY_CONTEXT");
            authenticationSession.removeAuthNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            return this.afterPostBrokerLoginFlowSuccess(authenticationSession, context, wasFirstBrokerLogin);
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage(authenticationSession, Response.Status.INTERNAL_SERVER_ERROR, "identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response afterPostBrokerLoginFlowSuccess(AuthenticationSessionModel authSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin) {
        boolean firstBrokerLoginInProgress;
        String providerId = context.getIdpConfig().getAlias();
        UserModel federatedUser = authSession.getAuthenticatedUser();
        if (wasFirstBrokerLogin) {
            return this.finishBrokerAuthentication(context, federatedUser, authSession, providerId);
        }
        boolean bl = firstBrokerLoginInProgress = authSession.getAuthNote("BROKERED_CONTEXT") != null;
        if (firstBrokerLoginInProgress) {
            logger.debugf("Reauthenticated with broker '%s' when linking user '%s' with other broker", (Object)context.getIdpConfig().getAlias(), (Object)federatedUser.getUsername());
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession(authSession, "BROKERED_CONTEXT");
            authSession.setAuthNote("FIRST_BROKER_LOGIN_SUCCESS", serializedCtx.getIdentityProviderId());
            return this.afterFirstBrokerLogin(authSession);
        }
        return this.finishBrokerAuthentication(context, federatedUser, authSession, providerId);
    }

    private Response finishBrokerAuthentication(BrokeredIdentityContext context, UserModel federatedUser, AuthenticationSessionModel authSession, String providerId) {
        authSession.setAuthNote("broker.session.id", context.getBrokerSessionId());
        authSession.setAuthNote("broker.user.id", context.getBrokerUserId());
        this.event.user(federatedUser);
        context.getIdp().authenticationFinished(authSession, context);
        authSession.setUserSessionNote("identity_provider", providerId);
        authSession.setUserSessionNote("identity_provider_identity", context.getUsername());
        this.event.detail("identity_provider", providerId).detail("identity_provider_identity", context.getUsername());
        if (this.isDebugEnabled()) {
            logger.debugf("Performing local authentication for user [%s].", (Object)federatedUser);
        }
        AuthenticationManager.setClientScopesInSession(authSession);
        String nextRequiredAction = AuthenticationManager.nextRequiredAction(this.session, authSession, this.request, this.event);
        if (nextRequiredAction != null) {
            if ("true".equals(authSession.getAuthNote("forwarded.passive.login"))) {
                logger.errorf("Required action %s found. Auth requests using prompt=none are incompatible with required actions", (Object)nextRequiredAction);
                return this.checkPassiveLoginError(authSession, "interaction_required");
            }
            return AuthenticationManager.redirectToRequiredActions(this.session, this.realmModel, authSession, (UriInfo)this.session.getContext().getUri(), nextRequiredAction);
        }
        this.event.detail("code_id", authSession.getParentSession().getId());
        return AuthenticationManager.finishedRequiredActions(this.session, authSession, null, this.clientConnection, this.request, (UriInfo)this.session.getContext().getUri(), this.event);
    }

    public Response cancelled(IdentityProviderModel idpConfig) {
        AuthenticationSessionModel authSession = this.session.getContext().getAuthenticationSession();
        String idpDisplayName = KeycloakModelUtils.getIdentityProviderDisplayName((KeycloakSession)this.session, (IdentityProviderModel)idpConfig);
        Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(authSession, "access-denied-when-idp-auth", idpDisplayName);
        if (accountManagementFailedLinking != null) {
            return accountManagementFailedLinking;
        }
        return this.browserAuthentication(authSession, "access-denied-when-idp-auth", idpDisplayName);
    }

    public Response error(String message) {
        AuthenticationSessionModel authSession = this.session.getContext().getAuthenticationSession();
        Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(authSession, message, new Object[0]);
        if (accountManagementFailedLinking != null) {
            return accountManagementFailedLinking;
        }
        Response passiveLoginErrorReturned = this.checkPassiveLoginError(authSession, message);
        if (passiveLoginErrorReturned != null) {
            return passiveLoginErrorReturned;
        }
        return this.browserAuthentication(authSession, message, new Object[0]);
    }

    private boolean shouldPerformAccountLinking(AuthenticationSessionModel authSession, UserSessionModel userSession, String providerId) {
        boolean linkingValid;
        String noteFromSession = authSession.getAuthNote(LINKING_IDENTITY_PROVIDER);
        if (noteFromSession == null) {
            return false;
        }
        if (userSession == null) {
            linkingValid = false;
        } else {
            String expectedNote = userSession.getId() + authSession.getClient().getClientId() + providerId;
            linkingValid = expectedNote.equals(noteFromSession);
        }
        if (linkingValid) {
            authSession.removeAuthNote(LINKING_IDENTITY_PROVIDER);
            return true;
        }
        throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "brokerLinkingSessionExpired", new Object[0]);
    }

    private Response performAccountLinking(AuthenticationSessionModel authSession, UserSessionModel userSession, BrokeredIdentityContext context, FederatedIdentityModel newModel, UserModel federatedUser) {
        logger.debugf("Will try to link identity provider [%s] to user [%s]", (Object)context.getIdpConfig().getAlias(), (Object)userSession.getUser().getUsername());
        this.event.event(EventType.FEDERATED_IDENTITY_LINK);
        UserModel authenticatedUser = userSession.getUser();
        authSession.setAuthenticatedUser(authenticatedUser);
        if (federatedUser != null && !authenticatedUser.getId().equals(federatedUser.getId())) {
            return this.redirectToErrorWhenLinkingFailed(authSession, "identityProviderAlreadyLinkedMessage", context.getIdpConfig().getAlias());
        }
        if (!authenticatedUser.hasRole(this.realmModel.getClientByClientId("account").getRole("manage-account"))) {
            return this.redirectToErrorPage(authSession, Response.Status.FORBIDDEN, "insufficientPermissionMessage", new Object[0]);
        }
        if (!authenticatedUser.isEnabled()) {
            return this.redirectToErrorWhenLinkingFailed(authSession, "accountDisabledMessage", new Object[0]);
        }
        if (federatedUser != null) {
            if (context.getIdpConfig().isStoreToken()) {
                FederatedIdentityModel oldModel = this.session.users().getFederatedIdentity(this.realmModel, federatedUser, context.getIdpConfig().getAlias());
                if (!ObjectUtil.isEqualOrBothNull((Object)context.getToken(), (Object)oldModel.getToken())) {
                    this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, newModel);
                    if (this.isDebugEnabled()) {
                        logger.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
                    }
                }
            }
        } else {
            this.session.users().addFederatedIdentity(this.realmModel, authenticatedUser, newModel);
            federatedUser = authenticatedUser;
        }
        this.updateFederatedIdentity(context, federatedUser);
        context.getIdp().authenticationFinished(authSession, context);
        AuthenticationManager.setClientScopesInSession(authSession);
        TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        if (this.isDebugEnabled()) {
            logger.debugf("Linking account [%s] from identity provider [%s] to user [%s].", (Object)newModel, (Object)context.getIdpConfig().getAlias(), (Object)authenticatedUser);
        }
        this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername()).detail("identity_provider", newModel.getIdentityProvider()).detail("identity_provider_identity", newModel.getUserName()).success();
        if (userSession.getNote("identity_provider") == null) {
            userSession.setNote("identity_provider", context.getIdpConfig().getAlias());
            userSession.setNote("identity_provider_identity", context.getUsername());
        }
        return Response.status((int)302).location(UriBuilder.fromUri((String)authSession.getRedirectUri()).build(new Object[0])).build();
    }

    private Response redirectToErrorWhenLinkingFailed(AuthenticationSessionModel authSession, String message, Object ... parameters) {
        if (authSession.getClient() != null && authSession.getClient().getClientId().equals("account")) {
            return this.redirectToAccountErrorPage(authSession, message, parameters);
        }
        return this.redirectToErrorPage(authSession, Response.Status.BAD_REQUEST, message, parameters);
    }

    private void updateFederatedIdentity(BrokeredIdentityContext context, UserModel federatedUser) {
        FederatedIdentityModel federatedIdentityModel = this.session.users().getFederatedIdentity(this.realmModel, federatedUser, context.getIdpConfig().getAlias());
        if (context.getIdpConfig().getSyncMode() == IdentityProviderSyncMode.FORCE) {
            this.setBasicUserAttributes(context, federatedUser);
            if (!Objects.equals(context.getUsername(), federatedIdentityModel.getUserName())) {
                federatedIdentityModel = new FederatedIdentityModel(federatedIdentityModel.getIdentityProvider(), federatedIdentityModel.getUserId(), context.getUsername(), federatedIdentityModel.getToken());
                this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            }
        }
        this.updateToken(context, federatedUser, federatedIdentityModel);
        context.getIdp().updateBrokeredUser(this.session, this.realmModel, federatedUser, context);
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        this.realmModel.getIdentityProviderMappersByAliasStream(context.getIdpConfig().getAlias()).forEach(mapper -> {
            IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
            IdentityProviderMapperSyncModeDelegate.delegateUpdateBrokeredUser((KeycloakSession)this.session, (RealmModel)this.realmModel, (UserModel)federatedUser, (IdentityProviderMapperModel)mapper, (BrokeredIdentityContext)context, (IdentityProviderMapper)target);
        });
    }

    private void setBasicUserAttributes(BrokeredIdentityContext context, UserModel federatedUser) {
        this.setDiffAttrToConsumer(federatedUser.getEmail(), context.getEmail(), email -> this.setEmail(context, federatedUser, (String)email));
        this.setDiffAttrToConsumer(federatedUser.getFirstName(), context.getFirstName(), arg_0 -> ((UserModel)federatedUser).setFirstName(arg_0));
        this.setDiffAttrToConsumer(federatedUser.getLastName(), context.getLastName(), arg_0 -> ((UserModel)federatedUser).setLastName(arg_0));
    }

    private void setDiffAttrToConsumer(String actualValue, String newValue, Consumer<String> consumer) {
        String actualValueNotNull = Optional.ofNullable(actualValue).orElse("");
        if (newValue != null && !newValue.equals(actualValueNotNull)) {
            consumer.accept(newValue);
        }
    }

    private void setEmail(BrokeredIdentityContext context, UserModel federatedUser, String newEmail) {
        federatedUser.setEmail(newEmail);
        if (context.getIdpConfig().isTrustEmail() && !Boolean.parseBoolean(context.getAuthenticationSession().getAuthNote("UPDATE_PROFILE_EMAIL_CHANGED"))) {
            logger.tracef("Email verified automatically after updating user '%s' through Identity provider '%s' ", (Object)federatedUser.getUsername(), (Object)context.getIdpConfig().getAlias());
            federatedUser.setEmailVerified(true);
        } else {
            logger.tracef("Email verified reset to false after updating user '%s' through Identity provider '%s' ", (Object)federatedUser.getUsername(), (Object)context.getIdpConfig().getAlias());
            federatedUser.setEmailVerified(false);
        }
    }

    private void migrateFederatedIdentityId(BrokeredIdentityContext context, UserModel federatedUser) {
        FederatedIdentityModel identityModel = this.session.users().getFederatedIdentity(this.realmModel, federatedUser, context.getIdpConfig().getAlias());
        FederatedIdentityModel migratedIdentityModel = new FederatedIdentityModel(identityModel, context.getId());
        this.session.users().removeFederatedIdentity(this.realmModel, federatedUser, identityModel.getIdentityProvider());
        this.session.users().addFederatedIdentity(this.realmModel, federatedUser, migratedIdentityModel);
        logger.debugf("Federated user ID was migrated from %s to %s", (Object)identityModel.getUserId(), (Object)migratedIdentityModel.getUserId());
    }

    private void updateToken(BrokeredIdentityContext context, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        if (context.getIdpConfig().isStoreToken() && !ObjectUtil.isEqualOrBothNull((Object)context.getToken(), (Object)federatedIdentityModel.getToken())) {
            federatedIdentityModel.setToken(context.getToken());
            this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            if (this.isDebugEnabled()) {
                logger.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
            }
        }
    }

    public AuthenticationSessionModel getAndVerifyAuthenticationSession(String encodedCode) {
        IdentityBrokerState state = IdentityBrokerState.encoded((String)encodedCode, (RealmModel)this.realmModel);
        String code = state.getDecodedState();
        String clientId = state.getClientId();
        String tabId = state.getTabId();
        return this.parseSessionCode(code, clientId, tabId);
    }

    private AuthenticationSessionModel parseSessionCode(String code, String clientId, String tabId) {
        if (code == null || clientId == null || tabId == null) {
            logger.debugf("Invalid request. Authorization code, clientId or tabId was null. Code=%s, clientId=%s, tabID=%s", (Object)code, (Object)clientId, (Object)tabId);
            Response staleCodeError = this.redirectToErrorPage(Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            throw new WebApplicationException(staleCodeError);
        }
        SessionCodeChecks checks = new SessionCodeChecks(this.realmModel, (UriInfo)this.session.getContext().getUri(), this.request, this.clientConnection, this.session, this.event, null, code, null, clientId, tabId, "authenticate");
        checks.initialVerify();
        if (!checks.verifyActiveAndValidAction(CommonClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            AuthenticationSessionModel authSession = checks.getAuthenticationSession();
            if (authSession != null) {
                Response accountManagementFailedLinking = this.checkAccountManagementFailedLinking(authSession, "staleCodeAccountMessage", new Object[0]);
                if (accountManagementFailedLinking != null) {
                    throw new WebApplicationException(accountManagementFailedLinking);
                }
                Response errorResponse = checks.getResponse();
                errorResponse = BrowserHistoryHelper.getInstance().saveResponseAndRedirect(this.session, authSession, errorResponse, true, this.request);
                throw new WebApplicationException(errorResponse);
            }
            throw new WebApplicationException(checks.getResponse());
        }
        if (this.isDebugEnabled()) {
            logger.debugf("Authorization code is valid.", new Object[0]);
        }
        return checks.getClientCode().getClientSession();
    }

    private Response checkAccountManagementFailedLinking(AuthenticationSessionModel authSession, String error, Object ... parameters) {
        UserSessionModel userSession = new AuthenticationSessionManager(this.session).getUserSession(authSession);
        if (userSession != null && authSession.getClient() != null && authSession.getClient().getClientId().equals("account")) {
            this.event.event(EventType.FEDERATED_IDENTITY_LINK);
            UserModel user = userSession.getUser();
            this.event.user(user);
            this.event.detail("username", user.getUsername());
            return this.redirectToAccountErrorPage(authSession, error, parameters);
        }
        return null;
    }

    private Response checkPassiveLoginError(AuthenticationSessionModel authSession, String message) {
        LoginProtocol.Error error;
        Object object = "login_required".equals(message) ? LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED : (error = "interaction_required".equals(message) ? LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED : null);
        if (error != null) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, authSession.getProtocol());
            protocol.setRealm(this.realmModel).setHttpHeaders(this.headers).setUriInfo((UriInfo)this.session.getContext().getUri()).setEventBuilder(this.event);
            return protocol.sendError(authSession, error);
        }
        return null;
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode<AuthenticationSessionModel> clientSessionCode) {
        AuthenticationSessionModel authSession = null;
        IdentityBrokerState encodedState = null;
        if (clientSessionCode != null) {
            authSession = clientSessionCode.getClientSession();
            String relayState = clientSessionCode.getOrGenerateCode();
            encodedState = IdentityBrokerState.decoded((String)relayState, (String)authSession.getClient().getId(), (String)authSession.getClient().getClientId(), (String)authSession.getTabId());
        }
        return new AuthenticationRequest(this.session, this.realmModel, authSession, this.request, (UriInfo)this.session.getContext().getUri(), encodedState, this.getRedirectUri(providerId));
    }

    private String getRedirectUri(String providerId) {
        return Urls.identityProviderAuthnResponse(this.session.getContext().getUri().getBaseUri(), providerId, this.realmModel.getName()).toString();
    }

    private Response redirectToErrorPage(AuthenticationSessionModel authSession, Response.Status status, String message, Object ... parameters) {
        return this.redirectToErrorPage(authSession, status, message, null, parameters);
    }

    private Response redirectToErrorPage(Response.Status status, String message, Object ... parameters) {
        return this.redirectToErrorPage(null, status, message, null, parameters);
    }

    private Response redirectToErrorPage(Response.Status status, String message, Throwable throwable, Object ... parameters) {
        return this.redirectToErrorPage(null, status, message, throwable, parameters);
    }

    private Response redirectToErrorPage(AuthenticationSessionModel authSession, Response.Status status, String message, Throwable throwable, Object ... parameters) {
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message, throwable);
        if (throwable != null && throwable instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)throwable;
            return webEx.getResponse();
        }
        throw new ErrorPageException(this.session, authSession, status, message, parameters);
    }

    private Response redirectToAccountErrorPage(AuthenticationSessionModel authSession, String message, Object ... parameters) {
        this.fireErrorEvent(message);
        FormMessage errorMessage = new FormMessage(message, parameters);
        try {
            String serializedError = JsonSerialization.writeValueAsString((Object)errorMessage);
            authSession.setAuthNote("ACCOUNT_MGMT_FORWARDED_ERROR", serializedError);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        URI accountServiceUri = UriBuilder.fromUri((String)authSession.getRedirectUri()).queryParam("tab_id", new Object[]{authSession.getTabId()}).build(new Object[0]);
        return Response.status((int)302).location(accountServiceUri).build();
    }

    protected Response browserAuthentication(AuthenticationSessionModel authSession, String errorMessage, Object ... parameters) {
        this.event.event(EventType.LOGIN);
        AuthenticationFlowModel flow = AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowPath("authenticate").setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realmModel).setSession(this.session).setUriInfo((UriInfo)this.session.getContext().getUri()).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage, parameters));
        }
        try {
            CacheControlUtil.noBackButtonCacheControlHeader(this.session);
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    private Response badRequest(String message) {
        this.fireErrorEvent(message);
        throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    private Response forbidden(String message) {
        this.fireErrorEvent(message);
        throw ErrorResponse.error(message, Response.Status.FORBIDDEN);
    }

    private Response notFound(String message) {
        this.fireErrorEvent(message);
        throw ErrorResponse.error(message, Response.Status.NOT_FOUND);
    }

    public static IdentityProvider getIdentityProvider(KeycloakSession session, RealmModel realm, String alias) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProviderByAlias(alias);
        if (identityProviderModel != null) {
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(session, identityProviderModel);
            if (providerFactory == null) {
                throw new IdentityBrokerException("Could not find factory for identity provider [" + alias + "].");
            }
            return providerFactory.create(session, identityProviderModel);
        }
        throw new IdentityBrokerException("Identity Provider [" + alias + "] not found.");
    }

    public static IdentityProviderFactory getIdentityProviderFactory(KeycloakSession session, IdentityProviderModel model) {
        return Stream.concat(session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class), session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class)).filter(providerFactory -> Objects.equals(providerFactory.getId(), model.getProviderId())).map(IdentityProviderFactory.class::cast).findFirst().orElse(null);
    }

    private IdentityProviderModel getIdentityProviderConfig(String providerId) {
        IdentityProviderModel model = this.realmModel.getIdentityProviderByAlias(providerId);
        if (model == null) {
            throw new IdentityBrokerException("Configuration for identity provider [" + providerId + "] not found.");
        }
        return model;
    }

    private Response corsResponse(Response response, ClientModel clientModel) {
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(this.session, clientModel).build();
    }

    private void fireErrorEvent(String message, Throwable throwable) {
        if (!this.event.getEvent().getType().toString().endsWith("_ERROR")) {
            boolean newTransaction = !this.session.getTransactionManager().isActive();
            try {
                if (newTransaction) {
                    this.session.getTransactionManager().begin();
                }
                this.event.error(message);
                if (newTransaction) {
                    this.session.getTransactionManager().commit();
                }
            }
            catch (Exception e) {
                ServicesLogger.LOGGER.couldNotFireEvent(e);
                this.rollback();
            }
        }
        if (throwable != null) {
            logger.error((Object)message, throwable);
        } else {
            logger.error((Object)message);
        }
    }

    private void fireErrorEvent(String message) {
        this.fireErrorEvent(message, null);
    }

    private boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    private void rollback() {
        if (this.session.getTransactionManager().isActive()) {
            this.session.getTransactionManager().rollback();
        }
    }
}

