/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.security.Key;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.PublishedRealmRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.Cors;

public class PublicRealmResource {
    protected static final Logger logger = Logger.getLogger(PublicRealmResource.class);
    protected final HttpRequest request;
    protected final HttpResponse response;
    protected final KeycloakSession session;
    protected final RealmModel realm;

    public PublicRealmResource(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.request = session.getContext().getHttpRequest();
        this.response = session.getContext().getHttpResponse();
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public PublishedRealmRepresentation getRealm() {
        Cors.add(this.request).allowedOrigins("*").auth().build(this.response);
        return PublicRealmResource.realmRep(this.session, this.realm, (UriInfo)this.session.getContext().getUri());
    }

    public static PublishedRealmRepresentation realmRep(KeycloakSession session, RealmModel realm, UriInfo uriInfo) {
        PublishedRealmRepresentation rep = new PublishedRealmRepresentation();
        rep.setRealm(realm.getName());
        rep.setTokenServiceUrl(OIDCLoginProtocolService.tokenServiceBaseUrl(uriInfo).build(new Object[]{realm.getName()}).toString());
        rep.setAccountServiceUrl(Urls.accountBase(uriInfo.getBaseUri()).build(new Object[]{realm.getName()}).toString());
        rep.setPublicKeyPem(PemUtils.encodeKey((Key)session.keys().getActiveRsaKey(realm).getPublicKey()));
        rep.setNotBefore(realm.getNotBefore());
        return rep;
    }
}

