/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.common.ClientModelIdentity;
import org.keycloak.authorization.common.DefaultEvaluationContext;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.ForbiddenException;
import org.keycloak.services.resources.admin.permissions.ClientPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.ClientPermissionManagement;
import org.keycloak.services.resources.admin.permissions.Helper;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.storage.StorageId;

class ClientPermissions
implements ClientPermissionEvaluator,
ClientPermissionManagement {
    private static final Logger logger = Logger.getLogger(ClientPermissions.class);
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected final AuthorizationProvider authz;
    protected final MgmtPermissions root;
    protected final ResourceStore resourceStore;
    private static final String RESOURCE_NAME_PREFIX = "client.resource.";

    public ClientPermissions(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        this.session = session;
        this.realm = realm;
        this.authz = authz;
        this.root = root;
        this.resourceStore = authz != null ? authz.getStoreFactory().getResourceStore() : null;
    }

    private String getResourceName(ClientModel client) {
        return RESOURCE_NAME_PREFIX + client.getId();
    }

    private String getManagePermissionName(ClientModel client) {
        return "manage.permission.client." + client.getId();
    }

    private String getConfigurePermissionName(ClientModel client) {
        return "configure.permission.client." + client.getId();
    }

    private String getViewPermissionName(ClientModel client) {
        return "view.permission.client." + client.getId();
    }

    private String getMapRolesPermissionName(ClientModel client) {
        return "map-roles.permission.client." + client.getId();
    }

    private String getMapRolesClientScopePermissionName(ClientModel client) {
        return "map-roles-client-scope.permission.client." + client.getId();
    }

    private String getMapRolesCompositePermissionName(ClientModel client) {
        return "map-roles-composite.permission.client." + client.getId();
    }

    private String getExchangeToPermissionName(ClientModel client) {
        return "token-exchange.permission.client." + client.getId();
    }

    private void initialize(ClientModel client) {
        Scope mapRoleScope;
        Scope viewScope;
        ResourceServer server = this.root.findOrCreateResourceServer(client);
        if (server == null) {
            return;
        }
        Scope manageScope = this.manageScope(server);
        if (manageScope == null) {
            manageScope = this.authz.getStoreFactory().getScopeStore().create(server, "manage");
        }
        if ((viewScope = this.viewScope(server)) == null) {
            viewScope = this.authz.getStoreFactory().getScopeStore().create(server, "view");
        }
        if ((mapRoleScope = this.mapRolesScope(server)) == null) {
            mapRoleScope = this.authz.getStoreFactory().getScopeStore().create(server, "map-roles");
        }
        Scope mapRoleClientScope = this.root.initializeScope("map-roles-client-scope", server);
        Scope mapRoleCompositeScope = this.root.initializeScope("map-roles-composite", server);
        Scope configureScope = this.root.initializeScope("configure", server);
        Scope exchangeToScope = this.root.initializeScope("token-exchange", server);
        String resourceName = this.getResourceName(client);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, resourceName);
        if (resource == null) {
            resource = this.authz.getStoreFactory().getResourceStore().create(server, resourceName, server.getClientId());
            resource.setType("Client");
            HashSet<Scope> scopeset = new HashSet<Scope>();
            scopeset.add(configureScope);
            scopeset.add(manageScope);
            scopeset.add(viewScope);
            scopeset.add(mapRoleScope);
            scopeset.add(mapRoleClientScope);
            scopeset.add(mapRoleCompositeScope);
            scopeset.add(exchangeToScope);
            resource.updateScopes(scopeset);
        }
        String managePermissionName = this.getManagePermissionName(client);
        Policy managePermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, managePermissionName);
        if (managePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, managePermissionName, resource, manageScope);
        }
        String configurePermissionName = this.getConfigurePermissionName(client);
        Policy configurePermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, configurePermissionName);
        if (configurePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, configurePermissionName, resource, configureScope);
        }
        String viewPermissionName = this.getViewPermissionName(client);
        Policy viewPermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, viewPermissionName);
        if (viewPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, viewPermissionName, resource, viewScope);
        }
        String mapRolePermissionName = this.getMapRolesPermissionName(client);
        Policy mapRolePermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, mapRolePermissionName);
        if (mapRolePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRolePermissionName, resource, mapRoleScope);
        }
        String mapRoleClientScopePermissionName = this.getMapRolesClientScopePermissionName(client);
        Policy mapRoleClientScopePermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, mapRoleClientScopePermissionName);
        if (mapRoleClientScopePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRoleClientScopePermissionName, resource, mapRoleClientScope);
        }
        String mapRoleCompositePermissionName = this.getMapRolesCompositePermissionName(client);
        Policy mapRoleCompositePermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, mapRoleCompositePermissionName);
        if (mapRoleCompositePermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, mapRoleCompositePermissionName, resource, mapRoleCompositeScope);
        }
        String exchangeToPermissionName = this.getExchangeToPermissionName(client);
        Policy exchangeToPermission = this.authz.getStoreFactory().getPolicyStore().findByName(server, exchangeToPermissionName);
        if (exchangeToPermission == null) {
            Helper.addEmptyScopePermission(this.authz, server, exchangeToPermissionName, resource, exchangeToScope);
        }
    }

    private void deletePolicy(String name, ResourceServer server) {
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, name);
        if (policy != null) {
            this.authz.getStoreFactory().getPolicyStore().delete(server.getRealm(), policy.getId());
        }
    }

    private void deletePermissions(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return;
        }
        this.deletePolicy(this.getManagePermissionName(client), server);
        this.deletePolicy(this.getViewPermissionName(client), server);
        this.deletePolicy(this.getMapRolesPermissionName(client), server);
        this.deletePolicy(this.getMapRolesClientScopePermissionName(client), server);
        this.deletePolicy(this.getMapRolesCompositePermissionName(client), server);
        this.deletePolicy(this.getConfigurePermissionName(client), server);
        this.deletePolicy(this.getExchangeToPermissionName(client), server);
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource != null) {
            this.authz.getStoreFactory().getResourceStore().delete(server.getRealm(), resource.getId());
        }
    }

    @Override
    public boolean isPermissionsEnabled(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        return this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client)) != null;
    }

    @Override
    public void setPermissionsEnabled(ClientModel client, boolean enable) {
        if (enable) {
            this.initialize(client);
        } else {
            this.deletePermissions(client);
        }
    }

    private Scope manageScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "manage");
    }

    private Scope exchangeToScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "token-exchange");
    }

    private Scope configureScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "configure");
    }

    private Scope viewScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "view");
    }

    private Scope mapRolesScope(ResourceServer server) {
        return this.authz.getStoreFactory().getScopeStore().findByName(server, "map-roles");
    }

    @Override
    public boolean canList() {
        return this.canView() || this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS, AdminRoles.QUERY_USERS);
    }

    public boolean canList(ClientModel clientModel) {
        return this.canView(clientModel) || this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS);
    }

    @Override
    public void requireList() {
        if (!this.canList()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canListClientScopes() {
        return this.canView() || this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS);
    }

    @Override
    public void requireListClientScopes() {
        if (!this.canListClientScopes()) {
            throw new ForbiddenException();
        }
    }

    public boolean canManageClientsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS);
    }

    public boolean canViewClientDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_CLIENTS, AdminRoles.VIEW_CLIENTS);
    }

    @Override
    public boolean canManage() {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManage() {
        if (!this.canManage()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView() {
        return this.canManageClientsDefault() || this.canViewClientDefault();
    }

    @Override
    public void requireView() {
        if (!this.canView()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public Resource resource(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return null;
        }
        return resource;
    }

    @Override
    public Map<String, String> getPermissions(ClientModel client) {
        if (this.authz == null) {
            return null;
        }
        this.initialize(client);
        LinkedHashMap<String, String> scopes = new LinkedHashMap<String, String>();
        scopes.put("view", this.viewPermission(client).getId());
        scopes.put("manage", this.managePermission(client).getId());
        scopes.put("configure", this.configurePermission(client).getId());
        scopes.put("map-roles", this.mapRolesPermission(client).getId());
        scopes.put("map-roles-client-scope", this.mapRolesClientScopePermission(client).getId());
        scopes.put("map-roles-composite", this.mapRolesCompositePermission(client).getId());
        scopes.put("token-exchange", this.exchangeToPermission(client).getId());
        return scopes;
    }

    @Override
    public boolean canExchangeTo(final ClientModel authorizedClient, ClientModel to) {
        ResourceServer server = this.resourceServer(to);
        if (server == null) {
            logger.debug((Object)"No resource server set up for target client");
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(to));
        if (resource == null) {
            logger.debug((Object)"No resource object set up for target client");
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getExchangeToPermissionName(to));
        if (policy == null) {
            logger.debug((Object)"No permission object set up for target client");
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            logger.debug((Object)"No policies set up for permission on target client");
            return false;
        }
        Scope scope = this.exchangeToScope(server);
        if (scope == null) {
            logger.debug((Object)"token-exchange not initialized");
            return false;
        }
        ClientModelIdentity identity = new ClientModelIdentity(this.session, authorizedClient);
        DefaultEvaluationContext context = new DefaultEvaluationContext(identity, this.session){

            @Override
            public Map<String, Collection<String>> getBaseAttributes() {
                Map<String, Collection<String>> attributes = super.getBaseAttributes();
                attributes.put("kc.client.id", Arrays.asList(authorizedClient.getClientId()));
                return attributes;
            }
        };
        return this.root.evaluatePermission(resource, server, context, scope);
    }

    @Override
    public boolean canManage(ClientModel client) {
        if (this.canManageClientsDefault()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getManagePermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.manageScope(server);
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public boolean canConfigure(ClientModel client) {
        if (this.canManage(client)) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getConfigurePermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.configureScope(server);
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public void requireConfigure(ClientModel client) {
        if (!this.canConfigure(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManage(ClientModel client) {
        if (!this.canManage(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(ClientModel client) {
        return this.hasView(client) || this.canConfigure(client);
    }

    private boolean hasView(ClientModel client) {
        if (this.canView()) {
            return true;
        }
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getViewPermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.viewScope(server);
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public void requireView(ClientModel client) {
        if (!this.canView(client)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewClientScopes() {
        return this.canView();
    }

    @Override
    public boolean canManageClientScopes() {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManageClientScopes() {
        if (!this.canManageClientScopes()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewClientScopes() {
        if (!this.canViewClientScopes()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManage(ClientScopeModel clientScope) {
        return this.canManageClientsDefault();
    }

    @Override
    public void requireManage(ClientScopeModel clientScope) {
        if (!this.canManage(clientScope)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canView(ClientScopeModel clientScope) {
        return this.canViewClientDefault();
    }

    @Override
    public void requireView(ClientScopeModel clientScope) {
        if (!this.canView(clientScope)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canMapRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesPermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.mapRolesScope(server);
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public Policy exchangeToPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getExchangeToPermissionName(client));
    }

    @Override
    public Policy mapRolesPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesPermissionName(client));
    }

    @Override
    public Policy mapRolesClientScopePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesClientScopePermissionName(client));
    }

    @Override
    public Policy mapRolesCompositePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesCompositePermissionName(client));
    }

    @Override
    public Policy managePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getManagePermissionName(client));
    }

    @Override
    public Policy configurePermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getConfigurePermissionName(client));
    }

    @Override
    public Policy viewPermission(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return null;
        }
        return this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getViewPermissionName(client));
    }

    @Override
    public ResourceServer resourceServer(ClientModel client) {
        return this.root.resourceServer(client);
    }

    @Override
    public boolean canMapCompositeRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesCompositePermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(server, "map-roles-composite");
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public boolean canMapClientScopeRoles(ClientModel client) {
        ResourceServer server = this.resourceServer(client);
        if (server == null) {
            return false;
        }
        Resource resource = this.authz.getStoreFactory().getResourceStore().findByName(server, this.getResourceName(client));
        if (resource == null) {
            return false;
        }
        Policy policy = this.authz.getStoreFactory().getPolicyStore().findByName(server, this.getMapRolesClientScopePermissionName(client));
        if (policy == null) {
            return false;
        }
        Set associatedPolicies = policy.getAssociatedPolicies();
        if (associatedPolicies == null || associatedPolicies.isEmpty()) {
            return false;
        }
        Scope scope = this.authz.getStoreFactory().getScopeStore().findByName(server, "map-roles-client-scope");
        return this.root.evaluatePermission(resource, server, scope);
    }

    @Override
    public Map<String, Boolean> getAccess(ClientModel client) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("view", this.canView(client));
        map.put("manage", StorageId.isLocalStorage((ClientModel)client) && this.canManage(client));
        map.put("configure", StorageId.isLocalStorage((ClientModel)client) && this.canConfigure(client));
        return map;
    }

    @Override
    public Set<String> getClientsWithPermission(String scope) {
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.resourceStore.findByType(server, "Client", resource -> {
            if (this.hasPermission((Resource)resource, scope)) {
                granted.add(resource.getName().substring(RESOURCE_NAME_PREFIX.length()));
            }
        });
        return granted;
    }

    private boolean hasPermission(Resource resource, String scope) {
        ResourceServer server = this.root.realmResourceServer();
        Collection<Permission> permissions = this.root.evaluatePermission(new ResourcePermission(resource, (Collection)resource.getScopes(), server), server);
        for (Permission permission : permissions) {
            for (String s : permission.getScopes()) {
                if (!scope.equals(s)) continue;
                return true;
            }
        }
        return false;
    }
}

