/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.SystemEnvProperties;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.util.JsonSerialization;

public abstract class JsonConfigProviderFactory
implements ConfigProviderFactory {
    private static final Logger LOG = Logger.getLogger(JsonConfigProviderFactory.class);

    @Override
    public Optional<Config.ConfigProvider> create() {
        JsonNode node = null;
        try {
            URL resource;
            File f;
            String configDir = System.getProperty("jboss.server.config.dir");
            if (configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                ServicesLogger.LOGGER.loadingFrom(f.getAbsolutePath());
                node = JsonSerialization.mapper.readTree(f);
            }
            if (node == null && (resource = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json")) != null) {
                ServicesLogger.LOGGER.loadingFrom(resource);
                node = JsonSerialization.mapper.readTree(resource);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to load JSON config", (Throwable)e);
        }
        return this.createJsonProvider(node);
    }

    protected Optional<Config.ConfigProvider> createJsonProvider(JsonNode node) {
        return Optional.ofNullable(node).map(n -> new JsonConfigProvider((JsonNode)n, this.getProperties()));
    }

    protected Properties getProperties() {
        return new SystemEnvProperties();
    }
}

