/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.net.URI;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.account.DeviceRepresentation;

public class SecureContextResolver {
    private static final Pattern LOCALHOST_IPV4 = Pattern.compile("127.\\d{1,3}.\\d{1,3}.\\d{1,3}");
    private static final Pattern LOCALHOST_IPV6 = Pattern.compile("\\[(0{0,4}:){1,7}0{0,3}1\\]");

    public static boolean isSecureContext(KeycloakSession session) {
        URI uri = session.getContext().getUri().getRequestUri();
        Supplier<DeviceRepresentation> deviceRepresentationSupplier = () -> {
            DeviceRepresentationProvider deviceRepresentationProvider = (DeviceRepresentationProvider)session.getProvider(DeviceRepresentationProvider.class);
            return deviceRepresentationProvider.deviceRepresentation();
        };
        return SecureContextResolver.isSecureContext(uri, deviceRepresentationSupplier);
    }

    static boolean isSecureContext(URI uri, Supplier<DeviceRepresentation> deviceRepresentationSupplier) {
        String browser;
        if (uri.getScheme().equals("https")) {
            return true;
        }
        DeviceRepresentation deviceRepresentation = deviceRepresentationSupplier.get();
        String string = browser = deviceRepresentation != null ? deviceRepresentation.getBrowser() : null;
        if (browser != null && browser.toLowerCase().contains("safari")) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (SecureContextResolver.isLocalAddress(host)) {
            return true;
        }
        if (host.equals("localhost") || host.equals("localhost.")) {
            return true;
        }
        return host.endsWith(".localhost") || host.endsWith(".localhost.");
    }

    public static boolean isLocalAddress(String address) {
        if (address == null) {
            return false;
        }
        if (address.startsWith("[")) {
            return LOCALHOST_IPV6.matcher(address).matches();
        }
        return LOCALHOST_IPV4.matcher(address).matches();
    }
}

