/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.grants.ciba.CibaClientValidation;
import org.keycloak.protocol.oidc.mappers.PairwiseSubMapperHelper;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperUtils;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperValidator;
import org.keycloak.protocol.oidc.utils.SubjectType;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.validation.ClientValidationContext;
import org.keycloak.validation.ClientValidationProvider;
import org.keycloak.validation.ValidationContext;
import org.keycloak.validation.ValidationResult;

public class DefaultClientValidationProvider
implements ClientValidationProvider {
    public ValidationResult validate(ValidationContext<ClientModel> context) {
        this.validateUrls(context);
        this.validatePairwiseInClientModel(context);
        new CibaClientValidation(context).validate();
        this.validateJwks(context);
        this.validateDefaultAcrValues(context);
        return context.toResult();
    }

    public ValidationResult validate(ClientValidationContext.OIDCContext context) {
        this.validateUrls((ValidationContext<ClientModel>)context);
        this.validatePairwiseInOIDCClient(context);
        new CibaClientValidation((ValidationContext<ClientModel>)context).validate();
        this.validateDefaultAcrValues((ValidationContext<ClientModel>)context);
        return context.toResult();
    }

    private void validateUrls(ValidationContext<ClientModel> context) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        String authServerUrl = "https://localhost/auth";
        String rootUrl = ResolveRelative.resolveRootUrl(authServerUrl, authServerUrl, client.getRootUrl());
        String baseUrl = ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, authServerUrl, client.getBaseUrl());
        String backchannelLogoutUrl = OIDCAdvancedConfigWrapper.fromClientModel(client).getBackchannelLogoutUrl();
        String resolvedBackchannelLogoutUrl = ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, authServerUrl, backchannelLogoutUrl);
        this.checkUri(FieldMessages.ROOT_URL, rootUrl, context, true, true);
        this.checkUri(FieldMessages.BASE_URL, baseUrl, context, true, false);
        this.checkUri(FieldMessages.BACKCHANNEL_LOGOUT_URL, resolvedBackchannelLogoutUrl, context, true, false);
        client.getRedirectUris().stream().map(u -> ResolveRelative.resolveRelativeUri(authServerUrl, authServerUrl, rootUrl, u)).forEach(u -> this.checkUri(FieldMessages.REDIRECT_URIS, (String)u, context, false, true));
        this.checkUriLogo(FieldMessages.LOGO_URI, client.getAttribute("logoUri"), context);
        this.checkUri(FieldMessages.POLICY_URI, client.getAttribute("policyUri"), context, true, false);
        this.checkUri(FieldMessages.TOS_URI, client.getAttribute("tosUri"), context, true, false);
        if ("saml".equals(client.getProtocol())) {
            this.checkUri(FieldMessages.ADMIN_URL, client.getManagementUrl(), context, true, false);
            this.checkUri(FieldMessages.SAML_ASSERTION_CONSUMER_URL_POST_URI, client.getAttribute("saml_assertion_consumer_url_post"), context, true, false);
            this.checkUri(FieldMessages.SAML_ASSERTION_CONSUMER_URL_REDIRECT_URI, client.getAttribute("saml_assertion_consumer_url_redirect"), context, true, false);
            this.checkUri(FieldMessages.SAML_ASSERTION_CONSUMER_URL_ARTIFACT_URI, client.getAttribute("saml_artifact_binding_url"), context, true, false);
            this.checkUri(FieldMessages.SAML_SINGLE_LOGOUT_SERVICE_URL_POST_URI, client.getAttribute("saml_single_logout_service_url_post"), context, true, false);
            this.checkUri(FieldMessages.SAML_SINGLE_LOGOUT_SERVICE_URL_ARTIFACT_URI, client.getAttribute("saml_single_logout_service_url_artifact"), context, true, false);
            this.checkUri(FieldMessages.SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_URI, client.getAttribute("saml_single_logout_service_url_redirect"), context, true, false);
            this.checkUri(FieldMessages.SAML_SINGLE_LOGOUT_SERVICE_URL_SOAP_URI, client.getAttribute("saml_single_logout_service_url_soap"), context, true, false);
            this.checkUri(FieldMessages.SAML_ARTIFACT_RESOLUTION_SERVICE_URL_URI, client.getAttribute("saml_artifact_resolution_service_url"), context, true, false);
        }
    }

    private void checkUri(FieldMessages field, String url, ValidationContext<ClientModel> context, boolean checkValidUrl, boolean checkFragment) {
        if (url == null || url.isEmpty()) {
            return;
        }
        try {
            String urlToCheck = url;
            if (field == FieldMessages.BACKCHANNEL_LOGOUT_URL) {
                if (DefaultClientValidationProvider.checkCurlyBracketsBalanced(url)) {
                    urlToCheck = url.replace("{", "%7B").replace("}", "%7D");
                } else {
                    throw new MalformedURLException();
                }
            }
            URI uri = new URI(urlToCheck);
            boolean valid = true;
            if (uri.getScheme() != null && (uri.getScheme().equals("data") || uri.getScheme().equals("javascript"))) {
                context.addError(field.getFieldId(), field.getScheme(), field.getSchemeKey(), new Object[0]);
                valid = false;
            }
            if (checkFragment && uri.getFragment() != null) {
                context.addError(field.getFieldId(), field.getFragment(), field.getFragmentKey(), new Object[0]);
                valid = false;
            }
            if (checkValidUrl && valid) {
                uri.toURL();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            context.addError(field.getFieldId(), field.getInvalid(), field.getInvalidKey(), new Object[0]);
        }
    }

    public static boolean checkCurlyBracketsBalanced(String url) {
        ArrayDeque<Character> stack = new ArrayDeque<Character>();
        for (char singleLetter : url.toCharArray()) {
            char check;
            if (singleLetter == '{') {
                stack.push(Character.valueOf(singleLetter));
                continue;
            }
            if (stack.isEmpty() && singleLetter == '}') {
                return false;
            }
            if (singleLetter != '}' || (check = ((Character)stack.pop()).charValue()) == '{') continue;
            return false;
        }
        return stack.isEmpty();
    }

    private void checkUriLogo(FieldMessages field, String url, ValidationContext<ClientModel> context) {
        if (url == null || url.isEmpty()) {
            return;
        }
        try {
            URI uri = new URI(url);
            if (uri.getScheme() != null && uri.getScheme().equals("javascript")) {
                context.addError(field.getFieldId(), field.getScheme(), field.getSchemeKey(), new Object[0]);
            }
        }
        catch (URISyntaxException e) {
            context.addError(field.getFieldId(), field.getInvalid(), field.getInvalidKey(), new Object[0]);
        }
    }

    private void validatePairwiseInClientModel(ValidationContext<ClientModel> context) {
        List<ProtocolMapperRepresentation> foundPairwiseMappers = PairwiseSubMapperUtils.getPairwiseSubMappers(ModelToRepresentation.toRepresentation((ClientModel)((ClientModel)context.getObjectToValidate()), (KeycloakSession)context.getSession()));
        for (ProtocolMapperRepresentation foundPairwise : foundPairwiseMappers) {
            String sectorIdentifierUri = PairwiseSubMapperHelper.getSectorIdentifierUri(foundPairwise);
            this.validatePairwise(context, sectorIdentifierUri);
        }
    }

    private void validatePairwiseInOIDCClient(ClientValidationContext.OIDCContext context) {
        OIDCClientRepresentation oidcRep = context.getOIDCClient();
        SubjectType subjectType = SubjectType.parse(oidcRep.getSubjectType());
        String sectorIdentifierUri = oidcRep.getSectorIdentifierUri();
        if (SubjectType.PAIRWISE == subjectType || sectorIdentifierUri != null && !sectorIdentifierUri.isEmpty()) {
            this.validatePairwise((ValidationContext<ClientModel>)context, oidcRep.getSectorIdentifierUri());
        }
    }

    private void validatePairwise(ValidationContext<ClientModel> context, String sectorIdentifierUri) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        String rootUrl = client.getRootUrl();
        HashSet<String> redirectUris = new HashSet<String>();
        if (client.getRedirectUris() != null) {
            redirectUris.addAll(client.getRedirectUris());
        }
        try {
            PairwiseSubMapperValidator.validate(context.getSession(), rootUrl, redirectUris, sectorIdentifierUri);
        }
        catch (ProtocolMapperConfigException e) {
            context.addError("pairWise", e.getMessage(), e.getMessageKey(), new Object[0]);
        }
    }

    private void validateJwks(ValidationContext<ClientModel> context) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        if (Boolean.parseBoolean(client.getAttribute("use.jwks.url")) && Boolean.parseBoolean(client.getAttribute("use.jwks.string"))) {
            context.addError("jwksUrl", "Illegal to use both jwks_uri and jwks_string", "duplicatedJwksSettings", new Object[0]);
        }
    }

    private void validateDefaultAcrValues(ValidationContext<ClientModel> context) {
        ClientModel client = (ClientModel)context.getObjectToValidate();
        List<String> defaultAcrValues = AcrUtils.getDefaultAcrValues(client);
        Map<String, Integer> acrToLoaMap = AcrUtils.getAcrLoaMap(client);
        if (acrToLoaMap.isEmpty()) {
            acrToLoaMap = AcrUtils.getAcrLoaMap(client.getRealm());
        }
        for (String configuredAcr : defaultAcrValues) {
            if (acrToLoaMap.containsKey(configuredAcr) || LoAUtil.getLoAConfiguredInRealmBrowserFlow(client.getRealm()).anyMatch(level -> configuredAcr.equals(String.valueOf(level)))) continue;
            context.addError("defaultAcrValues", "Default ACR values need to contain values specified in the ACR-To-Loa mapping or number levels from set realm browser flow");
        }
    }

    private static enum FieldMessages {
        ROOT_URL("rootUrl", "Root URL is not a valid URL", "clientRootURLInvalid", "Root URL must not contain an URL fragment", "clientRootURLFragmentError", "Root URL uses an illegal scheme", "clientRootURLIllegalSchemeError"),
        BASE_URL("baseUrl", "Base URL is not a valid URL", "clientBaseURLInvalid", null, null, "Base URL uses an illegal scheme", "clientBaseURLIllegalSchemeError"),
        REDIRECT_URIS("redirectUris", "A redirect URI is not a valid URI", "clientRedirectURIsInvalid", "Redirect URIs must not contain an URI fragment", "clientRedirectURIsFragmentError", "A redirect URI uses an illegal scheme", "clientRedirectURIsIllegalSchemeError"),
        BACKCHANNEL_LOGOUT_URL("backchannelLogoutUrl", "Backchannel logout URL is not a valid URL", "backchannelLogoutUrlIsInvalid", null, null, "Backchannel logout URL uses an illegal scheme", "backchannelLogoutUrlIllegalSchemeError"),
        LOGO_URI("logoUri", "Logo URL is not a valid URL", "logoURLInvalid", null, null, "Logo URL uses an illegal scheme", "logoURLIllegalSchemeError"),
        POLICY_URI("policyUri", "Policy URL is not a valid URL", "policyURLInvalid", null, null, "Policy URL uses an illegal scheme", "policyURLIllegalSchemeError"),
        TOS_URI("tosUri", "Terms of service URL is not a valid URL", "tosURLInvalid", null, null, "Terms of service URL uses an illegal scheme", "tosURLIllegalSchemeError"),
        ADMIN_URL("masterSamlProcessingUrl", "Master SAML Processing URL is not a valid URL", "adminUrlURLInvalid", null, null, "Master SAML Processing URL uses an illegal scheme", "adminUrlURLIllegalSchemeError"),
        SAML_ASSERTION_CONSUMER_URL_POST_URI("saml_assertion_consumer_url_post", "Assertion Consumer Service POST Binding URL is not a valid URL", "samlAssertionConsumerUrlPostURLInvalid", null, null, "Assertion Consumer Service POST Binding URL uses an illegal scheme", "samlAssertionConsumerUrlPostURLIllegalSchemeError"),
        SAML_ASSERTION_CONSUMER_URL_REDIRECT_URI("saml_assertion_consumer_url_redirect", "Assertion Consumer Service Redirect Binding URL is not a valid URL", "samlAssertionConsumerUrlRedirectURLInvalid", null, null, "Assertion Consumer Service Redirect Binding URL uses an illegal scheme", "samlAssertionConsumerUrlRedirectURLIllegalSchemeError"),
        SAML_ASSERTION_CONSUMER_URL_ARTIFACT_URI("saml_artifact_binding_url", "Artifact Binding URL is not a valid URL", "samlAssertionConsumerUrlArtifactURLInvalid", null, null, "Artifact Binding URL uses an illegal scheme", "samlAssertionConsumerUrlArtifactURLIllegalSchemeError"),
        SAML_SINGLE_LOGOUT_SERVICE_URL_POST_URI("saml_single_logout_service_url_post", "Logout Service POST Binding URL is not a valid URL", "samlLogoutServiceUrlPostURLInvalid", null, null, "Logout Service POST Binding URL uses an illegal scheme", "samlLogoutServiceUrlPostURLIllegalSchemeError"),
        SAML_SINGLE_LOGOUT_SERVICE_URL_ARTIFACT_URI("saml_single_logout_service_url_artifact", "Logout Service ARTIFACT Binding URL is not a valid URL", "samlLogoutServiceUrlArtifactURLInvalid", null, null, "Logout Service ARTIFACT Binding URL uses an illegal scheme", "samlLogoutServiceUrlArtifactURLIllegalSchemeError"),
        SAML_SINGLE_LOGOUT_SERVICE_URL_REDIRECT_URI("saml_single_logout_service_url_redirect", "Logout Service Redirect Binding URL is not a valid URL", "samlLogoutServiceUrlRedirectURLInvalid", null, null, "Logout Service Redirect Binding URL uses an illegal scheme", "samlLogoutServiceUrlRedirectURLIllegalSchemeError"),
        SAML_SINGLE_LOGOUT_SERVICE_URL_SOAP_URI("saml_single_logout_service_url_soap", "Logout Service SOAP Binding URL is not a valid URL", "samlLogoutServiceUrlSoapURLInvalid", null, null, "Logout Service SOAP Binding URL uses an illegal scheme", "samlAssertionConsumerUrlPostURLIllegalSchemeError"),
        SAML_ARTIFACT_RESOLUTION_SERVICE_URL_URI("saml_artifact_resolution_service_url", "Artifact Resolution Service is not a valid URL", "samlAssertionConsumerUrlPostURLInvalid", null, null, "Artifact Resolution Service uses an illegal scheme", "samlAssertionConsumerUrlPostURLIllegalSchemeError");

        private String fieldId;
        private String invalid;
        private String invalidKey;
        private String fragment;
        private String fragmentKey;
        private String scheme;
        private String schemeKey;

        private FieldMessages(String fieldId, String invalid, String invalidKey, String fragment, String fragmentKey, String scheme, String schemeKey) {
            this.fieldId = fieldId;
            this.invalid = invalid;
            this.invalidKey = invalidKey;
            this.fragment = fragment;
            this.fragmentKey = fragmentKey;
            this.scheme = scheme;
            this.schemeKey = schemeKey;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getInvalid() {
            return this.invalid;
        }

        public String getInvalidKey() {
            return this.invalidKey;
        }

        public String getFragment() {
            return this.fragment;
        }

        public String getFragmentKey() {
            return this.fragmentKey;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getSchemeKey() {
            return this.schemeKey;
        }
    }
}

