/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.Config;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.Environment;
import org.keycloak.common.util.UriUtils;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.Urls;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminCorsPreflightService;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.util.Chunk;
import org.keycloak.services.util.ViteManifest;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.SecureContextResolver;

public class AdminConsole {
    protected static final Logger logger = Logger.getLogger(AdminConsole.class);
    protected final ClientConnection clientConnection;
    protected final HttpRequest request;
    protected final HttpResponse response;
    protected final KeycloakSession session;
    protected final RealmModel realm;

    public AdminConsole(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.clientConnection = session.getContext().getConnection();
        this.request = session.getContext().getHttpRequest();
        this.response = session.getContext().getHttpResponse();
    }

    @Path(value="config")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ClientManager.InstallationAdapterConfig config() {
        ClientModel consoleApp = this.realm.getClientByClientId("security-admin-console");
        if (consoleApp == null) {
            throw new NotFoundException("Could not find admin console client");
        }
        return new ClientManager(new RealmManager(this.session)).toInstallationRepresentation(this.realm, consoleApp, this.session.getContext().getUri().getBaseUri());
    }

    @Path(value="whoami")
    @OPTIONS
    public Response whoAmIPreFlight() {
        return new AdminCorsPreflightService().preflight();
    }

    @Path(value="whoami")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response whoAmI(@QueryParam(value="currentRealm") String currentRealm) {
        String displayName;
        UserModel user;
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_API)) {
            throw new NotFoundException();
        }
        RealmManager realmManager = new RealmManager(this.session);
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(this.realm).setConnection(this.clientConnection).setHeaders(this.session.getContext().getRequestHeaders()).authenticate();
        if (authResult == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        String issuedFor = authResult.getToken().getIssuedFor();
        if (!"security-admin-console".equals(issuedFor)) {
            if (issuedFor == null) {
                throw new ForbiddenException("No azp claim in the token");
            }
            ClientModel client = this.session.clients().getClientByClientId(this.realm, issuedFor);
            if (client == null || !Boolean.parseBoolean(client.getAttribute("security.admin.console"))) {
                throw new ForbiddenException("Token issued for an application that is not the admin console: " + issuedFor);
            }
        }
        if ((user = authResult.getUser()).getFirstName() != null && !user.getFirstName().trim().equals("") || user.getLastName() != null && !user.getLastName().trim().equals("")) {
            displayName = user.getFirstName();
            if (user.getLastName() != null) {
                displayName = displayName != null ? displayName + " " + user.getLastName() : user.getLastName();
            }
        } else {
            displayName = user.getUsername();
        }
        RealmModel masterRealm = this.getAdminstrationRealm(realmManager);
        HashMap<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();
        if (masterRealm == null) {
            throw new NotFoundException("No realm found");
        }
        boolean createRealm = false;
        if (this.realm.equals(masterRealm)) {
            logger.debug((Object)"setting up realm access for a master realm user");
            RoleModel createRealmRole = masterRealm.getRole(AdminRoles.CREATE_REALM);
            if (createRealmRole != null) {
                createRealm = user.hasRole(createRealmRole);
            }
            this.addMasterRealmAccess(user, currentRealm != null ? currentRealm : this.realm.getName(), realmAccess);
        } else {
            logger.debug((Object)"setting up realm access for a realm user");
            this.addRealmAccess(this.realm, user, realmAccess);
        }
        if (realmAccess.isEmpty() || ((Set)realmAccess.values().iterator().next()).isEmpty()) {
            throw new ForbiddenException("No realm access");
        }
        Locale locale = this.session.getContext().resolveLocale(user);
        return Cors.builder().allowedOrigins(authResult.getToken()).allowedMethods(new String[]{"GET"}).auth().add(Response.ok((Object)new WhoAmI(user.getId(), this.realm.getName(), displayName, createRealm, realmAccess, locale, Boolean.parseBoolean(user.getFirstAttribute("is_temporary_admin")))));
    }

    private void addRealmAccess(RealmModel realm, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        RealmManager realmManager = new RealmManager(this.session);
        ClientModel realmAdminApp = realm.getClientByClientId(realmManager.getRealmAdminClientId(realm));
        this.getRealmAdminAccess(realm, realmAdminApp, user, realmAdminAccess);
    }

    private void addMasterRealmAccess(UserModel user, String currentRealm, Map<String, Set<String>> realmAdminAccess) {
        RealmModel realm = this.session.realms().getRealmByName(currentRealm);
        if (realm == null) {
            throw new NotFoundException("Realm not found");
        }
        this.getRealmAdminAccess(realm, realm.getMasterAdminClient(), user, realmAdminAccess);
    }

    private void getRealmAdminAccess(RealmModel realm, ClientModel client, UserModel user, Map<String, Set<String>> realmAdminAccess) {
        Set realmRoles = client.getRolesStream().filter(arg_0 -> ((UserModel)user).hasRole(arg_0)).map(RoleModel::getName).collect(Collectors.toSet());
        realmAdminAccess.put(realm.getName(), realmRoles);
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout() {
        URI redirect = AdminRoot.adminConsoleUrl((UriInfo)this.session.getContext().getUri(UrlType.ADMIN)).build(new Object[]{this.realm.getName()});
        return Response.status((int)302).location(OIDCLoginProtocolService.logoutUrl((UriInfo)this.session.getContext().getUri(UrlType.ADMIN)).queryParam("post_logout_redirect_uri", new Object[]{redirect.toString()}).build(new Object[]{this.realm.getName()})).build();
    }

    protected RealmModel getAdminstrationRealm(RealmManager realmManager) {
        return realmManager.getKeycloakAdminstrationRealm();
    }

    @GET
    @NoCache
    public Response getMainPage() throws IOException, FreeMarkerException {
        String devServerUrl;
        KeycloakUriInfo baseUriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        KeycloakUriInfo adminUriInfo = this.session.getContext().getUri(UrlType.ADMIN);
        if (!adminUriInfo.getRequestUri().getPath().endsWith("/")) {
            return Response.status((int)302).location(adminUriInfo.getRequestUriBuilder().path("/").build(new Object[0])).build();
        }
        URI serverBaseUri = baseUriInfo.getBaseUri();
        URI adminBaseUri = adminUriInfo.getBaseUri();
        String serverBaseUrl = serverBaseUri.toString().replaceFirst("/+$", "");
        String adminBaseUrl = adminBaseUri.toString().replaceFirst("/+$", "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Theme theme = AdminRoot.getTheme(this.session, this.realm);
        boolean isSecureContext = SecureContextResolver.isSecureContext(this.session);
        map.put("isSecureContext", isSecureContext);
        map.put("serverBaseUrl", serverBaseUrl);
        map.put("adminBaseUrl", adminBaseUrl);
        map.put("authServerUrl", serverBaseUrl);
        map.put("authUrl", adminBaseUrl);
        map.put("consoleBaseUrl", Urls.adminConsoleRoot(adminBaseUri, this.realm.getName()).getPath());
        map.put("resourceUrl", Urls.themeRoot(adminBaseUri).getPath() + "/admin/" + theme.getName());
        map.put("resourceCommonUrl", Urls.themeRoot(adminBaseUri).getPath() + "/common/keycloak");
        map.put("masterRealm", Config.getAdminRealm());
        map.put("resourceVersion", Version.RESOURCES_VERSION);
        map.put("loginRealm", this.realm.getName());
        map.put("clientId", "security-admin-console");
        map.put("properties", theme.getProperties());
        map.put("darkMode", "true".equals(theme.getProperties().getProperty("darkMode")) && this.realm.getAttribute("darkMode", Boolean.valueOf(true)) != false);
        String string = devServerUrl = Environment.isDevMode() ? System.getenv("KC_ADMIN_VITE_URL") : null;
        if (devServerUrl != null) {
            map.put("devServerUrl", devServerUrl);
        }
        InputStream manifestFile = theme.getResourceAsStream(".vite/manifest.json");
        if (devServerUrl == null && manifestFile != null) {
            ViteManifest manifest = ViteManifest.parseFromInputStream(manifestFile);
            Chunk entryChunk = manifest.getEntryChunk();
            String[] entryStyles = entryChunk.css().orElse(new String[0]);
            String entryScript = entryChunk.file();
            String[] entryImports = entryChunk.imports().orElse(new String[0]);
            map.put("entryStyles", entryStyles);
            map.put("entryScript", entryScript);
            map.put("entryImports", entryImports);
        }
        FreeMarkerProvider freeMarkerUtil = (FreeMarkerProvider)this.session.getProvider(FreeMarkerProvider.class);
        String result = freeMarkerUtil.processTemplate(map, "index.ftl", theme);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).type("text/html; charset=utf-8").language(Locale.ENGLISH).entity((Object)result);
        if (!adminBaseUri.equals(serverBaseUri)) {
            ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().allowFrameSrc(UriUtils.getOrigin((URI)serverBaseUri));
        }
        return builder.build();
    }

    @GET
    @Path(value="{indexhtml: index.html}")
    public Response getIndexHtmlRedirect() {
        return Response.status((int)302).location(this.session.getContext().getUri(UrlType.ADMIN).getRequestUriBuilder().path("../").build(new Object[0])).build();
    }

    @GET
    @Path(value="messages.json")
    @Produces(value={"application/json"})
    public Properties getMessages(@QueryParam(value="lang") String lang) {
        return AdminRoot.getMessages(this.session, this.realm, lang, new String[]{"admin-messages"});
    }

    public static class WhoAmI {
        protected String userId;
        protected String realm;
        protected String displayName;
        protected Locale locale;
        protected boolean isTemporary;
        @JsonProperty(value="createRealm")
        protected boolean createRealm;
        @JsonProperty(value="realm_access")
        protected Map<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();

        public WhoAmI() {
        }

        public WhoAmI(String userId, String realm, String displayName, boolean createRealm, Map<String, Set<String>> realmAccess, Locale locale, boolean isTemporary) {
            this.userId = userId;
            this.realm = realm;
            this.displayName = displayName;
            this.createRealm = createRealm;
            this.realmAccess = realmAccess;
            this.locale = locale;
            this.isTemporary = isTemporary;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isCreateRealm() {
            return this.createRealm;
        }

        public void setCreateRealm(boolean createRealm) {
            this.createRealm = createRealm;
        }

        public Map<String, Set<String>> getRealmAccess() {
            return this.realmAccess;
        }

        public void setRealmAccess(Map<String, Set<String>> realmAccess) {
            this.realmAccess = realmAccess;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        @JsonProperty(value="locale")
        public String getLocaleLanguageTag() {
            return this.locale != null ? this.locale.toLanguageTag() : null;
        }

        public boolean isTemporary() {
            return this.isTemporary;
        }

        public void setTemporary(boolean temporary) {
            this.isTemporary = temporary;
        }
    }
}

