/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.credential.CredentialInput;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.freemarker.model.TotpBean;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.services.validation.Validation;

public class ConsoleUpdateTotp
implements RequiredActionProvider {
    public static final ConsoleUpdateTotp SINGLETON = new ConsoleUpdateTotp();

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        TotpBean totpBean = new TotpBean(context.getSession(), context.getRealm(), context.getUser(), context.getUriInfo().getRequestUriBuilder());
        String totpSecret = totpBean.getTotpSecret();
        context.getAuthenticationSession().setAuthNote("totpSecret", totpSecret);
        Response challenge = this.challenge(context).form().setAttribute("totp", (Object)totpBean).createForm("login-config-totp-text.ftl");
        context.challenge(challenge);
    }

    protected ConsoleDisplayMode challenge(RequiredActionContext context) {
        return ConsoleDisplayMode.challenge((RequiredActionContext)context).header().param("totp").label("console-otp").challenge();
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_TOTP);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = context.getAuthenticationSession().getAuthNote("totpSecret");
        if (Validation.isBlank(totp)) {
            context.challenge(this.challenge(context).message("missingTotpMessage", new String[0]));
            return;
        }
        if (!CredentialValidation.validOTP((RealmModel)context.getRealm(), (String)totp, (String)totpSecret)) {
            context.challenge(this.challenge(context).message("invalidTotpMessage", new String[0]));
            return;
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType(context.getRealm().getOTPPolicy().getType());
        credentials.setValue(totpSecret);
        context.getSession().userCredentialManager().updateCredential(context.getRealm(), context.getUser(), (CredentialInput)credentials);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType(context.getRealm().getOTPPolicy().getType());
        cred.setValue(totp);
        context.getSession().userCredentialManager().isValid(context.getRealm(), context.getUser(), new CredentialInput[]{cred});
        context.getAuthenticationSession().removeAuthNote("totpSecret");
        context.success();
    }

    public void close() {
    }
}

