/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class HardcodedAttributeMapper
extends AbstractIdentityProviderMapper {
    public static final String ATTRIBUTE = "attribute";
    public static final String ATTRIBUTE_VALUE = "attribute.value";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String[] COMPATIBLE_PROVIDERS;
    public static final String PROVIDER_ID = "hardcoded-attribute-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Hardcoded Attribute";
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(ATTRIBUTE);
        String attributeValue = (String)mapperModel.getConfig().get(ATTRIBUTE_VALUE);
        context.setUserAttribute(attribute, attributeValue);
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(ATTRIBUTE);
        String attributeValue = (String)mapperModel.getConfig().get(ATTRIBUTE_VALUE);
        user.setSingleAttribute(attribute, attributeValue);
    }

    public String getHelpText() {
        return "When user is imported from provider, hardcode a value to a specific user attribute.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE);
        property.setLabel("User Attribute");
        property.setHelpText("Name of user attribute you want to hardcode");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_VALUE);
        property.setLabel("User Attribute Value");
        property.setHelpText("Value you want to hardcode");
        property.setType("String");
        configProperties.add(property);
        COMPATIBLE_PROVIDERS = new String[]{"*"};
    }
}

